set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9628992';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-2-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.843177,
      0.166854,
      2.614747,
      1,
      2.386988,
      2.482676,
      2,
      0.213523,
      '224',
      '30443343',
      27,
      59.500201,
      '4414343',
      0.427333,
      1.973173,
      3,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      25,
      73.181528,
      NULL,
      1,
      2.128254,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.741835,
      '10-14-2001',
      ' 2- 0-1980',
      ' 0-23-1994',
      3,
      1.292539,
      1,
      2,
      3,
      1.888959,
      0,
      3,
      NULL,
      NULL,
      NULL,
      3.848313,
      5.574794,
      NULL,
      NULL,
      NULL,
      NULL,
      2.192425,
      0,
      NULL,
      1.233721,
      1.851540,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.592668,
      1,
      NULL,
      0,
      4.836867,
      3.062241,
      8.914663,
      1,
      2,
      1,
      NULL,
      3.603150,
      NULL,
      10.808681,
      0.258086,
      0.940630,
      4.944164,
      1,
      2.563372,
      3.450962,
      NULL,
      1,
      4.197415,
      0.930214,
      1.430310,
      0,
      NULL,
      NULL,
      1.669385,
      NULL,
      NULL,
      8.946252,
      1,
      NULL,
      1,
      1.522488,
      0.702431,
      NULL,
      0,
      1,
      0.774420,
      1.603541,
      0,
      0,
      2.106937,
      NULL,
      NULL,
      2,
      3.638902,
      1.112220,
      NULL,
      1,
      NULL,
      4,
      NULL,
      2.711610,
      2.670623,
      0.745181,
      NULL,
      NULL,
      0.826951,
      NULL,
      NULL,
      0.394359,
      5.783582,
      0.287843,
      0.951808,
      NULL,
      NULL,
      8,
      0.774575,
      1.583326,
      NULL,
      NULL,
      3.858126,
      1.687928,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      1.980619,
      1.395294,
      3.716501,
      0,
      1.257923,
      0,
      NULL,
      1.713858,
      1,
      1,
      5,
      5,
      0.826980,
      NULL,
      3,
      5.571294,
      1,
      3,
      0.010812,
      NULL,
      NULL,
      1,
      NULL,
      7.136687,
      2.939480,
      NULL,
      6.296072,
      1.244944,
      NULL,
      249.195547,
      ' 1-16-1989',
      709,
      1.561496,
      1.231916,
      0,
      1.914882,
      0.902890,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.062960,
      1.773896,
      0,
      1,
      2,
      3.882933,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.906373,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.170529,
      0,
      5.419479,
      1,
      1,
      6.746610,
      1.012400,
      NULL,
      NULL,
      NULL,
      1.735818,
      0.206515,
      1.713502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.701539,
      1.986682,
      0,
      0,
      0,
      NULL,
      0,
      1,
      39.214019,
      1.401545,
      0,
      NULL,
      NULL,
      NULL,
      1.299212,
      0,
      0.101489,
      0.960300,
      3,
      2.150583,
      1.137041,
      0,
      0.901614,
      0.441959,
      NULL,
      1,
      NULL,
      3.971550,
      NULL,
      2.955656,
      NULL,
      1,
      3.712410,
      1,
      1,
      0.089531,
      0.720007,
      0,
      NULL,
      0.182317,
      1.124923,
      1,
      1.171469,
      0.933654,
      1.903026,
      0,
      2,
      2.222565,
      3,
      3,
      0,
      7.395209,
      5.163598,
      NULL,
      1.066111,
      NULL,
      NULL,
      0.026144,
      11.550943,
      1,
      0.394506,
      19,
      NULL,
      12,
      NULL,
      4,
      1,
      0,
      '14433',
      '',
      '',
      0,
      NULL,
      '',
      '',
      0.169017,
      '1234',
      '',
      '',
      1,
      30,
      NULL,
      11.406269,
      0.044084,
      37,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2.498244,
      0.653405,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.710040,
      1.740626,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.969623,
      1.604287,
      2.024933,
      2,
      1.512738,
      1.304044,
      1,
      NULL,
      0.347633,
      3,
      1.816108,
      3,
      1.208369,
      NULL,
      0.188187,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.488148,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1.772556,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.493997,
      1,
      1,
      3.948460,
      NULL,
      1,
      0.186080,
      NULL,
      1,
      0,
      NULL,
      NULL,
      2,
      2,
      NULL,
      2.652887,
      1,
      0,
      0.971112,
      1.195439,
      NULL,
      NULL,
      3,
      NULL,
      0.595434,
      NULL,
      0.710242,
      5,
      NULL,
      0.408703,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.184980,
      NULL,
      NULL,
      0.332702,
      1,
      0.341051,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      3,
      0,
      NULL,
      3.028627,
      NULL,
      3,
      5.105461,
      0,
      4.475757,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.917772,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.529341,
      NULL,
      NULL,
      3,
      1.766171,
      NULL,
      NULL,
      0.159912,
      1.152350,
      0.604357,
      1,
      4,
      NULL,
      1,
      3,
      1.277726,
      NULL,
      NULL,
      NULL,
      NULL,
      3.423944,
      NULL,
      NULL,
      NULL,
      6.989900,
      1,
      NULL,
      3,
      NULL,
      1,
      3,
      0,
      0,
      3.434423,
      1,
      NULL,
      2,
      1,
      NULL,
      9,
      0,
      NULL,
      3,
      1.265628,
      1,
      1,
      3,
      4,
      0.954785,
      0.996416,
      1.963534,
      NULL,
      0,
      1.021040,
      NULL,
      NULL,
      1.759178,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.605338,
      NULL,
      NULL,
      0.477318,
      NULL,
      NULL,
      0.152819,
      NULL,
      NULL,
      2.247061,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0,
      1.456007,
      1,
      0,
      0.748096,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.384008,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.256771,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.994798,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.069157,
      NULL,
      NULL,
      NULL,
      NULL,
      0.096556,
      NULL,
      NULL,
      0.892916,
      NULL,
      1.274671,
      NULL,
      NULL,
      0.343182,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.843936,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      220,
      6.338949,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.970890,
      NULL,
      1.057517,
      0,
      0.630666,
      0.912681,
      1.974224,
      1.774550,
      0,
      1.849490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.870530,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.847570,
      2,
      2,
      7,
      3.047481,
      3,
      NULL,
      3,
      2.245012,
      2.707358,
      1.521815,
      0,
      2.469727,
      2,
      NULL,
      1.304402,
      0,
      NULL,
      0,
      2.396621,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.090167,
      NULL,
      NULL,
      3,
      NULL,
      3.375525,
      1.126456,
      NULL,
      3,
      NULL,
      NULL,
      1.802117,
      3.703417,
      NULL,
      NULL,
      0.230036,
      NULL,
      2,
      1,
      0.936739,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.522625,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.772301,
      NULL,
      0.280672,
      NULL,
      NULL,
      NULL,
      6,
      11.871448,
      8.560800,
      0,
      0,
      3,
      NULL,
      65,
      0,
      5.299921,
      1.290004,
      '43103',
      '',
      '',
      0.045181,
      '',
      '',
      '',
      3,
      NULL,
      '',
      '');
commit;
end;
/


