set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7807074';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-9-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      NULL,
      2,
      1.295834,
      0,
      2,
      NULL,
      0.058339,
      1.481676,
      NULL,
      NULL,
      ' 5- 8-1980',
      72,
      NULL,
      1,
      NULL,
      0.473448,
      ' 3-18-1998',
      29,
      1,
      163.228531,
      119.431487,
      NULL,
      ' 8- 1-2000',
      '10- 7-2001',
      NULL,
      2,
      0,
      3.817701,
      0,
      0.654376,
      1.335425,
      3.076657,
      0.489954,
      0,
      199,
      NULL,
      12.468925,
      9.638659,
      0.988430,
      10,
      7.512617,
      25,
      3,
      0,
      9.156374,
      1,
      1.106570,
      1,
      0,
      NULL,
      1.539990,
      0,
      1.304019,
      0.858202,
      0.099963,
      NULL,
      9.773573,
      5.359104,
      NULL,
      1.782829,
      6.714555,
      1,
      3,
      2,
      1,
      0.007675,
      0.664425,
      0,
      NULL,
      3.563268,
      NULL,
      0.356402,
      NULL,
      1.713608,
      4.623712,
      1.209538,
      0,
      0,
      NULL,
      NULL,
      0.571263,
      NULL,
      NULL,
      0,
      1.444603,
      0,
      1.933217,
      NULL,
      0,
      0.620351,
      3,
      1,
      NULL,
      1.124325,
      0.875784,
      0.202889,
      NULL,
      NULL,
      3,
      1.704297,
      0.611587,
      NULL,
      0.679303,
      0.844184,
      NULL,
      9,
      1,
      5,
      0.922934,
      0.382588,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      4.307385,
      0.585432,
      7,
      6,
      4.939450,
      1,
      NULL,
      8.735051,
      0.780625,
      0,
      1.659018,
      2.845596,
      NULL,
      1,
      0.734229,
      0.587591,
      0.234733,
      NULL,
      0,
      7.148209,
      0.265744,
      0,
      1,
      1,
      0.177865,
      3,
      1,
      3,
      5.559765,
      NULL,
      NULL,
      NULL,
      3.865325,
      5.064491,
      3.193326,
      8,
      NULL,
      NULL,
      2.354797,
      6,
      NULL,
      NULL,
      1,
      0,
      5.727772,
      1.041113,
      ' 0-24-1996',
      NULL,
      NULL,
      80,
      0,
      NULL,
      0,
      3.794055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.502116,
      1.733621,
      0.607178,
      NULL,
      0.100885,
      1.028200,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.412540,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      0.341128,
      3,
      1,
      2.617245,
      8.317744,
      NULL,
      NULL,
      NULL,
      NULL,
      0.431005,
      5.107123,
      1.969903,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.603842,
      0.513612,
      0,
      1.787514,
      0.062888,
      1,
      NULL,
      3.510862,
      99,
      NULL,
      1,
      24.508783,
      3.136052,
      144.245539,
      1.179927,
      0.152078,
      0,
      1,
      1,
      0,
      NULL,
      3.590735,
      NULL,
      3,
      3,
      1,
      0,
      0.147717,
      1,
      2,
      NULL,
      NULL,
      0.555108,
      2.422405,
      0,
      0.016335,
      0.497506,
      NULL,
      0.947276,
      1.034553,
      1,
      1.281767,
      0.162740,
      NULL,
      1.072394,
      0,
      11,
      9,
      4.863244,
      NULL,
      4.084103,
      0,
      4,
      3.711215,
      4,
      1,
      2.926656,
      3,
      7,
      0,
      0,
      NULL,
      62.049073,
      38.958766,
      NULL,
      5,
      1.187591,
      1,
      '30002',
      NULL,
      '',
      1.199941,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      2,
      1.792554,
      259.314446,
      5.354750,
      3,
      NULL,
      17,
      NULL,
      NULL,
      2.221037,
      NULL,
      2.690578,
      0.244986,
      NULL,
      NULL,
      2,
      NULL,
      0.226289,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.183814,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      2.245802,
      0,
      0,
      0,
      0,
      1.692387,
      1.081264,
      1.522793,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      0.805671,
      2.669277,
      1.505781,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.612662,
      1,
      1.792996,
      3.449957,
      0.869787,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0.093169,
      NULL,
      NULL,
      0.330828,
      1,
      1,
      0,
      0.844124,
      0.826323,
      0,
      1.949201,
      1,
      0.179058,
      1,
      3,
      1.539096,
      0,
      NULL,
      NULL,
      NULL,
      1.583343,
      1,
      0,
      NULL,
      0.454513,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.846882,
      1.034356,
      NULL,
      NULL,
      1,
      0.692420,
      1.342055,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      8.257531,
      0.774893,
      1.670305,
      1.673591,
      0.204674,
      0.053319,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.906946,
      NULL,
      NULL,
      1.047453,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.557631,
      2,
      3,
      1,
      0,
      3.421088,
      5.257680,
      0.267586,
      5,
      0.362547,
      2,
      0,
      NULL,
      2.462144,
      1,
      1,
      NULL,
      0,
      3.687873,
      NULL,
      3,
      NULL,
      0.170095,
      1,
      1,
      7,
      5,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.040502,
      0,
      0,
      0.446046,
      0.086378,
      2,
      0.825962,
      NULL,
      2,
      2,
      3.690502,
      NULL,
      3,
      2,
      5,
      8,
      0.603395,
      0.185484,
      0,
      0.873807,
      1,
      1.842538,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.883943,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.516508,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.242664,
      NULL,
      NULL,
      0.265882,
      NULL,
      NULL,
      1.669082,
      NULL,
      NULL,
      NULL,
      0,
      2.610672,
      0,
      0,
      3,
      0.793765,
      9.465256,
      NULL,
      3.041137,
      NULL,
      5.871986,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.423027,
      NULL,
      1.043000,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3.228687,
      NULL,
      0.057856,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.665725,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.982584,
      NULL,
      NULL,
      NULL,
      1.146818,
      NULL,
      3.824244,
      NULL,
      3,
      NULL,
      0,
      NULL,
      2,
      NULL,
      0.930944,
      NULL,
      3.082041,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1,
      NULL,
      9.777280,
      NULL,
      7,
      NULL,
      1.660162,
      NULL,
      NULL,
      2,
      4,
      NULL,
      0,
      7.310592,
      17,
      1.878098,
      61.936658,
      10,
      1.695116,
      NULL,
      NULL,
      2,
      1.332763,
      1.335483,
      3.006399,
      9,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      607.025785,
      5.472906,
      0.545151,
      0,
      NULL,
      1.100284,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      1.800779,
      NULL,
      1,
      1,
      0,
      1,
      1.708329,
      1,
      NULL,
      3,
      NULL,
      0.028663,
      NULL,
      0.527615,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1.204747,
      1.234885,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1.996094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.413471,
      NULL,
      0.852827,
      NULL,
      1,
      NULL,
      0.039283,
      NULL,
      1.896367,
      NULL,
      1.309868,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.363545,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.151248,
      1.677097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.318153,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.176857,
      NULL,
      1.565427,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.099224,
      NULL,
      1.687104,
      NULL,
      1.105289,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.616943,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      3.813097,
      7.867376,
      6.603689,
      NULL,
      4.988334,
      2,
      0.443208,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      3,
      NULL,
      0.770393,
      1,
      NULL,
      2.342036,
      0,
      NULL,
      0.996745,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.014478,
      1.459307,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.410419,
      NULL,
      NULL,
      0.120216,
      NULL,
      0.169049,
      NULL,
      1,
      NULL,
      2,
      NULL,
      2,
      NULL,
      3.268230,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.860663,
      NULL,
      3,
      NULL,
      1.247687,
      NULL,
      1.953891,
      NULL,
      2.383236,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      7.136066,
      4,
      NULL,
      2,
      NULL,
      3.750002,
      NULL,
      NULL,
      0.577531,
      0,
      NULL,
      '33343',
      '02122',
      '',
      1,
      '43243',
      '',
      NULL,
      0.094916,
      '',
      NULL,
      '');
commit;
end;
/


