set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8921944';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-8-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      '1223123',
      3,
      NULL,
      1,
      3,
      '0302',
      2,
      1,
      NULL,
      NULL,
      ' 6- 3-1997',
      47,
      NULL,
      3.974750,
      2.814187,
      1,
      ' 6- 4-1982',
      46,
      0,
      NULL,
      96.578703,
      NULL,
      ' 0-24-1986',
      ' 1- 7-1997',
      NULL,
      0.035647,
      NULL,
      NULL,
      1,
      0.953519,
      0,
      0.473702,
      NULL,
      NULL,
      9.461907,
      1.707797,
      3.199086,
      NULL,
      NULL,
      8.098883,
      0,
      NULL,
      1.541236,
      3,
      0.808986,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.635677,
      1.511860,
      2,
      2.308548,
      NULL,
      NULL,
      NULL,
      1,
      0,
      6.732077,
      1,
      1,
      0.960160,
      NULL,
      NULL,
      4.067657,
      1,
      4,
      0,
      0.841352,
      0.776515,
      NULL,
      NULL,
      0.287967,
      NULL,
      NULL,
      3,
      0,
      1.594312,
      0.005589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.015553,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.507480,
      1.283109,
      NULL,
      0.023411,
      7.996280,
      2.700816,
      1,
      NULL,
      0.043110,
      0,
      1,
      NULL,
      NULL,
      3.400506,
      NULL,
      NULL,
      1.742983,
      1,
      0.808049,
      NULL,
      1.885305,
      NULL,
      NULL,
      0,
      1.576166,
      0.069513,
      3.342449,
      3,
      2.823343,
      3,
      0.570216,
      0.930454,
      4.920198,
      NULL,
      1.169157,
      0,
      6,
      0.196354,
      7,
      1.865360,
      4,
      4.900575,
      3.808067,
      6.462569,
      0,
      0,
      5,
      1,
      ' 9-27-1992',
      NULL,
      ' 6-21-1982',
      92,
      NULL,
      0,
      1,
      1.733228,
      0.566785,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.390456,
      NULL,
      1.627098,
      1,
      0.552071,
      1.174625,
      NULL,
      0.591298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      1.236216,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      1,
      NULL,
      1.675266,
      0,
      1.675400,
      6.259021,
      0.163409,
      5.222390,
      7.540077,
      1.315938,
      NULL,
      NULL,
      NULL,
      0.123306,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.994256,
      NULL,
      NULL,
      2.395054,
      0.335649,
      1.152586,
      1,
      NULL,
      37,
      0.972895,
      0,
      NULL,
      NULL,
      NULL,
      2.447319,
      0,
      2.793425,
      1.195883,
      1.963278,
      3.918366,
      NULL,
      0.310748,
      2,
      1,
      3,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      1.917508,
      0.131627,
      0.708024,
      0,
      NULL,
      1,
      0.173574,
      1,
      1.546309,
      NULL,
      NULL,
      0.389982,
      1,
      NULL,
      5.797440,
      8.516374,
      7,
      11,
      NULL,
      0,
      0,
      2,
      1.749427,
      2.593495,
      NULL,
      2,
      23,
      2,
      0.571312,
      NULL,
      59.250475,
      34.308565,
      NULL,
      NULL,
      1,
      1,
      NULL,
      '',
      NULL,
      1.855416,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      93.731904,
      10,
      0,
      41,
      3.493500,
      3.730478,
      NULL,
      3.203559,
      2.782793,
      NULL,
      0.524823,
      NULL,
      NULL,
      1.885779,
      2,
      2,
      1.175498,
      NULL,
      NULL,
      1.360194,
      NULL,
      NULL,
      1.227755,
      NULL,
      NULL,
      3,
      2.642203,
      0.261528,
      NULL,
      NULL,
      NULL,
      0.263346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      6.109878,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.471831,
      NULL,
      NULL,
      NULL,
      1.744667,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.428442,
      1.907805,
      1.715848,
      1.631043,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.155252,
      1,
      0,
      0,
      1.474500,
      0,
      NULL,
      NULL,
      7.709036,
      4.931473,
      1.865775,
      1.053971,
      NULL,
      NULL,
      0.412377,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.981393,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.627913,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3,
      2.212137,
      NULL,
      3.048503,
      0,
      0.999647,
      2,
      4,
      1,
      2,
      5,
      1.935052,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.669176,
      0.294271,
      2.735565,
      NULL,
      1,
      1.829344,
      NULL,
      6.628107,
      7,
      NULL,
      1,
      0,
      NULL,
      1,
      1.338520,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.922737,
      5.935931,
      0,
      2,
      6.790571,
      0.937384,
      3,
      5.884192,
      1,
      0.455631,
      0,
      NULL,
      0.054800,
      1.188283,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.672598,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.141809,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      1,
      0.565448,
      1,
      0,
      2.150052,
      0,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.683044,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.503037,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.728779,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      1.878598,
      NULL,
      NULL,
      1,
      0.854349,
      NULL,
      NULL,
      1.151115,
      3.419869,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      0.256829,
      NULL,
      NULL,
      1.058986,
      1.812200,
      NULL,
      NULL,
      2,
      3.992727,
      7.620351,
      3,
      1.500078,
      18.478486,
      1,
      1.653334,
      NULL,
      NULL,
      0.230078,
      NULL,
      NULL,
      2.320131,
      1,
      1.105765,
      0,
      NULL,
      NULL,
      0.923223,
      NULL,
      NULL,
      0.313596,
      NULL,
      1.921409,
      552.399102,
      33,
      0.773510,
      NULL,
      1.343048,
      2.444537,
      NULL,
      NULL,
      0,
      2.876584,
      1.886704,
      NULL,
      1,
      1.291945,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1.702253,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      34,
      51.934202,
      1,
      3.781460,
      3.208865,
      NULL,
      0,
      NULL,
      1.955828,
      NULL,
      0.403938,
      NULL,
      0.260017,
      NULL,
      0.439039,
      NULL,
      0,
      NULL,
      2.469098,
      NULL,
      1.226083,
      NULL,
      1.478426,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.076433,
      NULL,
      1,
      3,
      1.813140,
      0.937286,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.483151,
      1.691961,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.263461,
      1.340419,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.070345,
      1.714131,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.171702,
      2.826954,
      NULL,
      2.849298,
      NULL,
      1.172238,
      NULL,
      48,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      0.394716,
      2,
      24,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.428848,
      3.324856,
      3.028583,
      2.332538,
      0.246954,
      0,
      NULL,
      NULL,
      3.720485,
      2,
      3,
      NULL,
      0.267814,
      1,
      1.327031,
      1,
      NULL,
      1,
      1.681944,
      3.574436,
      NULL,
      1.393307,
      0.609516,
      1.617990,
      1.298522,
      1.857250,
      0.149599,
      1.797450,
      1,
      NULL,
      NULL,
      1.212071,
      NULL,
      0,
      1.914031,
      NULL,
      1.335413,
      0,
      0.082396,
      0.076894,
      NULL,
      2.765063,
      NULL,
      1,
      NULL,
      2,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.865593,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.415577,
      NULL,
      NULL,
      NULL,
      0.383562,
      NULL,
      2,
      NULL,
      0,
      34,
      2,
      NULL,
      1.069733,
      0.356872,
      NULL,
      1.893943,
      1,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      79.579826,
      NULL,
      0.657165,
      1.812487,
      '43201',
      '',
      '',
      1.192945,
      NULL,
      '',
      NULL,
      1.849536,
      NULL,
      '',
      '');
commit;
end;
/


