set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9502500';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-2-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      '4212243',
      3,
      1.616025,
      2,
      3,
      NULL,
      3.562044,
      NULL,
      NULL,
      NULL,
      ' 6-14-1994',
      14,
      NULL,
      NULL,
      0.757738,
      0,
      '11-24-1982',
      25,
      1.531209,
      377,
      4.836058,
      0.160716,
      ' 2- 8-1999',
      '11-26-1992',
      ' 6-12-1990',
      NULL,
      2.602351,
      0.377184,
      2.267806,
      0.141411,
      3,
      0.872668,
      1.586491,
      1.642013,
      4,
      10,
      19,
      NULL,
      4.176358,
      10.989470,
      4,
      NULL,
      3,
      3.698402,
      6,
      0,
      3,
      0,
      1.079396,
      0.348432,
      1.366036,
      0.634142,
      1.393974,
      1,
      1,
      0.565365,
      3.750759,
      NULL,
      3.179115,
      NULL,
      1.872660,
      NULL,
      3,
      NULL,
      3,
      1,
      NULL,
      0.796630,
      5.490829,
      2,
      NULL,
      0.296918,
      5.973019,
      0.085456,
      2.611215,
      1.156681,
      2,
      0.395768,
      NULL,
      NULL,
      2.259547,
      NULL,
      1,
      NULL,
      2.656321,
      3,
      NULL,
      0.643985,
      NULL,
      0.407080,
      0,
      1.568271,
      NULL,
      NULL,
      1,
      0,
      1.600792,
      2,
      0.349661,
      1,
      0,
      0,
      0,
      0,
      1,
      1.458336,
      1,
      2,
      1.686208,
      1.254232,
      NULL,
      NULL,
      NULL,
      3.455583,
      3.093711,
      0,
      NULL,
      2.565578,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.870777,
      0,
      1,
      0.521175,
      0.999031,
      1,
      1,
      1,
      0.154954,
      1.368909,
      1,
      NULL,
      1,
      5,
      0,
      NULL,
      3,
      0,
      2,
      2,
      1.668500,
      NULL,
      6.219359,
      0,
      4.980542,
      3.303369,
      2.777365,
      1,
      7,
      0,
      1.585248,
      7.815560,
      9,
      NULL,
      3,
      8,
      4.007585,
      2,
      4,
      NULL,
      ' 2- 2-1986',
      58.133434,
      ' 3- 2-1982',
      28.658419,
      0,
      1,
      0.116634,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.337758,
      5,
      NULL,
      5,
      3,
      3.995469,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.093662,
      NULL,
      NULL,
      1.359010,
      3.792589,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.636019,
      3,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      7.451297,
      0,
      7,
      NULL,
      6.631511,
      0,
      3,
      NULL,
      2.367692,
      5.573779,
      1,
      NULL,
      5,
      1,
      NULL,
      ' 5- 8-2002',
      24.703104,
      ' 1-15-2003',
      25,
      1,
      0,
      0.620171,
      NULL,
      NULL,
      1.494617,
      0.772845,
      1.689106,
      1,
      0,
      1,
      83.839105,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      3.402269,
      2,
      1.473411,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2.145875,
      3,
      1,
      0,
      3,
      4,
      1,
      0,
      1,
      0,
      NULL,
      0,
      1,
      0,
      1.493830,
      1,
      1,
      1.895426,
      NULL,
      4,
      1,
      11.371003,
      6,
      4,
      0.929564,
      6,
      4.830619,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.559507,
      65.449337,
      2.950054,
      1,
      NULL,
      NULL,
      35,
      NULL,
      3.603628,
      3,
      2.283753,
      '13244',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      NULL,
      '',
      1.462174,
      26.944933,
      77.001214,
      19.368505,
      1.731877,
      NULL,
      NULL,
      NULL,
      NULL,
      2.135092,
      2.912861,
      NULL,
      1.327368,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.658562,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0.062624,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.888016,
      NULL,
      NULL,
      1.168339,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      1,
      2,
      1,
      0.692637,
      NULL,
      NULL,
      NULL,
      NULL,
      0.099720,
      NULL,
      NULL,
      1.999187,
      NULL,
      NULL,
      0.539006,
      NULL,
      NULL,
      0.820608,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.738467,
      NULL,
      NULL,
      1.806469,
      NULL,
      NULL,
      0.286410,
      NULL,
      NULL,
      0.387533,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.316092,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.938155,
      NULL,
      NULL,
      1.889633,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.685277,
      NULL,
      NULL,
      1.550428,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.735466,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.778908,
      4,
      3,
      0,
      4.550960,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.028869,
      NULL,
      0.527114,
      2,
      3.385675,
      NULL,
      8,
      NULL,
      NULL,
      2,
      3.926971,
      1,
      2.894519,
      2.301680,
      1,
      2.363396,
      2.321667,
      NULL,
      3.241819,
      0,
      NULL,
      6,
      NULL,
      1.928865,
      5,
      5,
      4.592681,
      1.008004,
      NULL,
      NULL,
      NULL,
      0.114358,
      1,
      0.590035,
      0.284990,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0.393744,
      1.212559,
      0,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      18.860429,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.810913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.888667,
      NULL,
      NULL,
      NULL,
      1.034288,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.273032,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.368360,
      NULL,
      NULL,
      NULL,
      2.350329,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.207590,
      2.793446,
      3.391572,
      3.704411,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.616693,
      4.027350,
      NULL,
      0.663432,
      5.113781,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.419947,
      NULL,
      0,
      45,
      1.019201,
      1,
      1.609223,
      0.074130,
      1,
      0,
      NULL,
      0,
      NULL,
      1.521305,
      0,
      1.289120,
      1,
      NULL,
      0,
      0,
      0,
      1.501242,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.652994,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.314102,
      2,
      3,
      NULL,
      2,
      2,
      2,
      4.771232,
      8.732387,
      1.339934,
      0.645723,
      1.188679,
      2,
      1.452691,
      NULL,
      1,
      1.047285,
      NULL,
      NULL,
      NULL,
      NULL,
      0.326210,
      0.577500,
      NULL,
      NULL,
      1.447499,
      NULL,
      1,
      NULL,
      NULL,
      1.504610,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      1.583329,
      NULL,
      1,
      2.621354,
      NULL,
      0.172437,
      0.813785,
      NULL,
      NULL,
      0.501587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.377400,
      2,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2.197798,
      NULL,
      3.888788,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      NULL,
      2.034115,
      NULL,
      2,
      NULL,
      0.210160,
      NULL,
      3.538268,
      NULL,
      3.282803,
      1.523415,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.131396,
      NULL,
      1,
      4.346083,
      NULL,
      0.936815,
      NULL,
      NULL,
      79,
      NULL,
      NULL,
      4,
      2,
      NULL,
      NULL,
      '',
      0.238996,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


