set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6452968';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-5-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      '4203',
      2,
      0,
      NULL,
      NULL,
      ' 0- 5-1986',
      26,
      NULL,
      4.814090,
      3,
      0,
      '11-11-1982',
      40,
      1,
      166,
      48.419626,
      2,
      NULL,
      ' 7-28-2002',
      ' 8-13-2000',
      3.850961,
      0.055459,
      1,
      1,
      0,
      2.374147,
      0,
      0,
      0,
      4,
      3.715273,
      14,
      2,
      NULL,
      3,
      4,
      32,
      1,
      3.260377,
      5,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.246969,
      2,
      3,
      1.807895,
      NULL,
      1.076573,
      0,
      1.886156,
      0,
      0,
      10,
      1,
      3.756325,
      2.374816,
      1.099427,
      0,
      3,
      0.865384,
      NULL,
      2,
      0.111643,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.589494,
      5,
      9.621631,
      1,
      1,
      1,
      0.596066,
      0.882461,
      0.362881,
      3.609957,
      1.938424,
      NULL,
      0.107557,
      1,
      1,
      2,
      2.405681,
      0,
      0.716504,
      5,
      1,
      0,
      9,
      NULL,
      3,
      NULL,
      1.747149,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.257210,
      7,
      NULL,
      NULL,
      7,
      1.400930,
      3,
      0,
      1.918105,
      0.715419,
      1,
      1,
      1,
      4.747271,
      1.401594,
      NULL,
      0.452714,
      0,
      0.762635,
      NULL,
      0,
      NULL,
      2,
      NULL,
      2.359347,
      3.515547,
      5.759687,
      NULL,
      4.699573,
      NULL,
      2.525466,
      6.308213,
      1.876283,
      5.674654,
      1.235012,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5.397938,
      7,
      2,
      5.203851,
      4,
      3,
      3.480704,
      2,
      ' 9- 4-1975',
      NULL,
      ' 6-23-1986',
      322,
      0.827751,
      0,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.155692,
      2.011686,
      0,
      0,
      1,
      1,
      0.772889,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      3.385472,
      4,
      0.006843,
      0.768490,
      0,
      0.737401,
      NULL,
      4,
      1.844820,
      NULL,
      1.258055,
      0.388267,
      1,
      2,
      0.061066,
      NULL,
      7,
      3,
      7,
      4.736039,
      NULL,
      NULL,
      NULL,
      1.063694,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.002734,
      1.209364,
      1.445339,
      NULL,
      NULL,
      0,
      1.428972,
      3,
      19.882851,
      2,
      0.031413,
      NULL,
      NULL,
      NULL,
      1.665969,
      NULL,
      NULL,
      1,
      0.296783,
      1.615718,
      1,
      0,
      0.972470,
      1,
      3,
      NULL,
      0.084266,
      1,
      3,
      3,
      1,
      1,
      1,
      4.858222,
      0,
      1.310313,
      1,
      0.998679,
      NULL,
      0,
      NULL,
      1.625226,
      1.051413,
      2.112241,
      0.212412,
      0.738559,
      9.327121,
      NULL,
      7,
      4.644505,
      7,
      6,
      2.755663,
      2.014362,
      6,
      2,
      NULL,
      3.275836,
      9,
      2.154112,
      2.722107,
      NULL,
      55,
      6,
      51,
      1.451439,
      1,
      3.569465,
      '34431',
      '',
      '',
      1.486360,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      21.020892,
      110,
      18.895148,
      0.230528,
      28,
      4,
      NULL,
      5.988821,
      2.553310,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.836258,
      1.742493,
      2.669560,
      1.798956,
      1.017016,
      0.738006,
      NULL,
      NULL,
      1.805599,
      0.039334,
      0,
      NULL,
      1.868635,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.544742,
      2.307665,
      0,
      0.885136,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1,
      7,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.735305,
      NULL,
      NULL,
      NULL,
      2.837165,
      0,
      3.037709,
      3.392040,
      1.762730,
      1,
      13,
      NULL,
      NULL,
      0.516640,
      0,
      0,
      0,
      1.904068,
      0.449211,
      0,
      NULL,
      NULL,
      1.807905,
      1,
      NULL,
      NULL,
      2.009034,
      2,
      0.039488,
      0.517280,
      NULL,
      NULL,
      1.735914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.858496,
      6.101741,
      1.360689,
      0,
      0.109307,
      NULL,
      NULL,
      NULL,
      1.772024,
      NULL,
      NULL,
      NULL,
      1.223556,
      1,
      1,
      2.812194,
      17,
      1.842908,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      3,
      1.003720,
      0,
      0.305962,
      NULL,
      NULL,
      7.776695,
      1,
      0,
      0,
      NULL,
      NULL,
      1.815244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.146910,
      NULL,
      NULL,
      1.198564,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      5.073712,
      1.948896,
      0,
      NULL,
      4.723382,
      NULL,
      3.368664,
      NULL,
      NULL,
      1.488072,
      3,
      0.852891,
      0,
      2.504660,
      0.947594,
      0,
      NULL,
      NULL,
      2,
      4.926979,
      4,
      NULL,
      NULL,
      3.507144,
      2.387493,
      0.628805,
      0.292363,
      2.816817,
      0,
      3,
      NULL,
      3,
      NULL,
      7,
      NULL,
      0,
      9.139686,
      9,
      1,
      NULL,
      0.777241,
      0,
      NULL,
      1.755694,
      NULL,
      0,
      NULL,
      2.217067,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.682537,
      NULL,
      NULL,
      0.656086,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      0.837157,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      0,
      0.279696,
      0.059392,
      NULL,
      1.049922,
      1,
      1,
      NULL,
      NULL,
      4.459872,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.237597,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.323853,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.679023,
      NULL,
      NULL,
      NULL,
      2.996640,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.060798,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.605223,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.225591,
      5,
      4.129706,
      1,
      5,
      0.166233,
      0,
      NULL,
      NULL,
      NULL,
      0.505680,
      NULL,
      0.464271,
      0,
      3.919942,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.383841,
      NULL,
      1.453674,
      0,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.834685,
      0.334510,
      NULL,
      0.675407,
      0,
      NULL,
      0.239761,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.717056,
      0.439700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.621261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.476242,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.423657,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.103790,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.439869,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1.445310,
      NULL,
      0.474868,
      NULL,
      NULL,
      NULL,
      3.617189,
      NULL,
      NULL,
      NULL,
      0,
      0.209322,
      NULL,
      17.215697,
      34,
      1.525921,
      NULL,
      NULL,
      NULL,
      NULL,
      0.383815,
      1,
      NULL,
      1.599356,
      NULL,
      0.135352,
      NULL,
      6.806482,
      0.706077,
      3,
      1.761076,
      1,
      0.250328,
      NULL,
      NULL,
      3.359909,
      NULL,
      0.661296,
      3,
      NULL,
      0,
      1.454685,
      NULL,
      1.225995,
      1,
      NULL,
      2,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.698050,
      NULL,
      1.255100,
      0,
      NULL,
      0.681320,
      NULL,
      NULL,
      1.096943,
      2,
      NULL,
      0,
      1.070885,
      3.921608,
      1,
      NULL,
      NULL,
      NULL,
      1.310776,
      NULL,
      1,
      NULL,
      1.617692,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.106113,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      17,
      1,
      NULL,
      3.843478,
      0,
      NULL,
      17,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      7.361172,
      NULL,
      NULL,
      NULL,
      0.621073,
      NULL,
      3.948604,
      NULL,
      18,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      11,
      NULL,
      NULL,
      2.948186,
      NULL,
      1.244987,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      6,
      7,
      3.678681,
      0.922818,
      NULL,
      NULL,
      93,
      130.215275,
      5,
      0.883490,
      6,
      '40000',
      '20143',
      NULL,
      1.809545,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


