set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7531456';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-5-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '4',
      NULL,
      NULL,
      '3130421',
      NULL,
      0,
      2,
      NULL,
      '4301',
      1.539651,
      NULL,
      NULL,
      NULL,
      ' 9- 1-1981',
      NULL,
      NULL,
      4,
      1,
      NULL,
      '10- 4-1988',
      58.208534,
      1.438880,
      27,
      63,
      3,
      NULL,
      ' 1-26-1985',
      ' 0- 2-1992',
      3,
      3,
      0.451338,
      0,
      1,
      0.404816,
      3,
      0.857274,
      1,
      159.839112,
      11,
      17,
      5,
      81,
      0,
      3.405048,
      15.867161,
      4.805706,
      5.813712,
      7,
      0,
      0.217245,
      0,
      0.377491,
      1.056632,
      0,
      1.652075,
      0.339046,
      0.778413,
      1.102091,
      81.708361,
      0.701565,
      2,
      0.227216,
      1,
      8,
      1.267768,
      0,
      1.172669,
      0.640336,
      1.079927,
      0,
      0.778411,
      0,
      0.791573,
      0,
      NULL,
      4.475880,
      0,
      2.283174,
      NULL,
      1,
      1.161869,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      NULL,
      1,
      2.181665,
      NULL,
      1.518818,
      1.014900,
      0,
      1.383959,
      1,
      1,
      NULL,
      NULL,
      1,
      3,
      0.085023,
      2,
      0,
      NULL,
      7,
      1,
      NULL,
      6.269400,
      0,
      NULL,
      0.697291,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3.211549,
      4,
      0.248646,
      4.504344,
      0,
      1.804105,
      1.988903,
      0.408504,
      4.471173,
      1,
      0.700152,
      0,
      7.059567,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      6.225399,
      7.203572,
      1.646741,
      NULL,
      1,
      7,
      8,
      1.403743,
      NULL,
      7,
      3.411041,
      NULL,
      1,
      9.852438,
      NULL,
      NULL,
      7.082108,
      6,
      8,
      5.092379,
      2,
      4,
      0,
      1.281082,
      3.107837,
      0,
      2,
      NULL,
      1512,
      ' 3-16-1989',
      1125,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.440858,
      0.670383,
      0.322912,
      1,
      NULL,
      0,
      0.669880,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.630514,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.692997,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.018441,
      5,
      0,
      2,
      4.496214,
      5,
      NULL,
      1,
      NULL,
      NULL,
      1.706546,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      NULL,
      NULL,
      0.387126,
      0.040384,
      1,
      30,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      0,
      2,
      3.900151,
      1.483939,
      2,
      NULL,
      0,
      3,
      3.619089,
      0,
      3,
      NULL,
      18,
      5.613681,
      1,
      0.059812,
      1,
      0.385285,
      0,
      NULL,
      0.665037,
      0.425306,
      NULL,
      1,
      1,
      1.898642,
      1.273883,
      15,
      1,
      5,
      11,
      NULL,
      1,
      11,
      4,
      5.483358,
      2.173153,
      7.286565,
      2.760571,
      NULL,
      NULL,
      46.893396,
      1.678067,
      3,
      NULL,
      42,
      21,
      5,
      0,
      1,
      0,
      '00444',
      '',
      '',
      0,
      '',
      '',
      '',
      3.743436,
      NULL,
      '3031',
      NULL,
      1,
      NULL,
      113,
      32,
      NULL,
      1.393421,
      5,
      2,
      11.441291,
      0,
      0.367244,
      NULL,
      0,
      NULL,
      NULL,
      1.164220,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.249143,
      1,
      3,
      1,
      NULL,
      1.559639,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.832827,
      NULL,
      NULL,
      0.780046,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9,
      1.069115,
      6.574257,
      0.446080,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0.417235,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.874523,
      NULL,
      2.661336,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.905649,
      0.757143,
      NULL,
      0.146441,
      3.655963,
      NULL,
      0,
      NULL,
      0,
      3.188434,
      1.012462,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.243919,
      NULL,
      2.555223,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.815366,
      2,
      0.820532,
      2,
      2,
      0,
      NULL,
      NULL,
      7.207212,
      2,
      5,
      0,
      NULL,
      1.484704,
      1.713556,
      NULL,
      NULL,
      6,
      1.791500,
      NULL,
      0,
      NULL,
      NULL,
      0.089900,
      NULL,
      NULL,
      1.120180,
      NULL,
      NULL,
      1.527312,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.742644,
      3.391440,
      3.067262,
      NULL,
      2,
      3,
      0,
      3.620870,
      NULL,
      NULL,
      0.272365,
      6.424525,
      4.232407,
      3.593946,
      5.964032,
      2,
      NULL,
      2,
      0.856198,
      1.922786,
      1,
      3,
      2,
      3,
      5,
      2.319130,
      1.038073,
      NULL,
      NULL,
      0.247167,
      0.105911,
      1.791190,
      3.203281,
      3,
      0.679707,
      3.710509,
      3,
      3,
      2,
      6,
      NULL,
      NULL,
      4.776720,
      7,
      1.375557,
      3,
      3,
      5.558138,
      1,
      1.135168,
      NULL,
      1.844047,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.611242,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.741102,
      NULL,
      NULL,
      1.775806,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.401699,
      0.148096,
      0,
      0,
      3,
      1.117853,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.914683,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.529935,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.474948,
      NULL,
      NULL,
      NULL,
      3.409521,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.013365,
      NULL,
      NULL,
      NULL,
      3,
      4.855620,
      2.318099,
      2.271435,
      0.657851,
      336.895254,
      14,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      59.105820,
      18,
      0,
      NULL,
      NULL,
      0.674542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      66.981119,
      0.519653,
      1.113108,
      1.609618,
      1.510370,
      NULL,
      1.011332,
      NULL,
      0,
      1,
      1.917972,
      1.141758,
      0,
      1,
      0.910130,
      0,
      0.028212,
      1,
      0,
      0.739377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.036917,
      0.824340,
      1,
      5,
      3.720825,
      NULL,
      3,
      2,
      5,
      0.152562,
      0,
      NULL,
      0.584275,
      0,
      NULL,
      0.596356,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.607914,
      NULL,
      1.177118,
      0,
      NULL,
      0.977235,
      1.411458,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3.429499,
      1.005428,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0.283048,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.415141,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.319331,
      NULL,
      0,
      NULL,
      3.974833,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      16,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      13.830994,
      7.691050,
      0,
      1.916964,
      NULL,
      67.347995,
      77.640505,
      NULL,
      NULL,
      1.794069,
      '32300',
      NULL,
      '',
      2,
      '01020',
      NULL,
      '',
      3.847279,
      '3441',
      '2120',
      '4113');
commit;
end;
/


