set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9851628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-11-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      4.121386,
      2.609548,
      3.830557,
      4,
      NULL,
      NULL,
      0,
      NULL,
      '312',
      NULL,
      11.715102,
      19.479231,
      '1433421',
      3,
      0.829687,
      4,
      2,
      '1420',
      4,
      0.632892,
      NULL,
      NULL,
      ' 5- 5-1980',
      14.472994,
      31,
      NULL,
      3.908954,
      2.686648,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 3- 3-1986',
      ' 5- 8-1981',
      NULL,
      3,
      0.240226,
      1,
      1,
      1.043681,
      1.619612,
      2,
      2.797666,
      NULL,
      NULL,
      NULL,
      3,
      3.545450,
      NULL,
      NULL,
      NULL,
      NULL,
      5.324600,
      4,
      NULL,
      3.333539,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.951354,
      2.396064,
      3,
      3.165809,
      0,
      0,
      NULL,
      8.973049,
      2,
      0.140267,
      3,
      4,
      6,
      NULL,
      1,
      0,
      5.891250,
      0.957126,
      0.954763,
      1.833495,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.884118,
      7,
      NULL,
      2,
      1,
      1.987141,
      2,
      1.474430,
      0.845365,
      3.279166,
      1.564204,
      2,
      3.285587,
      NULL,
      0.325293,
      2.203358,
      2,
      2,
      1.505038,
      0.443529,
      1.180258,
      3.807799,
      2,
      NULL,
      5.816227,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      2.889500,
      9.923669,
      3,
      1,
      0.303521,
      NULL,
      NULL,
      2.540652,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      0.767478,
      0.444748,
      0,
      1.969646,
      NULL,
      1.160646,
      6.513932,
      5,
      0,
      0,
      3.091870,
      1.957235,
      1.279647,
      5,
      5,
      0,
      6.635031,
      6.476206,
      8.700222,
      5.377550,
      6,
      NULL,
      NULL,
      4.224293,
      4,
      6.438650,
      5,
      3.027979,
      ' 8-21-1984',
      NULL,
      ' 0-28-1979',
      14,
      3.939200,
      0.189600,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.867195,
      0,
      1.232978,
      NULL,
      0.111506,
      4.217191,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.719319,
      NULL,
      5,
      2.445804,
      0,
      0.963091,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.635057,
      1.304422,
      NULL,
      0,
      3.234191,
      3.545696,
      1.792790,
      NULL,
      NULL,
      1.563771,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.949663,
      1.408374,
      1.161436,
      0,
      1,
      0.127232,
      2,
      32.125914,
      0.026817,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.314635,
      1.954178,
      2.160376,
      2.501322,
      1.760658,
      1.417522,
      0.788401,
      1.718024,
      3.438149,
      3,
      2.768123,
      2,
      2,
      1,
      1,
      2.715851,
      NULL,
      1,
      1,
      1.190336,
      0.222958,
      NULL,
      NULL,
      NULL,
      NULL,
      0.261874,
      1,
      1,
      1,
      3,
      1.503877,
      10.777438,
      9.620742,
      6.833483,
      0.457953,
      7,
      1,
      2.415713,
      1,
      0.236891,
      NULL,
      0.973279,
      3.371619,
      56,
      1,
      0,
      6.391383,
      NULL,
      42,
      NULL,
      1.661703,
      NULL,
      5,
      '23311',
      '22040',
      '',
      0.431037,
      '',
      '',
      '',
      0,
      NULL,
      NULL,
      '',
      NULL,
      26.513847,
      64,
      NULL,
      2.824061,
      4,
      2.740857,
      0,
      NULL,
      3.770003,
      0,
      3,
      0,
      NULL,
      NULL,
      0.883412,
      NULL,
      NULL,
      1,
      2,
      0,
      NULL,
      1,
      0,
      0.017959,
      NULL,
      NULL,
      NULL,
      2.179690,
      2.450655,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.078381,
      NULL,
      NULL,
      1.828070,
      NULL,
      NULL,
      0.496730,
      NULL,
      NULL,
      4.033697,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.299376,
      0.812235,
      1,
      0.442091,
      0,
      1,
      NULL,
      1,
      0.751582,
      2,
      0,
      0,
      3,
      1,
      0,
      1.403430,
      0,
      2.482829,
      3,
      1,
      1.149821,
      3.624155,
      1.831049,
      1,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.792426,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.887386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.796575,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.445286,
      NULL,
      NULL,
      1.552731,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.451336,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.984530,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      1.389579,
      3,
      1,
      0.216766,
      5.177305,
      0.773333,
      1,
      0,
      1.424541,
      NULL,
      1.233004,
      0.847370,
      1.563231,
      3.591080,
      1.580096,
      NULL,
      0,
      3,
      2.543467,
      1.480514,
      2.117218,
      2.273399,
      NULL,
      NULL,
      0.328335,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.782712,
      3,
      NULL,
      NULL,
      0.178531,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.521244,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.579632,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.179735,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.720305,
      1.197979,
      1.434532,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      14,
      NULL,
      NULL,
      NULL,
      1.062069,
      NULL,
      NULL,
      NULL,
      0.012218,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.053283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.489756,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      0.963211,
      NULL,
      4,
      2.524658,
      NULL,
      0.468784,
      1.446484,
      NULL,
      NULL,
      1.203765,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.502549,
      NULL,
      NULL,
      1.492127,
      NULL,
      0,
      1,
      2,
      1.326054,
      3.222755,
      1,
      1,
      1.486282,
      0.579636,
      0,
      1,
      1.943456,
      NULL,
      NULL,
      NULL,
      0.317897,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.558327,
      NULL,
      1.316007,
      NULL,
      NULL,
      NULL,
      3.242543,
      NULL,
      20.915522,
      NULL,
      2,
      36,
      32.345106,
      1,
      0.945381,
      NULL,
      NULL,
      0.217092,
      NULL,
      1,
      NULL,
      1.407062,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.026235,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.402545,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      1.913125,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.962469,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.144678,
      0.389786,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.857125,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.436641,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      0.146055,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0,
      NULL,
      2,
      3.268980,
      4.128862,
      1,
      NULL,
      0,
      2,
      NULL,
      0.911924,
      1,
      NULL,
      1,
      1.187329,
      NULL,
      1.026587,
      0.113902,
      NULL,
      1,
      0,
      NULL,
      1.329741,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      1.438309,
      NULL,
      1.047024,
      0,
      NULL,
      1,
      1,
      NULL,
      0.936670,
      2.484469,
      NULL,
      1,
      0.210733,
      NULL,
      NULL,
      1,
      0.562531,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.440301,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.634613,
      NULL,
      1,
      2.214144,
      0,
      NULL,
      NULL,
      NULL,
      99.701358,
      108.698065,
      4.846682,
      3,
      NULL,
      '44300',
      '30144',
      '',
      NULL,
      '',
      NULL,
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


