set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7310941';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-9-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      9,
      2,
      2.573305,
      1,
      5,
      0.333663,
      2,
      NULL,
      '224',
      '3',
      46,
      64.124818,
      NULL,
      NULL,
      0.554530,
      0,
      NULL,
      '1000',
      NULL,
      1.364265,
      NULL,
      NULL,
      NULL,
      34,
      37.095111,
      NULL,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      ' 0-25-1982',
      NULL,
      1,
      1.751294,
      3.426702,
      1,
      1.334054,
      9,
      2.333660,
      NULL,
      NULL,
      NULL,
      5.462944,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1.648648,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      0,
      3.242316,
      0,
      0.171361,
      1.383583,
      1,
      0.419744,
      2.726091,
      1.084166,
      1.107574,
      1,
      1.911409,
      0.642060,
      0.913328,
      0,
      NULL,
      0,
      0.027421,
      1.084020,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1.918251,
      NULL,
      0.617189,
      NULL,
      NULL,
      1,
      1.195654,
      2,
      NULL,
      0,
      1.328764,
      0,
      1.067056,
      3,
      NULL,
      1.308196,
      0.621122,
      0,
      NULL,
      1.974290,
      NULL,
      NULL,
      0.348493,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.809723,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.970130,
      0,
      NULL,
      0,
      1.835227,
      0.801397,
      1.962435,
      1.717130,
      1.262867,
      0.120896,
      1.805816,
      1,
      1,
      1.834865,
      0,
      0,
      NULL,
      NULL,
      1.866889,
      0.954467,
      0,
      0,
      1.591585,
      NULL,
      2.050146,
      1,
      0,
      0,
      1,
      2.738811,
      4.049896,
      0,
      0,
      2.394458,
      NULL,
      6,
      3.328307,
      4,
      NULL,
      0,
      5.490021,
      0,
      NULL,
      3.369486,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.313035,
      0.284139,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.691743,
      0.025360,
      NULL,
      0.925812,
      0.378902,
      0.035165,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.679073,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.209706,
      NULL,
      NULL,
      NULL,
      1.725378,
      1,
      0.931323,
      1,
      0,
      NULL,
      1.878026,
      NULL,
      NULL,
      NULL,
      1.068072,
      NULL,
      0.340834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.803500,
      3,
      NULL,
      0.205559,
      0,
      1,
      0.745694,
      NULL,
      NULL,
      1.252980,
      1,
      NULL,
      NULL,
      NULL,
      2.095452,
      NULL,
      3.455869,
      2,
      0.901038,
      2,
      3,
      0,
      1,
      1,
      1.414644,
      2,
      NULL,
      1.328991,
      0,
      NULL,
      NULL,
      1.360744,
      0,
      NULL,
      0.891755,
      1,
      3,
      NULL,
      1.690260,
      1,
      1,
      1.819301,
      1.283923,
      1,
      2.324110,
      NULL,
      1,
      4,
      2,
      7,
      6.126860,
      6,
      0.913697,
      1,
      4,
      0,
      NULL,
      2.798242,
      26.066922,
      2,
      0,
      18,
      NULL,
      NULL,
      NULL,
      3.673214,
      NULL,
      1,
      '02431',
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      1.995211,
      '',
      NULL,
      '',
      0.694498,
      14,
      104.498941,
      13.673878,
      3.328339,
      68,
      7,
      10.401272,
      NULL,
      2.314557,
      NULL,
      NULL,
      1.873997,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.855246,
      0.126812,
      1,
      1,
      NULL,
      NULL,
      1.083066,
      NULL,
      NULL,
      1,
      1.816433,
      1.348971,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.877362,
      NULL,
      NULL,
      0.015253,
      NULL,
      NULL,
      2,
      1.418932,
      0.390127,
      0.264818,
      0.629539,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.844320,
      1.548651,
      2,
      1.098619,
      0.982242,
      2.427658,
      NULL,
      0.983035,
      0,
      1,
      NULL,
      2,
      NULL,
      2.502204,
      0.544796,
      1,
      3.861315,
      2,
      2.322635,
      0.498713,
      1,
      NULL,
      1,
      1.487383,
      0,
      NULL,
      NULL,
      0.931671,
      NULL,
      NULL,
      NULL,
      NULL,
      0.359501,
      0,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.718317,
      NULL,
      NULL,
      NULL,
      0,
      1.759121,
      1,
      NULL,
      NULL,
      1.652247,
      1,
      0.913344,
      NULL,
      1.081976,
      NULL,
      NULL,
      3,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      1.684130,
      3.589079,
      NULL,
      1.212828,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.719181,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.836334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      4,
      1.532864,
      1.582858,
      NULL,
      NULL,
      0.144926,
      3,
      1.925137,
      1.736779,
      2,
      2,
      3,
      2.762797,
      0.758446,
      8.283360,
      1,
      0,
      3.653102,
      0,
      2.703334,
      2,
      3.893942,
      3,
      0,
      2,
      0,
      NULL,
      1,
      1.848970,
      NULL,
      4.383960,
      2.042424,
      1.049869,
      0,
      NULL,
      1,
      0,
      NULL,
      0.592993,
      0,
      0,
      0.421881,
      1.174285,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.307169,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2.881103,
      NULL,
      NULL,
      1.674199,
      NULL,
      NULL,
      1.017809,
      0.824723,
      2.821233,
      3,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      6,
      22.025927,
      NULL,
      NULL,
      1,
      1.746446,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.302844,
      0.498839,
      NULL,
      NULL,
      1.323197,
      1.397269,
      NULL,
      NULL,
      0.273549,
      0,
      NULL,
      NULL,
      1,
      0.464747,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      1.319643,
      NULL,
      NULL,
      1,
      0.181800,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.570354,
      1.861638,
      NULL,
      NULL,
      6,
      6.626914,
      NULL,
      NULL,
      1.575833,
      NULL,
      NULL,
      NULL,
      0,
      63.721493,
      NULL,
      1.183850,
      132.439996,
      8.457320,
      0.107137,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      42.213493,
      0,
      0,
      0.383974,
      0.074461,
      1.965144,
      0,
      1,
      1,
      1,
      NULL,
      0.704183,
      1,
      0,
      1.566454,
      0,
      0,
      0.409776,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.931986,
      1,
      1.043693,
      1.185588,
      0,
      0.920645,
      NULL,
      2,
      0,
      2,
      1.562199,
      1,
      NULL,
      NULL,
      1.819777,
      0.557365,
      NULL,
      0.700024,
      0,
      NULL,
      0.625080,
      1,
      1.673272,
      NULL,
      0.088163,
      NULL,
      NULL,
      1.013311,
      1.599827,
      1,
      3.331577,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.033439,
      1.872192,
      0,
      1,
      0.173877,
      NULL,
      0,
      3,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.310227,
      0.068488,
      0,
      1.688189,
      1.934289,
      1,
      NULL,
      NULL,
      NULL,
      1.656857,
      NULL,
      NULL,
      6.086676,
      35.879403,
      0,
      1,
      1.145610,
      '41122',
      '',
      '',
      1.053275,
      NULL,
      '',
      NULL,
      0.301721,
      NULL,
      '',
      NULL);
commit;
end;
/


