set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8919196';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-10-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      '0210022',
      0.401836,
      0.077115,
      5,
      0,
      '0222',
      2.013153,
      NULL,
      NULL,
      NULL,
      '11-20-1985',
      38.265859,
      NULL,
      0.202819,
      1,
      NULL,
      '10- 4-1995',
      25.229691,
      0.593455,
      29,
      NULL,
      2,
      ' 4-19-1988',
      ' 2-16-1995',
      ' 7- 2-1990',
      3,
      1,
      3,
      2.446240,
      1,
      3,
      0.195900,
      0,
      0.302520,
      15.932420,
      11.671830,
      12.567389,
      1,
      25,
      13,
      0.730158,
      16,
      7,
      NULL,
      7,
      0.295065,
      0.326933,
      NULL,
      0.663403,
      0,
      0.976391,
      1,
      0,
      0.012155,
      0.894729,
      0,
      2.426097,
      NULL,
      0,
      1.324829,
      2,
      1,
      3.243868,
      NULL,
      2.289209,
      NULL,
      4.103674,
      NULL,
      5.921679,
      NULL,
      NULL,
      1.200934,
      2.984854,
      NULL,
      4.110553,
      0,
      2.721544,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      0.122656,
      NULL,
      1,
      1.529081,
      2.536758,
      3,
      3,
      2.985652,
      0,
      2,
      2,
      0.250523,
      2.981675,
      1,
      1.795793,
      3,
      NULL,
      3,
      1.757309,
      0,
      1.486073,
      8.275343,
      0.345213,
      2,
      NULL,
      1.871522,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.915075,
      4,
      1,
      NULL,
      7.298502,
      NULL,
      1,
      0,
      1.566221,
      1.012524,
      1,
      1,
      NULL,
      1.438533,
      1,
      1.476177,
      0.041424,
      0,
      1.240065,
      NULL,
      0,
      0.328812,
      4,
      2,
      7.946545,
      0,
      5.705960,
      NULL,
      0,
      0.533692,
      0.878689,
      0.724987,
      0.726069,
      0.944167,
      0.154523,
      0,
      1.712522,
      2,
      2,
      0.109201,
      5.712585,
      2.889452,
      7.383527,
      4.093944,
      2.133620,
      0.495766,
      3,
      2,
      ' 2-29-2003',
      161,
      ' 4- 4-1992',
      25,
      0,
      0,
      1,
      0.688728,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      5,
      8.418183,
      0,
      0.407922,
      1,
      1.180949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.777779,
      NULL,
      1.185096,
      3,
      3.894997,
      5.304356,
      1,
      0,
      3.696750,
      2,
      4,
      7.829642,
      0.502026,
      3,
      NULL,
      0,
      2.554961,
      3,
      0.391309,
      4.524695,
      1,
      NULL,
      7.284225,
      0,
      NULL,
      NULL,
      NULL,
      1,
      10,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.193478,
      1,
      0.321001,
      2.301943,
      0,
      0,
      2.691484,
      1.984721,
      0.179124,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0.215170,
      2.628602,
      2,
      2.886285,
      1,
      0,
      2.320276,
      2.633255,
      0,
      2.902457,
      2,
      2.391303,
      3.843119,
      NULL,
      NULL,
      1.096772,
      0,
      0.166156,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.147510,
      1.356279,
      0.215234,
      0,
      NULL,
      1.185407,
      7,
      6,
      0,
      7,
      6.233028,
      NULL,
      0,
      2.644494,
      2.136295,
      3,
      0.291090,
      1.876925,
      48,
      1,
      NULL,
      NULL,
      NULL,
      96.166178,
      6.843686,
      4,
      NULL,
      2,
      '32041',
      NULL,
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      3,
      13,
      40,
      9.738933,
      NULL,
      21.221813,
      1.925892,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.873286,
      NULL,
      NULL,
      3,
      3.735823,
      0.577295,
      0,
      3.936742,
      0.584375,
      1,
      NULL,
      NULL,
      2.914104,
      3.837320,
      3,
      NULL,
      NULL,
      NULL,
      3.662197,
      NULL,
      0,
      1.821776,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.997729,
      4.094288,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.602765,
      0,
      1.265344,
      3,
      2.273955,
      2,
      NULL,
      NULL,
      1,
      NULL,
      2.543712,
      1.284714,
      2.266200,
      3.371060,
      1.763372,
      NULL,
      NULL,
      0,
      0.500075,
      3.950945,
      1.568104,
      0.765656,
      1.796194,
      0,
      1.894940,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.936420,
      1.273634,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.504085,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.435405,
      2,
      0,
      0,
      NULL,
      NULL,
      3.735424,
      NULL,
      0,
      NULL,
      3.097723,
      1,
      0,
      NULL,
      NULL,
      5.872612,
      3,
      0,
      3,
      NULL,
      1.665626,
      1,
      3.185070,
      0,
      1,
      NULL,
      NULL,
      0.032900,
      NULL,
      NULL,
      0.465902,
      NULL,
      NULL,
      1,
      6,
      1,
      0.700215,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.202081,
      1,
      1.118263,
      3.950865,
      5.847496,
      1.651352,
      NULL,
      NULL,
      4.524755,
      NULL,
      NULL,
      NULL,
      3.023422,
      1,
      2,
      2.683055,
      0.122178,
      2.467000,
      7,
      5.830240,
      5,
      2.709914,
      2.391962,
      0,
      0,
      1.452336,
      3.161922,
      2.943148,
      0,
      2.404456,
      NULL,
      1,
      0.503356,
      6.988508,
      3.787528,
      1,
      6,
      2,
      NULL,
      0.523963,
      1,
      2.636062,
      1,
      NULL,
      NULL,
      1,
      1.577204,
      2.718407,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.117718,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3.759048,
      NULL,
      NULL,
      3.295850,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6.255883,
      NULL,
      NULL,
      NULL,
      0.753560,
      0,
      NULL,
      1.527321,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.783898,
      NULL,
      NULL,
      NULL,
      1.710716,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.192353,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.405379,
      NULL,
      NULL,
      NULL,
      3.335030,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      14.265893,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      7,
      0,
      1.722029,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.064274,
      6,
      1.223316,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      166.830488,
      NULL,
      1.060870,
      1.109768,
      0,
      1,
      NULL,
      NULL,
      0.161457,
      0.513933,
      1,
      1.349083,
      NULL,
      0.987274,
      NULL,
      0,
      1.560245,
      1.524893,
      0,
      1.595208,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.285556,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.397168,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.447844,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.478501,
      NULL,
      0,
      NULL,
      0.320290,
      NULL,
      1,
      1,
      1.184213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.808113,
      1.682960,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.489449,
      NULL,
      2.818215,
      NULL,
      2,
      NULL,
      198,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.671917,
      1,
      2.971244,
      2.259080,
      3.419338,
      0.914562,
      NULL,
      NULL,
      NULL,
      NULL,
      0.600743,
      3,
      0,
      0,
      0.546411,
      0.051671,
      0,
      1.327669,
      1,
      0.826756,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      3,
      0,
      NULL,
      0.866427,
      NULL,
      NULL,
      0.178924,
      1,
      NULL,
      0,
      1.103361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.167765,
      NULL,
      1.790420,
      1.201401,
      NULL,
      NULL,
      0.140072,
      NULL,
      0,
      0,
      NULL,
      1.031353,
      0.721146,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.259939,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.564103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.435170,
      1.307860,
      3,
      1,
      NULL,
      NULL,
      86,
      NULL,
      0.352437,
      0.315852,
      0,
      '11034',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      1,
      NULL,
      '',
      '');
commit;
end;
/


