set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8919196';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-10-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0.856035,
      1,
      NULL,
      3.623979,
      0.488033,
      1.634092,
      NULL,
      2.438335,
      NULL,
      '1',
      18,
      51,
      '4402023',
      2.286937,
      0.931331,
      NULL,
      2,
      '4320',
      4.954386,
      NULL,
      NULL,
      NULL,
      ' 6-13-1975',
      NULL,
      55.250220,
      NULL,
      NULL,
      0.875435,
      ' 5-12-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      3.256288,
      NULL,
      NULL,
      ' 8- 2-1980',
      2,
      0.999663,
      0,
      0,
      1,
      NULL,
      3.509919,
      1,
      NULL,
      NULL,
      NULL,
      6,
      2.043174,
      NULL,
      NULL,
      NULL,
      NULL,
      2.080451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.028454,
      NULL,
      1,
      0,
      0.901673,
      NULL,
      1,
      NULL,
      4,
      0.503990,
      1,
      0.115832,
      1,
      0,
      NULL,
      4.865461,
      0,
      1.285857,
      0.059968,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      7,
      2.278087,
      NULL,
      1,
      0,
      NULL,
      0.291055,
      NULL,
      NULL,
      1,
      1,
      1.023488,
      2.727573,
      NULL,
      0,
      0.438651,
      1,
      1.524054,
      0,
      0.406746,
      1.175251,
      NULL,
      0,
      1.122912,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1.744194,
      1,
      NULL,
      5.218065,
      1.087718,
      0,
      1.707717,
      1.991406,
      1,
      1,
      0,
      NULL,
      1.864436,
      1,
      1.205159,
      1.217014,
      1,
      NULL,
      1,
      0,
      NULL,
      0.534964,
      0.573803,
      1.147845,
      NULL,
      3.305454,
      0.232344,
      1.905905,
      0,
      0.312363,
      0.485069,
      0.064216,
      0,
      4.589449,
      NULL,
      5,
      7.845668,
      NULL,
      6,
      7,
      NULL,
      1.760367,
      NULL,
      7.899090,
      3.083142,
      0,
      NULL,
      1423.832586,
      NULL,
      889.764051,
      3,
      1,
      1.498890,
      1.417009,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.482741,
      1.554170,
      0,
      0,
      NULL,
      NULL,
      1,
      0.009329,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.199639,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.772206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.260414,
      3.861456,
      5,
      0.357328,
      4.052093,
      1.324789,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.826962,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.067084,
      2.867171,
      1,
      0.521702,
      1,
      0.244113,
      1.380871,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.613419,
      3.782744,
      NULL,
      1.910854,
      NULL,
      3.332741,
      1,
      3,
      0.578194,
      0.428698,
      1,
      3,
      3,
      NULL,
      2,
      2.518480,
      0,
      0.577735,
      0,
      1,
      1.511030,
      NULL,
      1,
      0.198456,
      1.749832,
      1,
      0,
      1,
      1,
      3.129697,
      0.912019,
      NULL,
      4.257026,
      5.966126,
      NULL,
      9.234007,
      0,
      NULL,
      1.954558,
      3.446290,
      NULL,
      1.509359,
      0.982520,
      22.542059,
      3.733230,
      0.322832,
      41,
      NULL,
      NULL,
      NULL,
      2,
      4,
      NULL,
      '00033',
      '',
      '',
      1.462163,
      NULL,
      '',
      '',
      0,
      '02302',
      '',
      NULL,
      0,
      30.821612,
      125,
      15.337468,
      0,
      7,
      1.068839,
      50,
      0.620320,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.131006,
      NULL,
      NULL,
      2.460757,
      3.180710,
      1.210948,
      1,
      NULL,
      NULL,
      1.979182,
      NULL,
      NULL,
      2.629940,
      3.239997,
      1,
      0,
      NULL,
      NULL,
      1.848551,
      0,
      0,
      0.000966,
      0,
      0,
      0.189044,
      NULL,
      NULL,
      1.381698,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1.306914,
      1,
      NULL,
      NULL,
      NULL,
      1.455135,
      NULL,
      NULL,
      NULL,
      NULL,
      2.604680,
      0,
      0,
      3,
      1,
      2,
      0.224241,
      3.349780,
      NULL,
      1.132666,
      0.488183,
      1,
      2.529541,
      2.362030,
      2.763218,
      1.773394,
      2.199764,
      NULL,
      0.930417,
      1,
      0,
      NULL,
      NULL,
      0.788505,
      0,
      NULL,
      NULL,
      0.802822,
      NULL,
      NULL,
      0,
      0.421820,
      1,
      4,
      5.876741,
      5,
      1.944376,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.662565,
      NULL,
      NULL,
      1.724752,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.285960,
      NULL,
      NULL,
      3,
      4.543462,
      0,
      3.707264,
      1,
      1.638205,
      NULL,
      1,
      0,
      0.564760,
      1.618198,
      0,
      0.412024,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.169056,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      2.835708,
      0.289377,
      1.507253,
      NULL,
      NULL,
      5.396402,
      5,
      2,
      0.770810,
      0.657747,
      0.294477,
      1.980321,
      1,
      1.618337,
      0.756560,
      NULL,
      NULL,
      1.651544,
      NULL,
      NULL,
      0.777388,
      2.896351,
      NULL,
      7,
      5,
      4,
      3,
      2.499806,
      0.229126,
      2.466557,
      NULL,
      3.923900,
      0.743043,
      NULL,
      1.850872,
      2,
      1.640777,
      1,
      0,
      1.018278,
      3,
      NULL,
      2,
      4,
      2,
      2,
      5,
      NULL,
      0.140081,
      NULL,
      1,
      0,
      2.698778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.695551,
      NULL,
      NULL,
      1.758248,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.477720,
      NULL,
      NULL,
      1.065155,
      NULL,
      NULL,
      0.992340,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1,
      0.159485,
      0.571385,
      1,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1.751690,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.655910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.938213,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.259383,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.791103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.722315,
      NULL,
      NULL,
      NULL,
      1.151261,
      NULL,
      NULL,
      NULL,
      NULL,
      97,
      NULL,
      3.669078,
      100.576328,
      12,
      1.633865,
      NULL,
      NULL,
      3,
      1,
      2,
      1,
      7,
      2.606254,
      NULL,
      8,
      42,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.013515,
      1,
      1,
      NULL,
      NULL,
      0.707500,
      0.635157,
      2,
      1,
      0,
      0.793323,
      1,
      0.476895,
      1.593593,
      0.349513,
      1,
      0.479172,
      2.314125,
      NULL,
      0,
      NULL,
      1.863253,
      NULL,
      0,
      NULL,
      1.733626,
      NULL,
      1.280087,
      NULL,
      62,
      NULL,
      1.048795,
      NULL,
      17.820339,
      0,
      1,
      NULL,
      NULL,
      1.317660,
      NULL,
      0,
      NULL,
      0.717715,
      NULL,
      1,
      NULL,
      1.210747,
      NULL,
      1.721746,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.018791,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.470595,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.302551,
      1.947620,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1,
      NULL,
      1.370110,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.945234,
      NULL,
      1,
      NULL,
      0.462507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.268510,
      NULL,
      NULL,
      1,
      NULL,
      0.253333,
      NULL,
      NULL,
      NULL,
      0.616413,
      1.205294,
      0.692549,
      NULL,
      3,
      NULL,
      0.592541,
      NULL,
      406,
      NULL,
      0.040192,
      NULL,
      NULL,
      NULL,
      0.766780,
      1.734532,
      NULL,
      23,
      24.096819,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      1,
      1,
      NULL,
      1.526474,
      3,
      3.038127,
      NULL,
      2.572166,
      1.242278,
      0,
      0,
      NULL,
      0.520364,
      NULL,
      NULL,
      0,
      3.073131,
      NULL,
      1.695894,
      0.021661,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      1.951814,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.838268,
      NULL,
      1.580767,
      0.120014,
      NULL,
      1,
      0.506502,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.831882,
      NULL,
      2,
      9,
      1,
      0.542055,
      NULL,
      NULL,
      59,
      52,
      NULL,
      1,
      7,
      '14422',
      '23044',
      '11232',
      1.502557,
      NULL,
      '',
      '',
      NULL,
      '33032',
      '',
      NULL);
commit;
end;
/


