set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9685662';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-1-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '22',
      1.237578,
      24,
      '2010031',
      0,
      NULL,
      0,
      NULL,
      '4211',
      0.263090,
      0,
      NULL,
      NULL,
      ' 8- 8-1992',
      32.883792,
      6,
      NULL,
      NULL,
      0,
      ' 8- 5-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      3.216639,
      ' 3- 5-1991',
      ' 3- 3-1983',
      NULL,
      0,
      1,
      0,
      1.242921,
      1.977621,
      2.626371,
      1.479728,
      1,
      1,
      88,
      8,
      2,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0.584868,
      1,
      NULL,
      0.126851,
      3.279752,
      NULL,
      1.429087,
      1,
      1.214905,
      0,
      NULL,
      1.673209,
      1,
      NULL,
      NULL,
      3.911276,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      7.292195,
      8,
      5.677705,
      2.489425,
      3,
      1.818120,
      1,
      0.885898,
      4,
      0,
      4,
      0,
      NULL,
      NULL,
      0.579382,
      NULL,
      NULL,
      6,
      2.080603,
      3.549559,
      NULL,
      NULL,
      1.217279,
      2.487880,
      0.374792,
      0,
      3,
      1,
      0,
      0,
      2.767931,
      NULL,
      NULL,
      3.867887,
      NULL,
      NULL,
      3,
      NULL,
      1,
      9,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      1.996431,
      NULL,
      NULL,
      1,
      1.398737,
      1.235371,
      0,
      2,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.855246,
      1.575970,
      0.880996,
      2,
      0,
      NULL,
      0.548308,
      0,
      1,
      3,
      4,
      4.173462,
      3.222743,
      1,
      1,
      1,
      9.569885,
      0.671109,
      NULL,
      NULL,
      3.703749,
      5,
      2,
      5,
      NULL,
      4,
      NULL,
      3.470949,
      NULL,
      NULL,
      6.689938,
      NULL,
      6,
      NULL,
      3,
      0,
      NULL,
      0,
      ' 6-13-1984',
      279,
      ' 2- 8-1983',
      194.248850,
      NULL,
      1.486603,
      0.535582,
      1.156480,
      0.505661,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.811151,
      1.167059,
      NULL,
      0.114024,
      NULL,
      0.795787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.383928,
      NULL,
      2,
      1,
      0,
      1.371248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      5.516586,
      3,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.762673,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.217758,
      0,
      0,
      0,
      0.917568,
      NULL,
      1.891746,
      3,
      47.491107,
      2,
      0.323333,
      32,
      5.737492,
      0,
      0.921393,
      1.741913,
      2.249043,
      NULL,
      1,
      3,
      2.080485,
      3,
      0,
      0,
      2,
      0.967568,
      3.579113,
      NULL,
      3,
      0.082655,
      0,
      1,
      1,
      1.376249,
      1.174840,
      NULL,
      0.702541,
      0.396531,
      0,
      0.423174,
      0.375641,
      0.957352,
      0.471756,
      0,
      NULL,
      1.331999,
      1.351627,
      8,
      NULL,
      NULL,
      7.463359,
      6.775237,
      NULL,
      1,
      NULL,
      0.228695,
      2.527489,
      0,
      59,
      2,
      0,
      33.837611,
      NULL,
      21.950339,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      '31411',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      NULL,
      NULL,
      50.749519,
      2.534460,
      26,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      1.397547,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.428001,
      0.513507,
      1,
      0,
      NULL,
      NULL,
      1.181155,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.926532,
      2,
      NULL,
      2,
      7,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.686640,
      NULL,
      NULL,
      NULL,
      0.282314,
      3,
      3,
      1.011479,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.722098,
      0,
      0.253557,
      0,
      1.347629,
      1,
      0,
      NULL,
      1.260448,
      1.139360,
      2,
      NULL,
      0,
      3,
      2.257564,
      2.170872,
      0,
      2,
      1,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      11.011124,
      3,
      6,
      0.778806,
      0,
      NULL,
      NULL,
      NULL,
      1.435080,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.333259,
      1,
      NULL,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      8,
      6,
      5.884313,
      2,
      2.032640,
      NULL,
      1,
      NULL,
      NULL,
      0.019214,
      2,
      0,
      0,
      NULL,
      NULL,
      1.497020,
      NULL,
      NULL,
      0.884025,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.243300,
      2,
      3.054901,
      1,
      7,
      5,
      3,
      3.345210,
      2,
      2.712021,
      0,
      1.029242,
      8.019734,
      6,
      2,
      6,
      4,
      2,
      1,
      6.208235,
      NULL,
      0.855706,
      2.921515,
      2,
      2.608489,
      NULL,
      3,
      2.250022,
      NULL,
      0,
      9,
      7,
      5.656959,
      1.451901,
      3.381989,
      3.833025,
      1,
      2,
      1,
      0,
      3.665987,
      1,
      3.151416,
      NULL,
      1.075340,
      1.298433,
      1,
      1.440423,
      NULL,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.126064,
      0,
      0.489225,
      1.388766,
      NULL,
      NULL,
      1.287615,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.918450,
      NULL,
      NULL,
      0.196153,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.206030,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.892554,
      NULL,
      NULL,
      0.203624,
      0,
      1,
      0.125603,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.953900,
      NULL,
      NULL,
      NULL,
      0.321539,
      NULL,
      NULL,
      NULL,
      1.680450,
      NULL,
      NULL,
      NULL,
      0.433288,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.678317,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.176963,
      NULL,
      NULL,
      NULL,
      0.178637,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.262852,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.307193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.160038,
      1.944576,
      1,
      0.167466,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.099313,
      0,
      1,
      1,
      1,
      0.454694,
      1.910645,
      NULL,
      0.465569,
      1,
      0,
      1,
      1,
      0,
      0,
      0,
      0.612602,
      1.473905,
      0,
      0.600857,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.162393,
      2,
      1,
      1.195034,
      NULL,
      0.949375,
      NULL,
      NULL,
      NULL,
      0.798551,
      NULL,
      0,
      NULL,
      1.495851,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.707155,
      NULL,
      NULL,
      NULL,
      0.283399,
      3.315126,
      NULL,
      0.399102,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.333226,
      NULL,
      0.238942,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.988207,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.140750,
      1.089418,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.128097,
      NULL,
      2,
      NULL,
      2.115894,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.822015,
      NULL,
      0,
      NULL,
      2.077701,
      0,
      36.338450,
      NULL,
      0.066826,
      NULL,
      NULL,
      NULL,
      0,
      3.346192,
      3,
      5.473937,
      3,
      NULL,
      NULL,
      0,
      10,
      3.631666,
      3,
      NULL,
      1,
      0,
      NULL,
      1.401638,
      0.686817,
      NULL,
      1.379759,
      1,
      NULL,
      0,
      0.088398,
      NULL,
      NULL,
      0.603089,
      NULL,
      0,
      0.094733,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.172196,
      NULL,
      NULL,
      1.696061,
      1.996223,
      NULL,
      0,
      1.447005,
      NULL,
      NULL,
      0.256898,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.322611,
      NULL,
      NULL,
      5,
      10.079997,
      3,
      1,
      NULL,
      8.815335,
      65.097410,
      5,
      NULL,
      4,
      '33214',
      '34331',
      '',
      NULL,
      '',
      NULL,
      NULL,
      0.586562,
      NULL,
      '',
      '');
commit;
end;
/


