set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9712044';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-8-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '04',
      '11',
      30,
      31.225900,
      '3411302',
      1,
      0.899169,
      NULL,
      NULL,
      '3414',
      3,
      NULL,
      NULL,
      NULL,
      ' 0-25-1986',
      32,
      55,
      NULL,
      2.972712,
      0.352677,
      ' 3-27-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      3,
      NULL,
      NULL,
      1.387923,
      NULL,
      NULL,
      NULL,
      NULL,
      10.786310,
      4.913631,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1.083998,
      1.076271,
      NULL,
      0,
      0,
      0,
      1.746557,
      0,
      2,
      2,
      2.684268,
      2.051814,
      0.324716,
      0,
      1,
      0,
      1,
      1.883934,
      1.546358,
      NULL,
      1,
      0,
      NULL,
      1.257966,
      1.542992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.144034,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.988585,
      0.364307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.251151,
      0,
      0.664863,
      1.218083,
      1,
      1,
      0.472827,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.101722,
      0.581189,
      1.478325,
      0.796398,
      NULL,
      1.662825,
      1,
      NULL,
      0,
      2.955619,
      5.440012,
      0.014334,
      3,
      1.294353,
      7.283337,
      5,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.897033,
      0.001355,
      NULL,
      5.845678,
      NULL,
      6,
      6,
      1.994293,
      1,
      3.570358,
      3,
      1.451196,
      NULL,
      0.711127,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.087875,
      NULL,
      1.208054,
      1.213504,
      0,
      0.016424,
      NULL,
      0.821177,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      7,
      1,
      0.650156,
      0.756408,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.034815,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.281419,
      1,
      1.906024,
      0.420407,
      1.395580,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.710599,
      1,
      3.740921,
      1,
      0.075078,
      3,
      3.642121,
      2,
      NULL,
      2,
      1.331160,
      3.936471,
      1,
      1.425022,
      1,
      1.021203,
      0,
      NULL,
      3,
      1.533840,
      0.685468,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      0.249842,
      1,
      3,
      NULL,
      3.980555,
      1,
      NULL,
      NULL,
      1.227371,
      NULL,
      3.708537,
      0.391622,
      0.802806,
      NULL,
      1.818797,
      2.467752,
      NULL,
      3,
      NULL,
      81.491791,
      NULL,
      NULL,
      NULL,
      NULL,
      1.267831,
      5,
      '10003',
      '24142',
      '13234',
      0,
      '',
      '',
      '',
      0.147618,
      '',
      '',
      '',
      0,
      5,
      18,
      25,
      1,
      13.841623,
      NULL,
      1.424267,
      3.567548,
      NULL,
      NULL,
      NULL,
      0.720941,
      NULL,
      NULL,
      0.868364,
      NULL,
      NULL,
      0.618271,
      NULL,
      NULL,
      1.903110,
      NULL,
      NULL,
      0.913760,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.735714,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.022328,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.871756,
      3.512272,
      2.144638,
      3,
      1,
      1.536313,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.959849,
      0,
      4.560709,
      2,
      0,
      0.825852,
      0.136702,
      NULL,
      NULL,
      1,
      4.688881,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.658473,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.653949,
      2.382989,
      3.886015,
      0,
      3,
      2.619385,
      NULL,
      NULL,
      2,
      0.043908,
      5.162110,
      NULL,
      1.332839,
      2,
      NULL,
      1.771510,
      2.188708,
      1,
      3.552515,
      NULL,
      1.569708,
      0,
      1,
      2,
      2,
      1,
      4.562895,
      1.538954,
      1,
      3,
      3.886911,
      1,
      1,
      2.900929,
      0.226165,
      NULL,
      0,
      2,
      3.171186,
      3.282151,
      4,
      7.603307,
      4.864507,
      9,
      7.229573,
      2.057225,
      0.688628,
      7.995747,
      1,
      NULL,
      0,
      0.573607,
      1,
      3.704940,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.649924,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2.869648,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.155121,
      1.440322,
      0,
      0.613962,
      1.617828,
      0,
      3,
      NULL,
      NULL,
      0.469436,
      0.940962,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.778308,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.126407,
      NULL,
      NULL,
      0,
      1.009108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.378467,
      1.811666,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.867104,
      NULL,
      NULL,
      1.329038,
      0.903834,
      NULL,
      NULL,
      1.464969,
      3,
      NULL,
      NULL,
      0.815159,
      NULL,
      NULL,
      NULL,
      1.267744,
      16,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.331701,
      NULL,
      NULL,
      1.139057,
      NULL,
      1.595441,
      NULL,
      2.494816,
      1,
      NULL,
      0,
      1.237918,
      0,
      0,
      NULL,
      0.676211,
      1.644211,
      1.872428,
      1,
      0.954033,
      0,
      1,
      0.482909,
      0,
      NULL,
      0.001077,
      NULL,
      0.722641,
      NULL,
      1,
      NULL,
      1.845976,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      4,
      14.958724,
      NULL,
      1.381523,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.313616,
      NULL,
      0.995315,
      NULL,
      1.603598,
      NULL,
      0.621449,
      NULL,
      NULL,
      NULL,
      0.061547,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.012869,
      1.628643,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.434740,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.653365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2,
      NULL,
      4,
      NULL,
      1,
      NULL,
      2,
      NULL,
      3,
      0,
      1.669793,
      20,
      6,
      2.152394,
      NULL,
      0,
      NULL,
      0.157727,
      NULL,
      0.545420,
      2.242339,
      1.222074,
      0,
      1.377183,
      1.433926,
      1.060021,
      2.263822,
      3.273999,
      1.947086,
      NULL,
      0.128095,
      NULL,
      1.887460,
      0.109261,
      0,
      0,
      1.337071,
      0,
      0,
      1,
      NULL,
      1,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.000146,
      2.919738,
      0.788799,
      NULL,
      0.068535,
      1,
      NULL,
      0.351013,
      NULL,
      1.679312,
      0,
      2,
      2,
      1.271617,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.466649,
      0,
      NULL,
      1,
      4,
      0.573715,
      0,
      0.444275,
      NULL,
      NULL,
      20,
      98.203293,
      1,
      4.636632,
      3,
      '21421',
      '22434',
      '31212',
      NULL,
      '',
      '',
      NULL,
      0.706294,
      '',
      '',
      '');
commit;
end;
/


