set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0142885';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-8-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0,
      2.243574,
      6.759104,
      2.768062,
      6.262730,
      0,
      1.613475,
      3.510542,
      '114',
      '12142122',
      72.400381,
      57,
      '4210010',
      1,
      NULL,
      5,
      NULL,
      NULL,
      5.548062,
      1.709189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.410468,
      2.238802,
      ' 9-15-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      5.400583,
      NULL,
      NULL,
      '11- 1-1976',
      NULL,
      1.863645,
      1,
      1.141314,
      NULL,
      0.211395,
      0.979885,
      0.601839,
      1.724473,
      25,
      2,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.383746,
      NULL,
      0,
      0.608793,
      1.132754,
      0,
      1.273114,
      0.623502,
      0.933352,
      2,
      6.440124,
      NULL,
      0,
      0,
      5,
      5.511715,
      NULL,
      6,
      0.599209,
      0,
      0.982247,
      1,
      0,
      0.187753,
      1,
      0,
      0,
      1,
      0.636043,
      2,
      1,
      3.621929,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.286055,
      NULL,
      2,
      1.802446,
      0.384176,
      NULL,
      0.959194,
      0,
      NULL,
      0.213307,
      0,
      1.030961,
      1.762289,
      NULL,
      0.141336,
      1.494609,
      0,
      0.753634,
      1,
      2,
      1.756653,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.479494,
      5.950483,
      3,
      3.406007,
      1,
      2.491504,
      1,
      1.101356,
      1,
      0,
      1.580030,
      0,
      2.918251,
      1.840252,
      NULL,
      0,
      1,
      0.303166,
      NULL,
      1.085599,
      NULL,
      4.316137,
      1,
      2,
      1.797763,
      1,
      1,
      7,
      1.813822,
      2.503708,
      5,
      1,
      NULL,
      3,
      NULL,
      0,
      1.367897,
      7.182219,
      0.595578,
      3,
      4.533114,
      1.181133,
      9,
      0,
      NULL,
      4,
      1,
      ' 4- 0-1977',
      1158.539689,
      '10- 4-2003',
      1073,
      2.969248,
      1,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.238019,
      0.337130,
      1,
      0,
      0,
      NULL,
      2,
      0.878294,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.745174,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      2.793868,
      0.404662,
      NULL,
      NULL,
      NULL,
      0.092720,
      1.731094,
      0.301912,
      1.393281,
      5,
      NULL,
      4.399794,
      0.265020,
      NULL,
      NULL,
      0.383426,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.087211,
      0.487832,
      0.284449,
      1,
      1,
      NULL,
      2.195468,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.923523,
      NULL,
      1.856126,
      2,
      2,
      0,
      0,
      3,
      3.249400,
      NULL,
      0,
      NULL,
      3.988646,
      1.145432,
      0.727470,
      NULL,
      NULL,
      0.178700,
      0.111055,
      NULL,
      0.660669,
      1,
      1.671339,
      NULL,
      1.585913,
      NULL,
      0,
      1,
      3,
      NULL,
      1.994785,
      5.880022,
      NULL,
      5.548921,
      7.264575,
      3,
      3.745594,
      5,
      NULL,
      6.898980,
      3,
      2.115038,
      2.631358,
      NULL,
      0.281618,
      0.765592,
      NULL,
      NULL,
      NULL,
      NULL,
      4.667952,
      0.135978,
      2.923498,
      '33324',
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      17,
      252.341339,
      56.080691,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.789415,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.643867,
      NULL,
      NULL,
      3,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9,
      3,
      1,
      1,
      1.724665,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.580425,
      3.291246,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.536729,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.437754,
      NULL,
      NULL,
      8.172249,
      NULL,
      2,
      NULL,
      0.456448,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.688481,
      NULL,
      NULL,
      0.654965,
      2,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2.909551,
      NULL,
      0,
      NULL,
      NULL,
      1.047180,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.143959,
      NULL,
      NULL,
      1.345126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.304047,
      NULL,
      NULL,
      0,
      2.803083,
      3.085958,
      3.443483,
      7.802959,
      5.556711,
      3.780029,
      2.690471,
      1.895253,
      NULL,
      2,
      0.254952,
      0,
      2.784101,
      NULL,
      NULL,
      1,
      NULL,
      0.242768,
      3.806887,
      2,
      9,
      6.155325,
      NULL,
      3,
      1,
      2.123344,
      2.666162,
      NULL,
      NULL,
      0.259926,
      3,
      0,
      0,
      1,
      2.185907,
      0.055900,
      3.601788,
      9.674148,
      4.882294,
      3.484108,
      5.867155,
      2,
      1,
      NULL,
      NULL,
      0.036920,
      1,
      NULL,
      0,
      2,
      NULL,
      NULL,
      1.249494,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.990923,
      NULL,
      NULL,
      0.797335,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.976625,
      NULL,
      NULL,
      0.720257,
      NULL,
      NULL,
      0.193458,
      NULL,
      NULL,
      0.741068,
      1.544310,
      1.587877,
      0.714540,
      1,
      0.021064,
      NULL,
      NULL,
      NULL,
      1.593575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.384807,
      NULL,
      NULL,
      NULL,
      1.358171,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.130030,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.415984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.810993,
      NULL,
      NULL,
      NULL,
      1.585086,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.194655,
      NULL,
      NULL,
      0.183358,
      NULL,
      NULL,
      0.006521,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.747538,
      184.985364,
      0,
      NULL,
      0.655507,
      0,
      1,
      0.522551,
      0,
      1,
      0,
      0,
      0,
      1.425517,
      0.802594,
      NULL,
      NULL,
      1.089618,
      1.485206,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.015585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.607509,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.358922,
      1.501559,
      NULL,
      1,
      NULL,
      1.447902,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.748503,
      NULL,
      NULL,
      0,
      1.135785,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.770105,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.199404,
      3,
      NULL,
      1.428308,
      NULL,
      0.078193,
      NULL,
      NULL,
      NULL,
      0.273832,
      NULL,
      0.234902,
      NULL,
      0.555722,
      0,
      0.025638,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.049105,
      0.373773,
      NULL,
      2.815858,
      0,
      5.626987,
      5,
      21,
      3,
      3.731132,
      NULL,
      0.134490,
      0.542322,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      2.788514,
      2.068222,
      NULL,
      3,
      NULL,
      NULL,
      0.114535,
      NULL,
      NULL,
      1.775325,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.544422,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.401846,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.583359,
      NULL,
      1.679815,
      NULL,
      1,
      NULL,
      2,
      4,
      9,
      1.489354,
      NULL,
      3,
      43,
      45.206864,
      NULL,
      3.251284,
      NULL,
      '13132',
      '',
      NULL,
      0.607688,
      '32434',
      NULL,
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


