set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8212287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-2-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '0',
      NULL,
      NULL,
      '3000330',
      0,
      NULL,
      4,
      3,
      '1024',
      0,
      3.846689,
      2,
      2.397746,
      NULL,
      4.266967,
      NULL,
      5,
      3.570360,
      NULL,
      ' 1- 0-1988',
      50,
      4,
      343.150448,
      27,
      1.709709,
      NULL,
      NULL,
      ' 5-18-2000',
      3.074256,
      1.252809,
      0,
      0.246468,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.349324,
      1.492145,
      1.357936,
      NULL,
      7,
      0,
      0,
      0.974083,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0.362883,
      NULL,
      1,
      NULL,
      0.581964,
      NULL,
      1.785446,
      0.894265,
      NULL,
      NULL,
      1,
      0,
      7.519005,
      1,
      0,
      0,
      0.693486,
      0,
      NULL,
      NULL,
      2.883161,
      2,
      0.754259,
      0,
      1.724198,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.515707,
      1.632528,
      0.434913,
      0.319832,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      5.235459,
      3,
      1.675391,
      0.805020,
      1,
      0,
      2,
      0,
      0,
      2,
      1.313483,
      1,
      1,
      1.995626,
      0.481986,
      NULL,
      0.072517,
      1,
      0.227901,
      1,
      1,
      1,
      1.988801,
      NULL,
      4.984952,
      5.405181,
      0,
      0.829805,
      5,
      NULL,
      NULL,
      3.494074,
      NULL,
      5.299542,
      5,
      0,
      5,
      0,
      3,
      0.210752,
      0,
      1.261874,
      NULL,
      NULL,
      ' 6-23-1992',
      134,
      ' 9-23-1998',
      104.811333,
      0.744006,
      0.711090,
      1,
      3.428272,
      1.726901,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.527587,
      NULL,
      0.923074,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      6.301117,
      0,
      0,
      6.532582,
      1,
      2.315167,
      1.012064,
      0.110009,
      9,
      NULL,
      NULL,
      1.545083,
      NULL,
      NULL,
      NULL,
      0.559280,
      NULL,
      3,
      3.377175,
      NULL,
      3,
      1.649488,
      NULL,
      NULL,
      NULL,
      2,
      8.892087,
      1.540894,
      NULL,
      NULL,
      3,
      2.091286,
      ' 8-16-1975',
      6,
      ' 2-14-1985',
      1.408494,
      0.123607,
      0,
      NULL,
      3,
      2.064043,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      2.973329,
      1.303457,
      NULL,
      NULL,
      1.484000,
      NULL,
      3.233367,
      0,
      0,
      3.340980,
      1,
      3,
      0.925650,
      2,
      1.016812,
      NULL,
      NULL,
      0,
      1,
      0.654440,
      0,
      0,
      1.746990,
      1.088207,
      NULL,
      0,
      0,
      3,
      1,
      10,
      5,
      6,
      8.895144,
      NULL,
      5.507109,
      NULL,
      3.297630,
      6,
      3.688600,
      1.176371,
      3.722834,
      2,
      1.465321,
      0,
      78,
      NULL,
      NULL,
      NULL,
      5.356215,
      0.110983,
      1,
      '04243',
      '',
      NULL,
      1.024133,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      3,
      14,
      51,
      43.652263,
      1,
      36,
      2.504889,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.542714,
      0.551952,
      0,
      1.767563,
      NULL,
      NULL,
      1.127233,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      2.885378,
      1,
      0.784370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.257204,
      NULL,
      NULL,
      1.128817,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.548809,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.318789,
      2.153966,
      0.025092,
      1,
      4.278040,
      5,
      1,
      NULL,
      NULL,
      1,
      0.285112,
      1.803999,
      4.313762,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.166118,
      0,
      1.112620,
      1.918045,
      NULL,
      NULL,
      4,
      3,
      1.366814,
      5.148547,
      5.358509,
      1,
      1.248655,
      NULL,
      NULL,
      0.597734,
      3,
      3.528737,
      2,
      1.618932,
      NULL,
      1,
      1,
      2,
      8,
      NULL,
      2.019080,
      2.586207,
      0.848160,
      1,
      0,
      10,
      1,
      1,
      0.138342,
      1.986926,
      2,
      NULL,
      3.234430,
      3.381443,
      6.996887,
      1,
      6.181556,
      NULL,
      2.981907,
      2,
      4.477766,
      NULL,
      1,
      2.162697,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      14,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.588095,
      NULL,
      NULL,
      0.726939,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.646273,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.032313,
      NULL,
      NULL,
      1,
      0.918612,
      3,
      0,
      0,
      NULL,
      0,
      NULL,
      5.537563,
      1,
      NULL,
      NULL,
      NULL,
      397.443249,
      NULL,
      NULL,
      0.253710,
      0.005552,
      NULL,
      NULL,
      0.999244,
      NULL,
      NULL,
      NULL,
      3.289212,
      1.911049,
      NULL,
      NULL,
      1,
      3.456014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3.017389,
      2.332908,
      NULL,
      NULL,
      0.149957,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      1,
      3.929383,
      NULL,
      NULL,
      0,
      1.767685,
      NULL,
      NULL,
      1,
      2.931449,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      2.083090,
      NULL,
      NULL,
      NULL,
      NULL,
      14.646991,
      NULL,
      NULL,
      5,
      1,
      NULL,
      0.009025,
      NULL,
      0.227639,
      2.449223,
      12,
      2.067703,
      NULL,
      18.156090,
      0.058244,
      NULL,
      NULL,
      0,
      NULL,
      3.391958,
      0,
      2,
      0.792661,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1709,
      1,
      1.197042,
      0,
      1,
      0,
      0.164885,
      1.694648,
      1,
      1,
      0.114234,
      0,
      1,
      0,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.298326,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.158850,
      6,
      NULL,
      10,
      4.313245,
      NULL,
      2,
      0,
      7.024118,
      0,
      2.959917,
      0.811544,
      0,
      1,
      NULL,
      0.556453,
      0,
      NULL,
      3.682469,
      2.362159,
      NULL,
      NULL,
      0,
      NULL,
      0.476055,
      NULL,
      NULL,
      NULL,
      3.820421,
      NULL,
      1.464229,
      3,
      NULL,
      1,
      1.451292,
      NULL,
      0,
      0,
      NULL,
      2,
      3.448228,
      NULL,
      1,
      3,
      NULL,
      3.953874,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2.181658,
      1.526337,
      0.916638,
      0,
      3,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.695711,
      3,
      NULL,
      0.405177,
      NULL,
      NULL,
      0.452318,
      1,
      NULL,
      0,
      3.516236,
      1,
      1.264728,
      NULL,
      0,
      1,
      NULL,
      1,
      0.141514,
      NULL,
      2.498212,
      1,
      1.277458,
      NULL,
      3,
      9,
      0,
      NULL,
      NULL,
      NULL,
      71.782095,
      0.474138,
      1.850550,
      4,
      '11043',
      '34111',
      '',
      0.435705,
      NULL,
      '',
      '',
      1.898774,
      '',
      '',
      '');
commit;
end;
/


