set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7100321';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-7-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      '4313242',
      1.172984,
      1,
      2,
      0,
      '2314',
      3.821095,
      1,
      NULL,
      NULL,
      NULL,
      5.122547,
      NULL,
      2,
      NULL,
      0.022370,
      ' 4-20-1995',
      9,
      4.134651,
      NULL,
      83,
      0,
      ' 8-24-1983',
      ' 4-28-1991',
      '10- 1-2001',
      0,
      NULL,
      2.316705,
      0,
      0.056004,
      1,
      4,
      0.327167,
      1,
      NULL,
      15.196471,
      5,
      0.425443,
      2,
      24,
      5,
      14,
      7,
      NULL,
      8,
      2.972270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2.629545,
      NULL,
      2.002683,
      0,
      1.680607,
      0.506938,
      1.217475,
      0.813233,
      1,
      1.682203,
      0.239169,
      0.858729,
      0,
      0.792655,
      6,
      0.036890,
      NULL,
      0.736817,
      0,
      0.859957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.054269,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.996323,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.730436,
      1,
      1.465854,
      5,
      4.109530,
      0.026701,
      0.715935,
      3,
      0.262404,
      1,
      1,
      3,
      1,
      0.831874,
      1.438534,
      1,
      0,
      NULL,
      0,
      3.048283,
      2.851802,
      1,
      NULL,
      0,
      3.887143,
      5.591453,
      3.295258,
      3,
      1,
      1,
      NULL,
      4.182348,
      NULL,
      0,
      1,
      1,
      4,
      3,
      4.028784,
      6.041981,
      NULL,
      NULL,
      1,
      0,
      1,
      1.450047,
      '11- 1-1991',
      116,
      ' 8-11-1977',
      NULL,
      NULL,
      1,
      1.790217,
      1.766156,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.045383,
      0,
      NULL,
      0,
      0.400270,
      1.343422,
      0.866343,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.232233,
      NULL,
      NULL,
      NULL,
      NULL,
      1.522625,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.211551,
      2,
      8,
      0.741859,
      2,
      2,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.771388,
      0,
      1,
      NULL,
      NULL,
      0.775314,
      30,
      1.015549,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      2,
      0,
      0.233310,
      1,
      0.623487,
      NULL,
      1.531115,
      2,
      1,
      NULL,
      NULL,
      1,
      0.384617,
      0,
      3,
      1,
      4,
      1.528872,
      0.888587,
      NULL,
      3,
      0,
      3.465085,
      0.390115,
      0.926530,
      0.338978,
      1,
      4,
      1.923985,
      11.053998,
      8,
      0.074446,
      7.164778,
      5,
      7,
      2.882816,
      3,
      4,
      0,
      3.199435,
      2.438313,
      33,
      2,
      3.046031,
      NULL,
      NULL,
      NULL,
      63.751463,
      3,
      NULL,
      0,
      '21234',
      '',
      '',
      0.691715,
      NULL,
      '',
      '',
      1.081350,
      '',
      '',
      '',
      NULL,
      NULL,
      538.314514,
      78,
      2.006020,
      60,
      5.659886,
      9,
      0,
      1.544496,
      0,
      0,
      1.842047,
      NULL,
      NULL,
      0.281855,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.888576,
      0.627128,
      0,
      2.266092,
      NULL,
      1.602414,
      0,
      NULL,
      NULL,
      1.011661,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.026527,
      NULL,
      NULL,
      NULL,
      7.221324,
      NULL,
      3.910242,
      1.627188,
      NULL,
      NULL,
      NULL,
      1.346965,
      NULL,
      NULL,
      NULL,
      0.931313,
      NULL,
      NULL,
      0.651494,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.060519,
      NULL,
      NULL,
      0.207355,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.237201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.149764,
      NULL,
      NULL,
      3,
      0.383379,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.826317,
      3,
      0,
      0,
      0,
      NULL,
      NULL,
      4,
      6.998073,
      1.535992,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.944067,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2.190980,
      1,
      3,
      0.740340,
      0,
      NULL,
      7.211921,
      1,
      NULL,
      7.606858,
      1.303192,
      1.786931,
      NULL,
      0.632184,
      0.886563,
      NULL,
      NULL,
      1,
      0,
      0.206958,
      NULL,
      0.498639,
      0.647011,
      7.920632,
      4,
      7,
      0.612075,
      0.097767,
      1.644488,
      1,
      NULL,
      1,
      3.701158,
      3.393797,
      2,
      0,
      3,
      NULL,
      NULL,
      NULL,
      5,
      1.232193,
      4,
      1.284117,
      1,
      NULL,
      0,
      1,
      0,
      1.541251,
      NULL,
      0.561872,
      2.466868,
      NULL,
      NULL,
      1.051179,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.213007,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.847089,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.471108,
      0.418144,
      1.698100,
      0,
      1.557299,
      2,
      1.313149,
      NULL,
      NULL,
      2.188260,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.746140,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.880894,
      NULL,
      NULL,
      NULL,
      2.241329,
      NULL,
      NULL,
      NULL,
      1.790171,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.526717,
      NULL,
      NULL,
      NULL,
      7.695510,
      NULL,
      NULL,
      NULL,
      2.775881,
      NULL,
      NULL,
      5.135223,
      0.331653,
      358,
      60,
      1.994230,
      119.660905,
      NULL,
      1.510587,
      NULL,
      NULL,
      1.916546,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.644583,
      NULL,
      NULL,
      0.754493,
      NULL,
      0.732320,
      250.543150,
      46,
      0.067585,
      1.951499,
      1.386948,
      0,
      0,
      0,
      NULL,
      1.812745,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.035289,
      0,
      0.966893,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.691371,
      1,
      NULL,
      1,
      2,
      3.361799,
      NULL,
      1.645808,
      1,
      0.531016,
      NULL,
      NULL,
      1.174829,
      NULL,
      NULL,
      1.200581,
      NULL,
      NULL,
      NULL,
      3.702723,
      NULL,
      0,
      NULL,
      NULL,
      0.298064,
      1.083692,
      NULL,
      1,
      1.348569,
      NULL,
      0,
      3,
      NULL,
      0.578755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.142767,
      NULL,
      0,
      0.751676,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.717709,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      8,
      0,
      0,
      3,
      34,
      86.842566,
      NULL,
      0,
      3,
      '41100',
      '',
      '',
      0.477044,
      '',
      '',
      NULL,
      0.026878,
      '',
      NULL,
      '');
commit;
end;
/


