set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9648262';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '13',
      '12',
      NULL,
      25,
      '2210412',
      2.634749,
      0.468944,
      1,
      3,
      '2033',
      2.603733,
      1,
      NULL,
      NULL,
      ' 2-16-1980',
      129,
      NULL,
      NULL,
      0,
      NULL,
      '10-13-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      2.663499,
      NULL,
      NULL,
      NULL,
      1.830783,
      2.975225,
      2.695077,
      0.427796,
      0.354008,
      1.569843,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      11.850769,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      6,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.775484,
      1.931176,
      1,
      1.950873,
      NULL,
      0,
      0.509473,
      0.710821,
      2,
      NULL,
      2,
      NULL,
      0.928989,
      NULL,
      1.498898,
      NULL,
      1.693952,
      0.334666,
      1,
      0.699506,
      1,
      1.136593,
      1.713086,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.857123,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.494761,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.451740,
      10,
      4,
      7.295528,
      1,
      2,
      NULL,
      0.029312,
      1,
      0.765397,
      0,
      0.140208,
      1,
      1,
      1.152209,
      NULL,
      1,
      NULL,
      0,
      4.591393,
      0.601826,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      0.554117,
      5,
      NULL,
      1,
      0,
      4.157378,
      1,
      7.048519,
      10.085882,
      NULL,
      1,
      4.364724,
      2.965041,
      1,
      5,
      5.997845,
      3.925334,
      9.071336,
      5.099133,
      0,
      ' 1- 7-1989',
      24.289131,
      ' 5-21-1990',
      24,
      NULL,
      0.472736,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.279663,
      0.639310,
      0.411057,
      7.163657,
      0,
      0.963850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.070346,
      1.795374,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.307733,
      1,
      0.563866,
      3.500930,
      0,
      NULL,
      1,
      NULL,
      0.919737,
      1,
      2.319112,
      4.895299,
      1,
      NULL,
      NULL,
      NULL,
      0,
      4.276146,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.914096,
      2,
      1,
      0,
      1.803814,
      0.346606,
      NULL,
      3,
      76,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.958136,
      1,
      3,
      3,
      2,
      2.330483,
      2.020696,
      NULL,
      3,
      NULL,
      NULL,
      0,
      3,
      2,
      1,
      0,
      3,
      NULL,
      NULL,
      3,
      1.729487,
      NULL,
      0.021005,
      1.280815,
      1,
      0.652178,
      0,
      1,
      1.763676,
      NULL,
      NULL,
      0.558627,
      NULL,
      1.942505,
      7,
      5.222879,
      0.519153,
      6.728906,
      0,
      2,
      5,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      34.292055,
      NULL,
      49.875512,
      108.012778,
      3,
      5,
      NULL,
      '0404',
      '40120',
      '',
      1,
      '',
      NULL,
      NULL,
      0.324000,
      NULL,
      '',
      '',
      0,
      12.287881,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      997,
      0,
      NULL,
      NULL,
      0.789792,
      NULL,
      NULL,
      0.583672,
      NULL,
      NULL,
      0.906991,
      NULL,
      NULL,
      0.331159,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.012991,
      1,
      0,
      1.831027,
      0.709911,
      0,
      0.635451,
      0.439545,
      1,
      1,
      0.301820,
      1,
      0.655614,
      0.046964,
      1,
      0.670834,
      0.956433,
      0.831554,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.696078,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.026548,
      1.761053,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.811353,
      1.903623,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.650019,
      1.896894,
      0,
      NULL,
      2.927568,
      NULL,
      69.385960,
      NULL,
      NULL,
      NULL,
      1.896072,
      NULL,
      1.012616,
      NULL,
      0.065101,
      0,
      4.625283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.148925,
      0,
      0,
      NULL,
      2.606362,
      4.332186,
      1.438801,
      2,
      NULL,
      0.427092,
      0.470430,
      0.475785,
      0,
      NULL,
      0,
      1,
      NULL,
      1.868740,
      0,
      NULL,
      1,
      1,
      NULL,
      0.898233,
      0.193585,
      NULL,
      0.692621,
      1.487445,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.888275,
      NULL,
      NULL,
      1,
      3.325861,
      NULL,
      2,
      3,
      NULL,
      3.408973,
      0.216626,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.959470,
      NULL,
      1,
      NULL,
      1.389103,
      NULL,
      NULL,
      2,
      4.147501,
      1.877205,
      NULL,
      NULL,
      101,
      79,
      5,
      NULL,
      1.310846,
      '4234',
      '00314',
      NULL,
      1.436449,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      '');
commit;
end;
/


