set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000217';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-9-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '1',
      NULL,
      NULL,
      NULL,
      1.668130,
      0.527945,
      3,
      0,
      NULL,
      1,
      0.534427,
      NULL,
      40.128628,
      '10-21-1997',
      3,
      NULL,
      4,
      NULL,
      1.940759,
      NULL,
      34,
      4,
      257.539837,
      69.971231,
      5.140245,
      NULL,
      NULL,
      ' 3-28-1977',
      2.781379,
      0.675312,
      0.592744,
      2,
      NULL,
      NULL,
      NULL,
      0.422777,
      NULL,
      134,
      4.297489,
      11,
      2.944927,
      NULL,
      NULL,
      0.798069,
      15.337553,
      7,
      4.258198,
      NULL,
      1.402682,
      1,
      0,
      1,
      0,
      1.584579,
      NULL,
      0.883224,
      0.150325,
      0,
      176,
      NULL,
      NULL,
      3.737183,
      3.105746,
      5.113216,
      1,
      0.850332,
      4,
      1,
      3.094210,
      1,
      0.652451,
      0,
      0,
      1,
      1,
      7,
      0,
      3.500012,
      0.421150,
      0.190156,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.785335,
      1,
      0.249576,
      1.356941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.664174,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      7.698442,
      4.647137,
      NULL,
      6.616200,
      NULL,
      0.283907,
      1.905402,
      1.008289,
      9.366214,
      0,
      3.614339,
      0,
      1,
      0.160197,
      2.594742,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0.552866,
      1,
      4.592517,
      NULL,
      0.426293,
      NULL,
      0,
      0.889966,
      4.592271,
      5.054397,
      1,
      8,
      2.428913,
      6.715606,
      NULL,
      7.851820,
      3,
      NULL,
      2.184867,
      5.520250,
      9.936603,
      4,
      10.612993,
      0.828682,
      ' 7-22-1980',
      NULL,
      ' 0-22-1988',
      403.881670,
      0.325695,
      0.920704,
      0.742031,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0.437793,
      0.603774,
      0.603970,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.279319,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.737336,
      6.665426,
      NULL,
      1.742110,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.401364,
      1.601906,
      1.238472,
      NULL,
      0,
      2.465314,
      2,
      3274,
      0,
      2,
      36,
      4.306282,
      NULL,
      1.314439,
      1.451074,
      0,
      2.421892,
      1,
      NULL,
      NULL,
      1,
      2.588370,
      NULL,
      2,
      3.360871,
      0,
      0.211827,
      1.948539,
      NULL,
      2,
      1.970166,
      0.627593,
      3.449723,
      NULL,
      1,
      102,
      NULL,
      NULL,
      1,
      0.648870,
      1,
      5.160931,
      1,
      NULL,
      1.158709,
      0,
      NULL,
      1,
      4.207084,
      1.198614,
      1.887251,
      1.654146,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      2,
      0.179592,
      33,
      NULL,
      NULL,
      NULL,
      3,
      1.537667,
      1,
      '20421',
      '',
      '',
      1,
      NULL,
      NULL,
      '',
      5,
      '23320',
      NULL,
      NULL,
      2,
      5.904707,
      15,
      24,
      2,
      31,
      NULL,
      14.671543,
      2,
      NULL,
      1,
      NULL,
      0.403166,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.485198,
      0,
      1,
      3,
      0,
      NULL,
      1.185180,
      NULL,
      NULL,
      0.748719,
      1.072803,
      1.558645,
      2,
      NULL,
      0.816305,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7.871574,
      0,
      8.532321,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      3.607400,
      0,
      5.612918,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.464512,
      NULL,
      0.352226,
      NULL,
      0,
      NULL,
      0.857964,
      1.252546,
      1.877672,
      1,
      0.642844,
      0.228161,
      1,
      1,
      0.801097,
      1.731896,
      0.164442,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.934585,
      1.481916,
      0,
      4.469083,
      1.274619,
      0.930713,
      NULL,
      0.621482,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1.353163,
      1,
      3,
      1.288663,
      1,
      2.344140,
      1,
      NULL,
      NULL,
      NULL,
      1.465149,
      7,
      0.962045,
      7.676799,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      4.097874,
      0.018724,
      6,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      17,
      2.375697,
      1,
      0,
      5,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.042726,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      3.067642,
      NULL,
      NULL,
      1,
      4,
      0,
      0.148800,
      0.404406,
      NULL,
      3,
      NULL,
      NULL,
      0.098717,
      NULL,
      11.911545,
      6.797418,
      NULL,
      2,
      1.238288,
      1.738272,
      19,
      NULL,
      NULL,
      1,
      3.132961,
      NULL,
      2.139968,
      0,
      0.335138,
      NULL,
      3.280838,
      9.936186,
      7.015320,
      6,
      9.163255,
      0,
      0.820803,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0.904469,
      NULL,
      NULL,
      0.895960,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.910519,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.104683,
      0,
      6.150126,
      NULL,
      3.126300,
      3.228934,
      81,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.558810,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.404272,
      NULL,
      NULL,
      0.808978,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.922132,
      NULL,
      0,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.527874,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      1.747108,
      NULL,
      1,
      0.822496,
      2,
      NULL,
      0.323143,
      0.047715,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.326480,
      NULL,
      0,
      NULL,
      3.900231,
      3,
      0,
      NULL,
      0,
      1,
      12,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      206.570413,
      3,
      NULL,
      2,
      2.022562,
      1.459998,
      NULL,
      NULL,
      2,
      3.639091,
      1.596285,
      NULL,
      6.037656,
      3,
      1.490687,
      NULL,
      NULL,
      1.662834,
      258,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.792570,
      1,
      1.584155,
      0,
      1.091200,
      1,
      NULL,
      1,
      1.060381,
      NULL,
      0.507027,
      NULL,
      1.408319,
      0.915296,
      1,
      0,
      NULL,
      0.485585,
      NULL,
      0.924895,
      NULL,
      NULL,
      NULL,
      0.007117,
      NULL,
      0.654088,
      NULL,
      21.609937,
      NULL,
      2,
      26,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.986200,
      NULL,
      0.332348,
      NULL,
      1,
      NULL,
      1.942030,
      NULL,
      1.573693,
      NULL,
      1,
      NULL,
      0.723257,
      NULL,
      0.087934,
      NULL,
      1,
      NULL,
      0.119588,
      NULL,
      1,
      NULL,
      1.209240,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.692118,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.319527,
      0.033501,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.471283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.343584,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      NULL,
      1.513049,
      NULL,
      1.258509,
      NULL,
      16,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      3.219881,
      NULL,
      20,
      1.292275,
      NULL,
      NULL,
      NULL,
      5.753730,
      2.133902,
      NULL,
      9,
      NULL,
      6,
      0.392946,
      NULL,
      NULL,
      2.448950,
      0,
      0.495069,
      NULL,
      1.336053,
      0,
      1,
      0.419663,
      NULL,
      NULL,
      1.319026,
      1,
      0.353006,
      NULL,
      1.612508,
      1.245721,
      0.542289,
      NULL,
      1.404016,
      1,
      1.181235,
      1,
      2,
      0,
      1,
      2.058111,
      0.137170,
      0.693901,
      1.661381,
      2.924137,
      1.579214,
      3.490232,
      2,
      0.483870,
      1.121927,
      2.543221,
      NULL,
      NULL,
      1.340557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0.502522,
      0,
      1.922256,
      4.855024,
      7,
      1.666004,
      0.449917,
      1.500817,
      1.438212,
      44,
      NULL,
      1,
      1.542500,
      4,
      '20113',
      '10434',
      '32100',
      3.387997,
      '24002',
      '',
      '',
      4.677481,
      '4302',
      '0233',
      '');
commit;
end;
/


