set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8111275';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-10-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      4,
      NULL,
      0,
      0.056341,
      0.624899,
      1,
      3,
      2.647275,
      '241',
      '03424433',
      31,
      1.554375,
      '1142301',
      3,
      1,
      4,
      3,
      '1144',
      1,
      NULL,
      NULL,
      NULL,
      ' 6- 1-1986',
      NULL,
      65,
      NULL,
      3.293753,
      0.268117,
      '11- 0-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 0-1976',
      ' 6-11-1997',
      '10-20-1990',
      2.826138,
      NULL,
      0,
      3,
      NULL,
      0,
      NULL,
      1.152534,
      0,
      1,
      8.121189,
      11,
      1.724893,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.514525,
      0.829449,
      NULL,
      0,
      0,
      1,
      1,
      5.074886,
      0.754603,
      NULL,
      1,
      0,
      1.264305,
      0,
      2.583504,
      2.929099,
      NULL,
      0.761035,
      3.098853,
      0.565833,
      3,
      6,
      1.461320,
      NULL,
      NULL,
      0.765764,
      1.103932,
      NULL,
      0.801807,
      5,
      0.700353,
      3.690003,
      1.363818,
      NULL,
      NULL,
      0.349575,
      NULL,
      NULL,
      3,
      0.893603,
      0.494145,
      NULL,
      1.782773,
      1.182895,
      2.230035,
      NULL,
      NULL,
      NULL,
      2,
      1.713699,
      0,
      3,
      NULL,
      NULL,
      2.048058,
      1.669241,
      0,
      0,
      1,
      1.516573,
      4,
      0.060009,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2.934929,
      1.151097,
      2,
      NULL,
      1.885702,
      0,
      1.135714,
      0,
      NULL,
      NULL,
      0.450968,
      1.178478,
      1.701560,
      0.171423,
      NULL,
      1.080743,
      0,
      NULL,
      0,
      5.716848,
      NULL,
      1,
      0,
      NULL,
      4,
      4,
      NULL,
      2.997113,
      NULL,
      5.893798,
      NULL,
      1.529304,
      0,
      1.874051,
      6,
      6.316861,
      NULL,
      6,
      5.284986,
      4.347095,
      2,
      2,
      5,
      1.523121,
      1,
      0,
      '10-28-1982',
      56.390572,
      ' 9-14-1990',
      7.934056,
      2.396242,
      1.795679,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0.577897,
      NULL,
      0.299400,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.264896,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.293996,
      0,
      2.830741,
      2.899476,
      0,
      1,
      NULL,
      1.375382,
      NULL,
      NULL,
      1.271942,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.976367,
      NULL,
      0,
      0,
      NULL,
      0,
      3,
      5,
      0.361589,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1.073985,
      3,
      3,
      2.887686,
      3,
      2,
      0,
      NULL,
      3,
      0.625952,
      0.865095,
      3.431657,
      3,
      0,
      1,
      0.870691,
      NULL,
      1,
      0.076924,
      1.652233,
      1.329787,
      1.978958,
      0.906386,
      1.826633,
      NULL,
      1.230543,
      NULL,
      2.484999,
      0,
      11,
      5.277506,
      6,
      10.421634,
      7,
      4.432642,
      2,
      0,
      3,
      2.902138,
      3.359373,
      2,
      37,
      1,
      0.123828,
      23,
      NULL,
      30,
      NULL,
      NULL,
      3.270149,
      NULL,
      '24323',
      '30001',
      '',
      0.371683,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      1.167221,
      35.683009,
      NULL,
      1.787627,
      0.576427,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.238571,
      0,
      NULL,
      NULL,
      0.957375,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.542175,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.823615,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.860744,
      1,
      2,
      NULL,
      NULL,
      NULL,
      2.375860,
      1,
      0.353698,
      NULL,
      NULL,
      2,
      2.294634,
      1,
      1.764446,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.818138,
      0.086408,
      1.271885,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1,
      NULL,
      2,
      0.812908,
      0.388125,
      3,
      2,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.699694,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.152158,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.921445,
      1.788560,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.667553,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.936711,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.270757,
      NULL,
      NULL,
      0.614427,
      NULL,
      NULL,
      0.654232,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.492583,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.445178,
      NULL,
      NULL,
      2.277450,
      1.957501,
      0,
      0,
      0.312655,
      NULL,
      NULL,
      0.234577,
      0,
      NULL,
      7.156742,
      0,
      1,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0,
      0,
      0,
      1.049802,
      NULL,
      1,
      6.227389,
      3,
      3,
      0,
      3.527337,
      1,
      0,
      NULL,
      3,
      1.987033,
      2.400047,
      3,
      1.951700,
      1,
      1,
      5.529565,
      NULL,
      NULL,
      1.023769,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0,
      1.520895,
      NULL,
      NULL,
      1.519588,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.264328,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.380601,
      1.988244,
      0,
      3,
      1,
      NULL,
      NULL,
      0.465040,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.774706,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.244578,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.226505,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.303373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.261722,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      27.785044,
      5,
      0.651442,
      NULL,
      0.256307,
      0,
      NULL,
      0.566536,
      NULL,
      0,
      1.653168,
      1,
      0,
      0.570038,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.183180,
      NULL,
      1,
      NULL,
      2.360098,
      NULL,
      1.523469,
      NULL,
      0,
      NULL,
      2.957727,
      NULL,
      NULL,
      NULL,
      NULL,
      0.746678,
      1.007851,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.324128,
      NULL,
      0.389139,
      NULL,
      0.791605,
      NULL,
      NULL,
      NULL,
      1.838665,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.503485,
      NULL,
      0.545548,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2,
      6.610700,
      3,
      0,
      2.852089,
      3.740400,
      NULL,
      0,
      2,
      1.970102,
      1.222516,
      0.114693,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      1.105349,
      NULL,
      1.073992,
      0,
      NULL,
      0,
      0,
      NULL,
      0.476337,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.043981,
      1.031138,
      NULL,
      0.355667,
      0.546012,
      NULL,
      NULL,
      NULL,
      NULL,
      0.646439,
      1.387544,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      4,
      NULL,
      0,
      NULL,
      NULL,
      43.341984,
      90.409162,
      0,
      NULL,
      5,
      '42322',
      '03402',
      '',
      1.090193,
      '',
      '',
      NULL,
      1.826048,
      '',
      '',
      '');
commit;
end;
/


