set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9129808';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-10-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      NULL,
      NULL,
      '0011142',
      2.313400,
      1,
      3,
      NULL,
      '2140',
      1.162953,
      0,
      NULL,
      NULL,
      ' 4-26-1990',
      7,
      NULL,
      2.691375,
      1,
      NULL,
      ' 4-14-1981',
      98.199930,
      2.443634,
      295,
      65,
      3,
      ' 2-22-1978',
      ' 5-16-1974',
      '11-10-1987',
      2.723313,
      0,
      0.263012,
      0,
      1.151267,
      0,
      1,
      0.338592,
      NULL,
      1510,
      3,
      1.409152,
      15.070917,
      141.345399,
      54,
      6,
      NULL,
      3.811384,
      9,
      6,
      1.747436,
      1.022575,
      1.717358,
      0.700544,
      NULL,
      1,
      1.258118,
      NULL,
      1,
      1.481715,
      199.749740,
      13,
      9,
      2,
      2.474628,
      3.600432,
      1,
      1.287165,
      0.857363,
      0,
      0.009302,
      1,
      0,
      1.667935,
      3.854260,
      3.081568,
      NULL,
      6.007194,
      2.471372,
      5,
      3.007914,
      3,
      NULL,
      NULL,
      NULL,
      0.072121,
      NULL,
      NULL,
      6,
      2.936096,
      NULL,
      3,
      0.154258,
      1,
      NULL,
      NULL,
      0,
      0.740099,
      1.742019,
      1,
      1,
      1,
      1,
      1,
      1,
      0.096773,
      1,
      0.228322,
      1,
      1,
      1,
      1,
      1.397703,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1.605138,
      NULL,
      11,
      3.082345,
      4,
      1,
      3,
      NULL,
      2,
      0.395329,
      9,
      NULL,
      1.259968,
      0.466864,
      NULL,
      0,
      NULL,
      0.949937,
      7,
      5,
      3.645185,
      3.630149,
      4.979685,
      9,
      3,
      2.564121,
      1.863289,
      4,
      1,
      2.764179,
      1,
      3,
      1.666265,
      0,
      NULL,
      NULL,
      NULL,
      11.125486,
      10.379242,
      11,
      5.035887,
      5.728614,
      7,
      5,
      1,
      ' 9-27-1984',
      1000.456341,
      ' 9-18-1992',
      726,
      NULL,
      0.174328,
      0.558653,
      5.022180,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.847898,
      5,
      NULL,
      1,
      0.844298,
      NULL,
      3,
      0.468371,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.698370,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.079546,
      0.111023,
      7.138712,
      2.433627,
      6.333772,
      NULL,
      2.565918,
      1,
      NULL,
      NULL,
      0.114401,
      NULL,
      1.256214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.777464,
      0,
      NULL,
      NULL,
      1.171568,
      0,
      0,
      32,
      0,
      3,
      NULL,
      81,
      867.506570,
      NULL,
      NULL,
      1,
      0,
      2,
      0,
      NULL,
      3,
      NULL,
      2,
      NULL,
      0,
      2,
      2,
      NULL,
      NULL,
      40.036767,
      168.874419,
      29,
      167.765130,
      NULL,
      70,
      185,
      50.292627,
      121.603991,
      NULL,
      86.570720,
      152,
      3,
      NULL,
      19,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.609102,
      NULL,
      NULL,
      16.335274,
      34.267485,
      NULL,
      0,
      3.985739,
      NULL,
      NULL,
      '',
      0.291757,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      38.489913,
      342,
      NULL,
      3,
      62,
      NULL,
      175.584263,
      7,
      3,
      0,
      2.453229,
      1.311176,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.276683,
      NULL,
      NULL,
      0.628326,
      NULL,
      NULL,
      1.651175,
      2.054692,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.210479,
      NULL,
      NULL,
      10,
      0.670489,
      1.177015,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.070914,
      NULL,
      NULL,
      NULL,
      2,
      3,
      2.266618,
      19,
      NULL,
      NULL,
      0.481108,
      NULL,
      NULL,
      0.278158,
      1,
      0.335584,
      NULL,
      0,
      NULL,
      1.782035,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.745175,
      NULL,
      0,
      0.676869,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.026788,
      12,
      0,
      10.183616,
      7.096531,
      2.997527,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.930991,
      NULL,
      NULL,
      NULL,
      0.133233,
      NULL,
      NULL,
      2,
      2.866642,
      3,
      0.128112,
      3.827755,
      1,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      8,
      2.615139,
      2.216193,
      2.736520,
      1,
      11,
      15,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1.235798,
      NULL,
      NULL,
      0.954087,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.262534,
      NULL,
      NULL,
      0.521880,
      NULL,
      NULL,
      0.500076,
      2,
      7.257167,
      0,
      NULL,
      NULL,
      7,
      1.788047,
      NULL,
      7.697777,
      2.498533,
      2.984271,
      1,
      NULL,
      NULL,
      1,
      2.574010,
      1,
      2.929442,
      3.003321,
      3.988867,
      2.727712,
      2,
      0.573570,
      10,
      1,
      4.825596,
      NULL,
      3,
      0.061936,
      1.713273,
      NULL,
      0,
      3,
      3,
      1.876118,
      0,
      2,
      3,
      1.256206,
      1,
      NULL,
      3.611785,
      1,
      0,
      3.043156,
      3,
      0.193603,
      0,
      1,
      NULL,
      1,
      1,
      2.088400,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.371268,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.950413,
      NULL,
      NULL,
      0.658024,
      0.804455,
      0.062955,
      0,
      1.972271,
      1.127588,
      NULL,
      NULL,
      NULL,
      1.633441,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.072815,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.620483,
      NULL,
      NULL,
      NULL,
      2.566448,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.200864,
      NULL,
      NULL,
      NULL,
      0,
      0.417156,
      4.091663,
      0,
      3.490861,
      147.144991,
      77,
      0.647696,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.066530,
      NULL,
      NULL,
      NULL,
      14,
      1,
      1.750231,
      NULL,
      NULL,
      0,
      18.939377,
      0,
      5974,
      22.336275,
      1.858369,
      0.918692,
      1.706767,
      0,
      0.926713,
      1,
      1,
      0.054526,
      1.535453,
      0,
      0.793994,
      1,
      1,
      0.816103,
      0.139046,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.225850,
      0,
      9,
      NULL,
      NULL,
      19.433748,
      8,
      NULL,
      9.458203,
      NULL,
      NULL,
      14.647555,
      10.576772,
      NULL,
      1.956363,
      2,
      NULL,
      10.493836,
      11.649803,
      NULL,
      19.075128,
      NULL,
      NULL,
      NULL,
      12.119332,
      NULL,
      NULL,
      11.917991,
      NULL,
      17.199775,
      2.570387,
      NULL,
      13,
      18.936853,
      NULL,
      3,
      1.649973,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.183768,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.643836,
      NULL,
      NULL,
      NULL,
      2,
      4.621870,
      6,
      0.187685,
      0.991723,
      2.067246,
      12,
      44.787492,
      2,
      0.459403,
      2,
      '43200',
      '',
      '',
      0,
      '',
      '',
      '',
      0.850717,
      '',
      NULL,
      '');
commit;
end;
/


