set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8005729';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-11-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      '0222310',
      1.835859,
      1.947002,
      2,
      3,
      '0202',
      0.369285,
      0.245935,
      NULL,
      NULL,
      NULL,
      43,
      NULL,
      3.585986,
      NULL,
      1.318378,
      ' 0- 1-1992',
      15.691968,
      1,
      NULL,
      NULL,
      NULL,
      ' 9- 8-1990',
      ' 8-15-2003',
      ' 1- 4-2001',
      2.199823,
      3.530555,
      NULL,
      0.256207,
      1.664369,
      1.396166,
      3.729226,
      0,
      1,
      129,
      6,
      2,
      5.596837,
      12,
      35,
      18,
      3,
      4,
      0,
      3.601778,
      0,
      1.561929,
      0.264119,
      1,
      0,
      0,
      1,
      1,
      0.421501,
      0,
      102.026414,
      15.942535,
      4.601469,
      NULL,
      2,
      2.900556,
      0.336065,
      1,
      1,
      NULL,
      0,
      6,
      NULL,
      1,
      NULL,
      0,
      NULL,
      6,
      NULL,
      0.682544,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      10,
      NULL,
      0,
      0.804701,
      0,
      NULL,
      NULL,
      NULL,
      3.601987,
      1,
      2.478187,
      0,
      1.478187,
      2,
      1,
      1,
      3.549975,
      2,
      NULL,
      1.974703,
      0.025489,
      0.084568,
      5,
      1.621620,
      1.699698,
      1.890184,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      9,
      0,
      1.257998,
      10.381539,
      0,
      1,
      NULL,
      1.515443,
      1,
      1,
      0,
      0.915602,
      0.150622,
      1.860629,
      1.189391,
      0.854450,
      1.330899,
      1.885937,
      NULL,
      1.264679,
      8,
      NULL,
      1.181509,
      3,
      4,
      6.730471,
      7.925520,
      0,
      0.389957,
      2,
      6.567072,
      0,
      1,
      0.647415,
      8,
      NULL,
      NULL,
      3.423599,
      6,
      0,
      8,
      5.239762,
      2,
      NULL,
      NULL,
      4.311026,
      2.258676,
      ' 2-13-1999',
      498,
      ' 0- 5-1989',
      NULL,
      2.474331,
      1.234128,
      0.484012,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.954609,
      NULL,
      0.106653,
      NULL,
      NULL,
      NULL,
      1.764347,
      1.703050,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.719678,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.718145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.954816,
      1.254825,
      NULL,
      1,
      1.632699,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.525169,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.398869,
      1,
      0,
      1.305914,
      1,
      0.590254,
      1,
      3.400740,
      784,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.809074,
      3,
      1,
      3.547702,
      NULL,
      1,
      1.516705,
      0.670263,
      3,
      0.465670,
      NULL,
      16,
      15,
      19,
      147.497613,
      81.886805,
      139.325585,
      189.287857,
      95,
      1.498449,
      0,
      NULL,
      0.066341,
      0,
      1,
      1,
      NULL,
      11.737006,
      0.466469,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.572014,
      NULL,
      9.574018,
      29,
      13,
      5.966208,
      1.945022,
      0.873839,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      1,
      3.660919,
      NULL,
      24.435159,
      0.366451,
      0,
      4.367256,
      46,
      0.492120,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.137475,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.549226,
      NULL,
      NULL,
      1.686084,
      1.327452,
      0.145461,
      1.392672,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.487246,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.196273,
      NULL,
      NULL,
      NULL,
      1.709388,
      1.570410,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      1,
      3,
      NULL,
      0.822570,
      1,
      0,
      NULL,
      NULL,
      2.407788,
      1,
      1.752804,
      3,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4,
      7.186246,
      2.416752,
      NULL,
      NULL,
      NULL,
      NULL,
      1.550345,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      2.770380,
      2.417773,
      2,
      1.242867,
      NULL,
      NULL,
      1.666878,
      6.944709,
      5.767227,
      NULL,
      NULL,
      NULL,
      0.883849,
      NULL,
      NULL,
      0.130921,
      NULL,
      NULL,
      1.073932,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.034284,
      NULL,
      3,
      0,
      NULL,
      NULL,
      0,
      1,
      4,
      2,
      7,
      0.802023,
      4,
      5,
      1.554464,
      NULL,
      0,
      1.316573,
      0,
      1.482851,
      0.589251,
      0.762749,
      NULL,
      NULL,
      NULL,
      3.865525,
      0,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      3.050975,
      1.761636,
      2.026631,
      0.781232,
      1.778723,
      NULL,
      NULL,
      6,
      3.389575,
      2.417527,
      4.281917,
      4.524926,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0,
      1,
      3.562546,
      NULL,
      NULL,
      0.778640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.976221,
      NULL,
      NULL,
      1.237221,
      NULL,
      NULL,
      0.906667,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.868667,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.758796,
      0,
      2,
      1,
      NULL,
      NULL,
      1.775694,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.729136,
      NULL,
      NULL,
      NULL,
      0.209964,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.065206,
      NULL,
      NULL,
      NULL,
      1.880866,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      208,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.475462,
      1,
      0,
      1,
      10.967712,
      2.231281,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.664282,
      12913.069794,
      1736,
      NULL,
      1,
      1.391298,
      1.073294,
      1.627203,
      NULL,
      1,
      1,
      1,
      NULL,
      1.388188,
      0.047539,
      1,
      1,
      0.604602,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.980679,
      1,
      1,
      0,
      3,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.038109,
      2,
      NULL,
      1,
      0.068196,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.121024,
      NULL,
      1,
      1,
      NULL,
      1.403644,
      1,
      NULL,
      0,
      0.271949,
      NULL,
      0.639523,
      1,
      NULL,
      1,
      3,
      NULL,
      NULL,
      1.706138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.228827,
      6.187170,
      8,
      3,
      0.687771,
      NULL,
      18.105731,
      14,
      NULL,
      1,
      0.130884,
      '01213',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      NULL);
commit;
end;
/


