set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9988431';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-12-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0,
      3,
      5,
      5,
      2.594692,
      1,
      NULL,
      0,
      '131',
      NULL,
      84.133966,
      NULL,
      NULL,
      2.551920,
      1.174343,
      5,
      2,
      '3202',
      NULL,
      0.388713,
      NULL,
      NULL,
      NULL,
      NULL,
      24,
      NULL,
      0,
      0,
      ' 0- 1-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 5- 6-1980',
      ' 6- 4-1998',
      '11- 0-1988',
      1.519032,
      0.327056,
      3,
      2.531773,
      0,
      1,
      3.600141,
      0,
      0.283113,
      5.837455,
      NULL,
      15.157758,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.139855,
      NULL,
      1.814931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.865071,
      0.497648,
      NULL,
      NULL,
      7,
      NULL,
      0.983101,
      NULL,
      4.377988,
      1,
      7,
      0.008571,
      5.767702,
      5.060606,
      5.376097,
      1.488167,
      3.198868,
      0.003330,
      3.221206,
      2,
      NULL,
      1.891490,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5.389146,
      7,
      0.085216,
      0,
      1.153217,
      NULL,
      2.906268,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      1.204042,
      1.553068,
      0.131980,
      0,
      5,
      NULL,
      4,
      0.726437,
      0.912030,
      3.278060,
      1.967431,
      0.855080,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.963163,
      0,
      0,
      NULL,
      2.202313,
      0.647290,
      NULL,
      NULL,
      1,
      NULL,
      0.496175,
      2,
      0.753725,
      0.935328,
      0,
      0.011908,
      1,
      NULL,
      1,
      NULL,
      1.699432,
      1,
      1.964846,
      0.018667,
      0.120083,
      1.199441,
      4,
      0.080993,
      1,
      NULL,
      1.880183,
      0.230879,
      3,
      1,
      3,
      2.598574,
      3,
      2,
      7.001167,
      3,
      8,
      0,
      4,
      0.927965,
      1.924303,
      1.728756,
      NULL,
      349.143043,
      ' 8- 7-1985',
      382.062112,
      2.731895,
      1.523520,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.709033,
      1.352477,
      0,
      NULL,
      1.855169,
      1,
      0.317019,
      0.321682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.807581,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.236334,
      0.076206,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7.288840,
      1,
      1,
      1.406727,
      1.909554,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.389534,
      1.905504,
      1.546169,
      0.881135,
      1,
      2,
      5.289463,
      1,
      0.820808,
      NULL,
      NULL,
      NULL,
      3,
      0.032345,
      0.231713,
      0.842994,
      1,
      NULL,
      3.105360,
      1.485172,
      1.802743,
      2.023482,
      2,
      NULL,
      1.780813,
      0.498177,
      1.833467,
      2.808097,
      0,
      1.012393,
      1,
      0,
      0,
      NULL,
      1,
      0.759889,
      0,
      NULL,
      NULL,
      0.273996,
      0.864191,
      3,
      0.453882,
      0.676561,
      0,
      1,
      NULL,
      4.450828,
      9.666314,
      7,
      0,
      3.395395,
      7.756015,
      3,
      2,
      NULL,
      24.644022,
      0.005406,
      2.570423,
      27,
      NULL,
      47,
      NULL,
      NULL,
      NULL,
      NULL,
      '32443',
      '',
      '',
      0.039674,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      3,
      29.042402,
      3,
      NULL,
      1,
      23.265136,
      NULL,
      1,
      0,
      3,
      1,
      2.030633,
      1.218166,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.119855,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.728150,
      NULL,
      NULL,
      2.696672,
      1,
      NULL,
      NULL,
      0,
      0.683474,
      3,
      0,
      0.271571,
      1,
      NULL,
      NULL,
      4.728702,
      NULL,
      0.787584,
      0.860648,
      1.384894,
      NULL,
      NULL,
      NULL,
      1.696906,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.734273,
      1.550936,
      0,
      0.886850,
      NULL,
      1,
      0,
      0.384750,
      0.097461,
      0.558738,
      3,
      0.107329,
      0,
      3.110568,
      1.464117,
      0.223104,
      3.416187,
      2.308290,
      0.097071,
      1.651621,
      3.353705,
      1.859648,
      1.330623,
      1,
      NULL,
      NULL,
      0.579824,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6,
      0,
      1.809576,
      0,
      0.180550,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.278416,
      NULL,
      NULL,
      3,
      1,
      3,
      1.953024,
      3,
      NULL,
      1,
      NULL,
      NULL,
      3,
      7,
      0.813199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.954943,
      NULL,
      NULL,
      1.474846,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.544762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      3.593052,
      0,
      0.097891,
      NULL,
      NULL,
      1,
      1,
      0.833788,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.012576,
      2,
      1.666718,
      0,
      1.264322,
      NULL,
      2.237321,
      1.793676,
      0.183379,
      2.689579,
      NULL,
      NULL,
      NULL,
      6,
      3,
      3,
      2.024537,
      4,
      1,
      3,
      2,
      NULL,
      0,
      1.845512,
      1,
      0.712003,
      1.302418,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.878181,
      NULL,
      NULL,
      0.101614,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.519515,
      NULL,
      NULL,
      2.409692,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.836217,
      0.362658,
      1.770854,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.889849,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.549483,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.043804,
      NULL,
      NULL,
      NULL,
      1.132389,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.280897,
      NULL,
      NULL,
      NULL,
      0.447470,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.939834,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.124358,
      1.381049,
      1,
      1,
      1,
      1,
      1.667704,
      NULL,
      0.331523,
      1.512936,
      0.852064,
      1,
      1.817184,
      0.720610,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.145226,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.984074,
      0.207277,
      4.520229,
      0.498193,
      3.002486,
      3.347576,
      0,
      5,
      NULL,
      3,
      1,
      NULL,
      1.941815,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.576838,
      NULL,
      0,
      0.298845,
      NULL,
      0.757379,
      0,
      NULL,
      1.993756,
      1,
      NULL,
      NULL,
      0.327468,
      NULL,
      0.238552,
      NULL,
      1.556676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.818375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.991305,
      NULL,
      0,
      NULL,
      4.487136,
      NULL,
      1,
      1.505681,
      NULL,
      NULL,
      NULL,
      75,
      2.258547,
      5.261311,
      NULL,
      '32123',
      '',
      '',
      0.825676,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


