set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228662';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-11-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '1042234',
      1.327741,
      0.983791,
      6,
      2,
      '0412',
      3.641469,
      NULL,
      NULL,
      NULL,
      NULL,
      51.364476,
      NULL,
      1,
      2,
      1,
      ' 7- 9-2003',
      5,
      NULL,
      290,
      NULL,
      3,
      '10-15-1995',
      ' 2- 2-1996',
      ' 9-25-1992',
      3,
      2,
      1.161349,
      3.929230,
      1,
      0,
      1,
      1,
      1,
      NULL,
      3.478740,
      9.236735,
      6.104831,
      NULL,
      9,
      NULL,
      8,
      1,
      0.037378,
      6,
      0,
      2,
      0.721826,
      NULL,
      0.699899,
      1,
      0,
      3,
      NULL,
      0.762703,
      0,
      1,
      1,
      5.670190,
      2,
      7.424068,
      1,
      1.592964,
      1,
      0.832915,
      1,
      5.755392,
      1.858213,
      0.316695,
      1.599713,
      1.136118,
      1,
      1,
      3,
      5.567371,
      1,
      1.761610,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      1.718288,
      0,
      NULL,
      NULL,
      1.489784,
      0.415791,
      0.539590,
      1,
      0.707982,
      NULL,
      1.832717,
      2,
      1,
      0,
      0,
      0,
      NULL,
      1,
      0,
      5,
      2.803848,
      1,
      5.105377,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.314419,
      2,
      NULL,
      0.693037,
      1,
      NULL,
      0,
      1.703493,
      NULL,
      1.992317,
      1.999129,
      1,
      0.864843,
      NULL,
      NULL,
      0,
      2.730663,
      0,
      NULL,
      1.769268,
      0.328260,
      NULL,
      NULL,
      0,
      0,
      1.423193,
      0,
      NULL,
      3.592517,
      3.406657,
      2,
      4,
      10,
      0,
      5.680618,
      1.608695,
      1,
      1,
      8.648219,
      NULL,
      11.430735,
      3.721484,
      1,
      NULL,
      6.822393,
      5.430458,
      0,
      3.130849,
      0,
      NULL,
      '11-11-1999',
      NULL,
      ' 7- 1-1994',
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.069930,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.132870,
      1,
      0.960791,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      3,
      NULL,
      1.381490,
      4,
      0,
      1,
      1,
      2.545827,
      5.236761,
      NULL,
      NULL,
      1.266146,
      3.459197,
      NULL,
      NULL,
      5,
      3.216122,
      3,
      9,
      1.870146,
      2.933793,
      0.475249,
      NULL,
      NULL,
      NULL,
      2.725533,
      10,
      NULL,
      3,
      0.477003,
      2,
      6.888235,
      NULL,
      75.832694,
      ' 3-21-1982',
      13.477528,
      0.742850,
      1.765329,
      NULL,
      3,
      1,
      1.312967,
      1.629938,
      NULL,
      0.532556,
      1,
      NULL,
      38,
      NULL,
      0.923450,
      NULL,
      NULL,
      NULL,
      0.803070,
      0,
      NULL,
      0,
      1.419986,
      2,
      NULL,
      1.041576,
      1,
      NULL,
      2,
      0.409643,
      NULL,
      0.328886,
      1,
      3,
      4.184366,
      0,
      3.959331,
      2.564512,
      1.103116,
      NULL,
      1.572871,
      1,
      1.715279,
      0.369470,
      0.434313,
      0,
      0.061014,
      0.788529,
      1.311754,
      NULL,
      6,
      1.774446,
      7,
      7.263712,
      3.079478,
      7.321171,
      NULL,
      1.827822,
      2.525693,
      3.517601,
      2,
      3.547271,
      12,
      NULL,
      3.801644,
      NULL,
      11.644594,
      NULL,
      81,
      NULL,
      0,
      1,
      '42203',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.908764,
      '',
      '',
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.614320,
      1,
      NULL,
      0.836659,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.408798,
      NULL,
      NULL,
      1,
      NULL,
      0.254443,
      572.996858,
      NULL,
      1.416371,
      0.719919,
      1.253935,
      NULL,
      1.661488,
      0,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      1,
      1,
      0,
      1,
      1.460689,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.121234,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.380670,
      3.979070,
      2.966035,
      6,
      3,
      1.531234,
      3.685294,
      1.182514,
      NULL,
      NULL,
      3,
      0,
      0,
      NULL,
      NULL,
      0.265546,
      1,
      NULL,
      0.516311,
      1.067997,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      2.287841,
      NULL,
      0.367418,
      2.469806,
      NULL,
      1,
      0,
      NULL,
      0.771827,
      0,
      NULL,
      0,
      3.577828,
      NULL,
      0,
      2,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.580845,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.786121,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      38,
      0,
      0.730769,
      NULL,
      NULL,
      NULL,
      '',
      0.595933,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


