set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228662';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-9-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      '0143211',
      2.693418,
      1,
      2,
      2,
      NULL,
      3,
      0.260739,
      NULL,
      NULL,
      ' 8-17-1988',
      69,
      NULL,
      1.645049,
      2.002346,
      1.300665,
      ' 8- 5-1979',
      14.938897,
      2.474822,
      202,
      86,
      1.093629,
      ' 7- 2-1985',
      ' 6- 1-1976',
      ' 8-28-1974',
      NULL,
      0,
      NULL,
      1,
      1.606231,
      NULL,
      NULL,
      1,
      0,
      32,
      8,
      19.473785,
      9,
      13,
      NULL,
      5,
      30,
      4,
      2,
      2,
      1.875983,
      3,
      0.833335,
      NULL,
      0.260792,
      NULL,
      0.187884,
      3,
      NULL,
      0.141108,
      0,
      NULL,
      3,
      NULL,
      2.431285,
      NULL,
      1.058930,
      1,
      NULL,
      NULL,
      1.129445,
      1,
      1,
      6.625295,
      NULL,
      1,
      0,
      6,
      1.041638,
      2.148425,
      2.254453,
      1.027398,
      0.016999,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      10.058212,
      0,
      0.641796,
      3.694033,
      NULL,
      NULL,
      NULL,
      1.656348,
      0,
      1,
      2.910027,
      2,
      0,
      2.839625,
      NULL,
      3,
      0,
      1,
      1.392385,
      2,
      1.100085,
      0,
      9.550043,
      0.578793,
      5.489554,
      5,
      1.568926,
      NULL,
      NULL,
      0.245620,
      NULL,
      NULL,
      0,
      3.203546,
      1,
      1.202908,
      3.423704,
      1.938697,
      0,
      1.900182,
      NULL,
      NULL,
      1.215831,
      1.025226,
      1,
      1,
      1.705493,
      0.021224,
      1.629481,
      1.791179,
      0.459626,
      NULL,
      0.394905,
      1.614640,
      1,
      NULL,
      3.596555,
      NULL,
      0,
      NULL,
      0.927106,
      2,
      NULL,
      1.793571,
      NULL,
      6.742575,
      2,
      1,
      3.127609,
      NULL,
      0,
      3,
      2.682126,
      6,
      3.846523,
      1.922300,
      NULL,
      1.572558,
      1.839971,
      1.625109,
      ' 0- 6-1987',
      NULL,
      ' 6-17-1999',
      156,
      2.178323,
      NULL,
      NULL,
      2.930859,
      1.115674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      7,
      NULL,
      3.758967,
      4,
      1,
      1.907950,
      1.364690,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.705545,
      0.141144,
      2,
      NULL,
      0,
      1.972129,
      3,
      1,
      1,
      0,
      1,
      NULL,
      1.249726,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.779826,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.692775,
      NULL,
      NULL,
      0.633889,
      0,
      NULL,
      NULL,
      0,
      75.748036,
      1.670348,
      1.885479,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.655035,
      3.461942,
      2,
      1,
      1.881269,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.912079,
      1,
      1.122270,
      3.267967,
      NULL,
      NULL,
      1,
      1.286893,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.663972,
      4,
      1.266264,
      0.849619,
      5,
      1,
      11,
      6,
      NULL,
      2,
      3,
      1,
      NULL,
      0,
      0,
      29,
      NULL,
      1,
      NULL,
      5.610325,
      NULL,
      10.190511,
      3.193282,
      2,
      1,
      '3414',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      3.026870,
      38,
      25,
      49,
      3,
      28.261098,
      2,
      0,
      0.701478,
      0.467364,
      0.699859,
      0.810336,
      1.653423,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.183421,
      NULL,
      NULL,
      1.023397,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.878640,
      0,
      0.408528,
      0,
      1,
      3,
      1.725625,
      NULL,
      NULL,
      2.870620,
      3.489802,
      NULL,
      1.996311,
      2.265675,
      0.758746,
      0,
      7,
      3,
      1.690645,
      1,
      NULL,
      NULL,
      NULL,
      3.847706,
      NULL,
      3.605572,
      0.289628,
      NULL,
      2.190494,
      2,
      NULL,
      0.464936,
      1.735873,
      1,
      NULL,
      NULL,
      2,
      0.289499,
      2,
      1.320134,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      0,
      0.432910,
      3.357791,
      0.577301,
      3,
      1.174976,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.761570,
      NULL,
      NULL,
      NULL,
      0.993007,
      0.145587,
      0.961248,
      2,
      1,
      NULL,
      NULL,
      0,
      0,
      2,
      0.474393,
      0.726449,
      1.585500,
      0,
      NULL,
      NULL,
      1.589768,
      7.365084,
      NULL,
      1.390574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.010288,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.582091,
      NULL,
      NULL,
      0.312381,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.684861,
      2.342040,
      NULL,
      0.008028,
      NULL,
      1.302905,
      7.053307,
      0,
      4.314242,
      NULL,
      8.892719,
      0.474921,
      4,
      2,
      NULL,
      NULL,
      3,
      3.285688,
      2,
      0.361792,
      3.073277,
      1.406635,
      3.006401,
      3,
      NULL,
      4,
      0,
      3.567240,
      3,
      NULL,
      1.973259,
      0,
      2,
      3,
      1,
      0.715103,
      NULL,
      0,
      NULL,
      0,
      6.750034,
      5.949584,
      1,
      7.189093,
      4.899536,
      0.647905,
      NULL,
      NULL,
      1,
      0.163347,
      0.424180,
      NULL,
      0.436965,
      3,
      NULL,
      NULL,
      1.240975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.396262,
      NULL,
      NULL,
      2.400595,
      NULL,
      NULL,
      0,
      NULL,
      1.721936,
      1,
      3.358596,
      NULL,
      3,
      NULL,
      9,
      0.019110,
      0.464174,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.542028,
      NULL,
      1,
      NULL,
      0.237970,
      NULL,
      2.504471,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.540837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      NULL,
      2.286330,
      0,
      1,
      NULL,
      1.538339,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2.938640,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      2,
      1.265965,
      3,
      NULL,
      2.689718,
      1.770674,
      NULL,
      NULL,
      NULL,
      1.841752,
      18,
      NULL,
      3.415822,
      1.900316,
      2,
      0.627014,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.448685,
      NULL,
      NULL,
      1.720419,
      NULL,
      NULL,
      0,
      NULL,
      0.681034,
      41,
      0,
      1.374491,
      1.931883,
      0,
      1.388580,
      1.447850,
      0,
      1,
      0.876793,
      0.861278,
      NULL,
      0.908446,
      0,
      1.800995,
      0,
      1,
      1,
      0.967404,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.555565,
      3,
      11.105281,
      3,
      0,
      0.644437,
      0,
      5,
      2.244764,
      3.709255,
      NULL,
      1,
      1,
      NULL,
      0.079896,
      NULL,
      3,
      0.001685,
      0,
      NULL,
      0.813557,
      NULL,
      3.890402,
      0.474179,
      0.004997,
      1,
      1.079619,
      0.308804,
      3,
      1.578583,
      1,
      NULL,
      0.643910,
      NULL,
      2.538341,
      1.255439,
      0.824453,
      NULL,
      1.538458,
      3.768873,
      2.896525,
      NULL,
      2.599989,
      2,
      1,
      1.896691,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.566780,
      0.479786,
      0,
      NULL,
      NULL,
      NULL,
      1.878488,
      NULL,
      0.887773,
      NULL,
      NULL,
      NULL,
      2.317060,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.265099,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      43.172731,
      0.751650,
      NULL,
      NULL,
      1,
      1,
      1.549727,
      1,
      NULL,
      1.312198,
      4,
      0,
      0.674346,
      NULL,
      NULL,
      71,
      114,
      3,
      2,
      0.326335,
      '12423',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


