set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9126231';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-12-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '4',
      NULL,
      NULL,
      '4444013',
      2,
      1,
      2,
      NULL,
      '1222',
      0,
      1,
      NULL,
      NULL,
      '11-18-1993',
      50,
      NULL,
      7.030258,
      NULL,
      1.068460,
      ' 2-29-1985',
      NULL,
      NULL,
      7.692761,
      71,
      1.189791,
      '10-20-1977',
      ' 4- 1-2002',
      ' 6-20-1984',
      0.878683,
      2,
      3,
      0.663776,
      0,
      1.231294,
      7,
      1,
      0,
      6,
      5,
      8,
      6.415477,
      5,
      0.049490,
      3,
      NULL,
      1.310196,
      2.330935,
      3,
      NULL,
      3,
      0,
      0.540746,
      0,
      0.887578,
      0.671420,
      1,
      0.189992,
      NULL,
      1,
      NULL,
      0.197675,
      0,
      NULL,
      5.530743,
      0.810722,
      1,
      1,
      0.809596,
      2.934622,
      NULL,
      NULL,
      5.617140,
      0.793076,
      NULL,
      0.159952,
      7,
      1.922596,
      5,
      1.540891,
      1.952755,
      0.899620,
      NULL,
      NULL,
      1.151088,
      NULL,
      NULL,
      NULL,
      NULL,
      0.222626,
      0,
      0.374673,
      1.816254,
      2.699725,
      2.441779,
      1,
      3.423122,
      1.072702,
      0,
      1.394924,
      3,
      1,
      0,
      1.164070,
      3,
      NULL,
      3.283234,
      0,
      1,
      2,
      0.865129,
      3,
      3,
      1,
      NULL,
      NULL,
      0.318133,
      NULL,
      NULL,
      1,
      NULL,
      3,
      0.165922,
      5.938553,
      3.476310,
      6,
      NULL,
      1,
      2,
      5,
      1.816493,
      1.021929,
      2.247962,
      1,
      1.372461,
      0.496829,
      0,
      1.202669,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      0.823100,
      3,
      1.794693,
      5.871627,
      NULL,
      3,
      1,
      NULL,
      1.788382,
      1.911771,
      5.658833,
      3,
      6.861992,
      0.349196,
      NULL,
      4.012080,
      6.396556,
      3,
      NULL,
      1,
      2.801305,
      NULL,
      NULL,
      203.556729,
      ' 0- 7-1993',
      106,
      NULL,
      1,
      0.309106,
      6.285792,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.344714,
      NULL,
      0.207801,
      0,
      1,
      0.747998,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.458982,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.227962,
      1.533090,
      7,
      1,
      1.835032,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1.877975,
      0.552754,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.676255,
      1.913996,
      0.700291,
      NULL,
      1,
      1.399576,
      173.044913,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.179537,
      1.266671,
      3,
      NULL,
      NULL,
      0,
      1.782159,
      NULL,
      2.271871,
      3.656289,
      0,
      NULL,
      NULL,
      3.944603,
      3,
      1,
      0.867085,
      NULL,
      NULL,
      1.450769,
      1.411240,
      4.086735,
      1.555011,
      1,
      0.739242,
      1,
      0,
      2,
      2.097195,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      39,
      30,
      8.863351,
      1.595245,
      1,
      2,
      NULL,
      '',
      '',
      0.432116,
      '',
      '',
      '',
      0.244586,
      '',
      '',
      '',
      0.568655,
      16,
      NULL,
      1.227090,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.681721,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.636659,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.570521,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      2.372766,
      3.269419,
      0.996304,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      8,
      7,
      0,
      1.866164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.060120,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.601583,
      0,
      3.850644,
      1.227001,
      3.524409,
      1,
      NULL,
      3,
      NULL,
      0.339247,
      NULL,
      1,
      NULL,
      2.556893,
      NULL,
      NULL,
      NULL,
      0.252816,
      NULL,
      NULL,
      0.922416,
      NULL,
      NULL,
      6.078180,
      NULL,
      4,
      0,
      1.859971,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1.661481,
      NULL,
      NULL,
      NULL,
      0,
      4,
      NULL,
      NULL,
      3.553835,
      NULL,
      0,
      NULL,
      3.662592,
      7,
      0.563111,
      NULL,
      1.544984,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.478052,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.322473,
      NULL,
      NULL,
      0.855179,
      NULL,
      NULL,
      0.615810,
      2,
      3.483328,
      4,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3.587686,
      3.470569,
      3,
      NULL,
      2,
      0,
      3,
      0.210224,
      2,
      1.710181,
      NULL,
      NULL,
      4.035039,
      2,
      0.231674,
      NULL,
      2,
      1.640209,
      2,
      3.275782,
      2,
      1.728334,
      NULL,
      3,
      1,
      3,
      NULL,
      NULL,
      NULL,
      2.314615,
      1.441986,
      3.029403,
      NULL,
      3.816877,
      1.349393,
      1.298748,
      1,
      1,
      0,
      3.258716,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.322123,
      NULL,
      NULL,
      1.118059,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.882152,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.847218,
      NULL,
      NULL,
      3.456734,
      NULL,
      NULL,
      1.596995,
      0.122803,
      1.542514,
      0.962180,
      0,
      3.290949,
      0.123661,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.456193,
      NULL,
      NULL,
      NULL,
      0.613027,
      NULL,
      NULL,
      NULL,
      0.418601,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.834925,
      NULL,
      NULL,
      NULL,
      1.689722,
      NULL,
      NULL,
      NULL,
      0.765677,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.195256,
      NULL,
      NULL,
      NULL,
      2.748168,
      NULL,
      NULL,
      NULL,
      1.086821,
      NULL,
      NULL,
      NULL,
      1.790384,
      NULL,
      NULL,
      NULL,
      0.653908,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.032512,
      NULL,
      NULL,
      0.742932,
      NULL,
      1,
      13529.481956,
      NULL,
      0.724973,
      0,
      1.724810,
      0,
      1.760826,
      1,
      0,
      NULL,
      1,
      1.128278,
      NULL,
      0,
      1.159858,
      1.357672,
      0.526935,
      1.834981,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.072125,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.836400,
      0.065509,
      3,
      1.653239,
      2.588825,
      3.356507,
      3.024269,
      NULL,
      3.509428,
      3.780702,
      1,
      NULL,
      0.204497,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.564702,
      NULL,
      0,
      0,
      NULL,
      0.361631,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.799026,
      NULL,
      0.603677,
      0,
      NULL,
      0.291498,
      1.735017,
      NULL,
      NULL,
      0.684965,
      0.680098,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.370565,
      NULL,
      0.835674,
      NULL,
      NULL,
      0,
      7.227504,
      1.840742,
      NULL,
      NULL,
      NULL,
      18,
      5.361295,
      0,
      0,
      '13032',
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      0.988211,
      NULL,
      '',
      '');
commit;
end;
/


