set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9636751';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-1-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '20',
      '20',
      NULL,
      12,
      '2012011',
      1,
      NULL,
      0,
      1,
      NULL,
      4,
      0.119205,
      NULL,
      NULL,
      '11-20-1999',
      46.696081,
      27.306234,
      NULL,
      NULL,
      0,
      '10-20-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      1.642922,
      ' 0- 8-1995',
      ' 5-14-1978',
      ' 7-13-1996',
      1,
      NULL,
      3.683087,
      NULL,
      1,
      3,
      0,
      2.124549,
      NULL,
      NULL,
      NULL,
      NULL,
      7.580419,
      NULL,
      NULL,
      NULL,
      NULL,
      4.328827,
      2,
      NULL,
      0.344077,
      1.522167,
      NULL,
      NULL,
      1.486832,
      1,
      1,
      0.333335,
      0,
      3,
      NULL,
      NULL,
      5.380472,
      1,
      0,
      0.702003,
      1,
      NULL,
      0,
      0.325001,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      5.936789,
      0,
      5,
      0.923104,
      3.149283,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.875796,
      1,
      1.185117,
      3.270306,
      0.561323,
      0.883672,
      0,
      1.774317,
      1.136721,
      1.500214,
      NULL,
      2,
      0.786532,
      1.908413,
      0.178446,
      1,
      0,
      NULL,
      0,
      6.722415,
      4.649231,
      1,
      NULL,
      1.171512,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.992308,
      NULL,
      4.995777,
      1.175388,
      6,
      1,
      0.534041,
      1,
      1.441001,
      0.189716,
      1.913969,
      NULL,
      0,
      0.843449,
      0,
      1,
      NULL,
      1.233703,
      0,
      NULL,
      0.046402,
      11.366761,
      0.053515,
      NULL,
      4,
      1.507892,
      0.092523,
      0.119593,
      2,
      NULL,
      8,
      3.739908,
      0.415161,
      0,
      1.625220,
      1.999438,
      NULL,
      NULL,
      11,
      5.949473,
      1,
      4.869892,
      NULL,
      7.030841,
      4,
      1,
      4.685663,
      2.742240,
      ' 1-20-1988',
      200.278616,
      ' 1- 6-1995',
      3.475246,
      0,
      1,
      0,
      NULL,
      1.512948,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.392670,
      1,
      NULL,
      0,
      0,
      1.116125,
      0.775434,
      0.229393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.217712,
      1.146420,
      0.388320,
      0.708608,
      1.315075,
      1,
      45.986061,
      1,
      0.736858,
      3,
      2,
      0,
      0.702298,
      1,
      4,
      NULL,
      8,
      3,
      2,
      6,
      1.291808,
      NULL,
      NULL,
      0.534400,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.629340,
      NULL,
      NULL,
      2,
      46.676555,
      0.053604,
      1.898191,
      NULL,
      NULL,
      NULL,
      NULL,
      0.102000,
      NULL,
      1,
      0.438253,
      0.081681,
      0,
      3.764490,
      2.701109,
      3,
      3,
      3,
      0.244480,
      NULL,
      NULL,
      NULL,
      3,
      0.362709,
      0.015018,
      4.880106,
      NULL,
      0.437234,
      NULL,
      0.368114,
      1,
      0.914057,
      NULL,
      1.022520,
      NULL,
      1,
      3,
      1,
      9.783801,
      0,
      NULL,
      8.182006,
      3.640683,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0,
      NULL,
      43.894470,
      NULL,
      2.253416,
      NULL,
      NULL,
      NULL,
      68.323440,
      3.198286,
      4.920448,
      5,
      NULL,
      '33313',
      '',
      0,
      '',
      '',
      '',
      0.336175,
      '',
      '',
      '',
      0.534027,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.282025,
      0.722060,
      505,
      0,
      NULL,
      NULL,
      1.673728,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.643629,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.074931,
      23,
      1,
      0.114438,
      0.577976,
      1,
      2.663527,
      0,
      1,
      0.710081,
      1.468718,
      0,
      0.577730,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      0.420375,
      0.531289,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3.896768,
      NULL,
      NULL,
      NULL,
      0.479758,
      39,
      6.595569,
      0.677128,
      0.260987,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.555146,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.300299,
      NULL,
      0.811471,
      NULL,
      3.103376,
      NULL,
      NULL,
      NULL,
      1.494327,
      NULL,
      0,
      NULL,
      0.179350,
      NULL,
      1.099197,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.833478,
      5,
      NULL,
      7.868385,
      5,
      5,
      1.787187,
      2,
      8.050202,
      0.020976,
      3.684375,
      0,
      0,
      NULL,
      NULL,
      0.782772,
      1.427949,
      NULL,
      0.711426,
      NULL,
      NULL,
      0.388365,
      1,
      NULL,
      1.271611,
      3.086958,
      NULL,
      NULL,
      3.075385,
      NULL,
      3.797394,
      2,
      NULL,
      2,
      NULL,
      NULL,
      1,
      1.492992,
      NULL,
      2,
      2.904112,
      NULL,
      3.961620,
      0.535832,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.142831,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.136698,
      NULL,
      0,
      NULL,
      1.918842,
      6.347844,
      10.996632,
      1.063505,
      0,
      0.028970,
      55.247861,
      78,
      NULL,
      0.611022,
      4.489990,
      '31033',
      '21211',
      '',
      0.135216,
      '',
      NULL,
      '',
      0.435836,
      '',
      '',
      NULL);
commit;
end;
/


