set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9809301';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-11-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3.411826,
      5,
      3,
      0,
      0.440850,
      NULL,
      NULL,
      3.188063,
      '321',
      '20003133',
      35,
      13,
      NULL,
      NULL,
      0.866585,
      3,
      2,
      '0342',
      NULL,
      0.638167,
      NULL,
      NULL,
      ' 1-15-1987',
      50,
      42,
      NULL,
      2,
      2,
      ' 3- 5-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 3-18-1976',
      ' 8- 2-1992',
      NULL,
      0,
      NULL,
      3.167633,
      0,
      NULL,
      0.675783,
      3.347507,
      0.288476,
      NULL,
      NULL,
      NULL,
      2.984645,
      1.816253,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      1,
      1.154927,
      NULL,
      0,
      1,
      0,
      1.252041,
      0,
      0.292523,
      1,
      0.844825,
      0,
      2,
      5,
      NULL,
      1,
      1.093083,
      1.377981,
      0,
      1,
      1.150070,
      NULL,
      0,
      NULL,
      1.660904,
      0,
      0.598745,
      5.246091,
      NULL,
      2.073081,
      1.315212,
      2.405673,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.543736,
      1,
      1.521457,
      0.340883,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.536167,
      NULL,
      1.385421,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.469422,
      0,
      NULL,
      0.086861,
      2,
      4.508703,
      0.368536,
      1,
      2.611713,
      3.057686,
      1.730624,
      1.351987,
      0,
      1.874545,
      0,
      1,
      0,
      0.753042,
      NULL,
      1,
      0.834759,
      NULL,
      1,
      1.970995,
      0.524376,
      3.014858,
      2,
      0,
      1,
      2,
      1.670218,
      0.858659,
      5.588554,
      0.381265,
      5,
      0,
      0.656083,
      NULL,
      2,
      3.264132,
      2.555809,
      0.411237,
      NULL,
      1,
      1.462777,
      0.805628,
      3,
      ' 3-28-1975',
      15,
      ' 5- 7-1978',
      3,
      3.783532,
      0,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.957532,
      0,
      1,
      0.375171,
      0.173993,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      9,
      2,
      1.168208,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.108723,
      0.571475,
      5.247599,
      0.420646,
      1.763233,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.749874,
      1,
      0,
      1,
      1.898255,
      NULL,
      3,
      14.252036,
      1,
      1.713284,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.623190,
      NULL,
      NULL,
      1,
      3,
      3,
      3,
      1.140295,
      3,
      NULL,
      1,
      NULL,
      3,
      3.344060,
      0.333934,
      1,
      0.234868,
      0.271420,
      1,
      0,
      1,
      1,
      0,
      0,
      1,
      0,
      1,
      2.959032,
      1,
      1.647520,
      NULL,
      11.079488,
      2.494117,
      11.143433,
      2.306038,
      6,
      1,
      0,
      7,
      1,
      0,
      NULL,
      NULL,
      3,
      NULL,
      49.610903,
      NULL,
      53.739197,
      NULL,
      1,
      NULL,
      3,
      '11303',
      '40130',
      '',
      1.878816,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      28,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.540424,
      0,
      0.611317,
      0.876346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.602931,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.144237,
      NULL,
      NULL,
      1,
      0,
      1.320722,
      1,
      NULL,
      0.750616,
      NULL,
      1.365810,
      0.062826,
      1,
      1,
      1,
      0.582855,
      1,
      0,
      0.892034,
      0.119546,
      1.538374,
      NULL,
      1.979809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.568848,
      0.396266,
      0.982069,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.632482,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.356104,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.276807,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.842975,
      0.653140,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.569036,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      294,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.276227,
      1,
      29.837112,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.840525,
      1,
      0,
      NULL,
      0,
      0.168267,
      0.733081,
      NULL,
      NULL,
      1.424090,
      0.139529,
      1.286429,
      1,
      NULL,
      1.654476,
      1,
      NULL,
      1,
      1,
      NULL,
      0.907353,
      1.129418,
      NULL,
      1.896494,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.001976,
      NULL,
      0,
      0,
      NULL,
      1.921918,
      NULL,
      NULL,
      1.907438,
      0,
      NULL,
      0,
      0.194643,
      NULL,
      1.270642,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.559596,
      NULL,
      1.797761,
      NULL,
      1,
      NULL,
      0.721911,
      1,
      0.772881,
      NULL,
      NULL,
      NULL,
      107.385299,
      70,
      4.542649,
      0,
      2.648394,
      '23110',
      '31413',
      NULL,
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


