set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8736368';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-9-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      NULL,
      3.415948,
      1,
      4,
      1,
      '2400',
      2.703000,
      0.680526,
      NULL,
      NULL,
      ' 8-26-1978',
      30.191037,
      NULL,
      3.403835,
      1.527125,
      0,
      '11-28-1987',
      24,
      1,
      225,
      109.413115,
      3,
      ' 0-28-1977',
      ' 8-17-1988',
      ' 0-14-2000',
      0,
      0.718865,
      0.324965,
      NULL,
      0.533744,
      1.515454,
      NULL,
      NULL,
      0.874755,
      7.178399,
      11,
      4.089569,
      1.290543,
      10.530474,
      8,
      4,
      5,
      3,
      0,
      NULL,
      1.885796,
      1.925511,
      1.062194,
      0,
      NULL,
      0.190190,
      1,
      1.910649,
      0.025534,
      NULL,
      1,
      6.503678,
      0,
      5,
      0.174280,
      NULL,
      NULL,
      0,
      1.052970,
      0.625585,
      3.719523,
      3,
      1.472377,
      1,
      0,
      4.633942,
      1,
      4,
      0,
      4.593891,
      0.285382,
      2.339378,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.355435,
      0.458210,
      0.532724,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.918333,
      NULL,
      3,
      NULL,
      0,
      0.209082,
      NULL,
      NULL,
      1.874974,
      NULL,
      NULL,
      0,
      1.148901,
      2.636512,
      0,
      5.586828,
      0.224701,
      1,
      1,
      NULL,
      0,
      1,
      1.215994,
      1,
      0,
      0.601060,
      0,
      1,
      0.940481,
      1.119347,
      NULL,
      0,
      0.183477,
      1.692255,
      1.126038,
      1.593026,
      0.838205,
      1,
      3.449516,
      0.302294,
      0.489493,
      NULL,
      NULL,
      NULL,
      5.341145,
      0,
      2,
      NULL,
      0,
      6.039045,
      NULL,
      1,
      5,
      2,
      1,
      1.386938,
      0.859106,
      0,
      0.913031,
      ' 7- 9-1995',
      38,
      ' 2-25-1989',
      11.194414,
      1.436054,
      1,
      3.108461,
      NULL,
      0.840201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.402971,
      NULL,
      1,
      1.214759,
      0,
      0.286215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      16,
      2.552918,
      NULL,
      4.838273,
      1.691673,
      2,
      NULL,
      0,
      NULL,
      2,
      0.383051,
      1,
      3.638641,
      NULL,
      NULL,
      NULL,
      0,
      0.794324,
      NULL,
      NULL,
      4,
      8.237750,
      0.145863,
      NULL,
      NULL,
      0.329221,
      6.381280,
      0.601548,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.425372,
      1.386508,
      1.889649,
      1.344480,
      NULL,
      0.971222,
      15,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2.599543,
      1,
      0.744326,
      NULL,
      NULL,
      0.898637,
      1.544392,
      NULL,
      3,
      3,
      3,
      1.073696,
      2,
      NULL,
      2.461705,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.339683,
      1.465051,
      NULL,
      1,
      NULL,
      0.334238,
      2,
      NULL,
      7,
      NULL,
      0,
      1,
      NULL,
      6.591877,
      2.865437,
      2.917202,
      NULL,
      1,
      2,
      1,
      45,
      0.560541,
      1.462716,
      NULL,
      48,
      3.680290,
      91.325683,
      3.545421,
      0.941245,
      1.051371,
      '34124',
      '22431',
      NULL,
      1,
      NULL,
      '',
      NULL,
      1,
      NULL,
      '',
      '',
      0,
      26.308365,
      69.499737,
      17.993503,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.575264,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.790623,
      NULL,
      NULL,
      1.179073,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.669261,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.295013,
      NULL,
      NULL,
      0.106421,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.749396,
      NULL,
      NULL,
      1.297280,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.857165,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.742110,
      NULL,
      NULL,
      1.529111,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.598701,
      NULL,
      NULL,
      1.733537,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.296312,
      NULL,
      NULL,
      1.103877,
      NULL,
      NULL,
      1.048970,
      NULL,
      NULL,
      0.422158,
      NULL,
      NULL,
      1.635092,
      NULL,
      NULL,
      NULL,
      4,
      5.619005,
      0.591907,
      NULL,
      NULL,
      2.260106,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.996432,
      NULL,
      NULL,
      3,
      2,
      4.081872,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1.028523,
      1,
      NULL,
      NULL,
      0.176662,
      0.737789,
      1,
      2,
      0,
      NULL,
      1.842641,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.053269,
      0.218102,
      0,
      1,
      0.698069,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.787603,
      NULL,
      NULL,
      0.820389,
      NULL,
      NULL,
      1.761521,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      3.418305,
      0.368093,
      NULL,
      1.826467,
      1.555493,
      0.316553,
      0,
      1,
      NULL,
      NULL,
      2,
      0.909031,
      0.135424,
      NULL,
      0,
      NULL,
      0.343533,
      NULL,
      1.672683,
      NULL,
      0,
      NULL,
      0.167997,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.485451,
      0.322748,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.006906,
      1.252795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.510618,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.658400,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.770844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.332202,
      NULL,
      NULL,
      2.636547,
      NULL,
      8.390565,
      NULL,
      2.818909,
      NULL,
      0,
      0.204178,
      0.353203,
      NULL,
      0.814958,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.940665,
      NULL,
      1,
      NULL,
      NULL,
      0.698540,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      5,
      0,
      5,
      NULL,
      1,
      5.048243,
      4,
      9,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.098065,
      1.237708,
      NULL,
      NULL,
      1.141773,
      NULL,
      0,
      2,
      NULL,
      0.700626,
      1.603935,
      NULL,
      1,
      NULL,
      NULL,
      3.220171,
      1,
      NULL,
      NULL,
      1.415753,
      NULL,
      0,
      0.000895,
      NULL,
      0.191625,
      3.759952,
      NULL,
      0,
      3,
      NULL,
      1.888110,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.530502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.496409,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.199184,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      27,
      1,
      NULL,
      0.787150,
      NULL,
      2.671259,
      NULL,
      1,
      NULL,
      0,
      5,
      7,
      NULL,
      NULL,
      NULL,
      130.257399,
      12.265089,
      4.720496,
      1,
      0,
      '01022',
      '10034',
      '43343',
      0,
      '20304',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


