set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6107767';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-2-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      '3030224',
      1.573583,
      1,
      NULL,
      1,
      '3003',
      NULL,
      NULL,
      NULL,
      NULL,
      '11-16-1992',
      40.096954,
      NULL,
      0.453626,
      3.227226,
      0.547984,
      ' 5-29-1983',
      NULL,
      2.431807,
      118.927979,
      107.803636,
      1,
      ' 1-13-2002',
      ' 6-22-2001',
      ' 3- 0-2000',
      NULL,
      0,
      1.393283,
      1.098061,
      NULL,
      2,
      8,
      0,
      1,
      133.237864,
      8.580049,
      17.165050,
      0,
      10.696722,
      11,
      5,
      2.354120,
      1.567739,
      2,
      5,
      NULL,
      0,
      1,
      1,
      NULL,
      1,
      1.664699,
      1,
      1.026065,
      1,
      NULL,
      2,
      NULL,
      1,
      2.122539,
      10,
      1.463253,
      5.592250,
      1,
      3,
      NULL,
      0,
      1.858898,
      5,
      2,
      8.151230,
      7.552934,
      4.209254,
      1,
      1,
      5.447834,
      1.266254,
      NULL,
      NULL,
      NULL,
      0.819602,
      NULL,
      NULL,
      NULL,
      1.699273,
      0,
      0.258173,
      3.836600,
      1.561447,
      0,
      0.982195,
      3.614421,
      1.998904,
      NULL,
      0,
      3,
      1.558857,
      0.772710,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.232939,
      8,
      0,
      1,
      2.740549,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.638293,
      0,
      9.355345,
      1,
      6,
      3.998618,
      1,
      NULL,
      2,
      4,
      1,
      NULL,
      0.662055,
      NULL,
      0,
      1.070180,
      0,
      0,
      0.619453,
      NULL,
      NULL,
      NULL,
      3,
      0.662209,
      NULL,
      NULL,
      0.409739,
      1,
      1,
      NULL,
      4.342526,
      0,
      0.749679,
      2.391167,
      4.901575,
      NULL,
      8,
      6,
      8.064150,
      1.689504,
      5.109353,
      3,
      5,
      NULL,
      0.692296,
      3,
      3.631173,
      2.298680,
      NULL,
      1306,
      ' 2-28-2000',
      593.720258,
      0.795235,
      1.311046,
      0,
      NULL,
      1.420186,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      9.466454,
      1,
      1,
      0.333290,
      1.377574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.546734,
      NULL,
      NULL,
      NULL,
      NULL,
      1.207035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.582628,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      7.850468,
      0,
      1,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.829814,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.857417,
      1,
      NULL,
      1,
      0,
      2,
      3562.727252,
      NULL,
      1,
      NULL,
      NULL,
      645.378847,
      1,
      1.851905,
      0.151455,
      3,
      0,
      NULL,
      0.218934,
      2.977911,
      5,
      1,
      1.656656,
      3.529824,
      3,
      NULL,
      NULL,
      17.663019,
      195.336304,
      NULL,
      189.159965,
      5.490842,
      17.179965,
      3,
      NULL,
      NULL,
      22.682032,
      NULL,
      33,
      169.957763,
      1,
      14.542116,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      21,
      25.871948,
      1,
      1.034464,
      1.181239,
      1.769662,
      NULL,
      '',
      '',
      1.708283,
      '',
      '',
      NULL,
      2,
      '3433',
      '441',
      NULL,
      3.476714,
      16,
      115.601136,
      3,
      1.009780,
      27,
      164.512792,
      1734.918899,
      11.193511,
      0,
      NULL,
      2.836101,
      1,
      NULL,
      NULL,
      1,
      19.692146,
      NULL,
      1.317094,
      0,
      1,
      1.244065,
      13.322758,
      NULL,
      0,
      8.063170,
      1.730674,
      NULL,
      2,
      2,
      1,
      19.912215,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      9,
      0,
      NULL,
      10,
      1,
      1,
      6,
      0.128769,
      NULL,
      6.613456,
      4.514051,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.424399,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.730373,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.909438,
      1.861965,
      NULL,
      1,
      1.771574,
      0.175708,
      0.544769,
      3.009741,
      0.078992,
      0.286121,
      3,
      1,
      3.356334,
      1.039705,
      NULL,
      2,
      2.958675,
      1.009296,
      1.541255,
      0,
      NULL,
      NULL,
      0.012661,
      7.538569,
      1,
      3.530145,
      1,
      5.053428,
      0.893941,
      0.241814,
      NULL,
      NULL,
      NULL,
      0.903071,
      NULL,
      NULL,
      NULL,
      0,
      2.164124,
      1.003326,
      3.423227,
      3.495603,
      1.443083,
      0,
      4.166590,
      0,
      NULL,
      4.257600,
      NULL,
      7.358434,
      2.616872,
      NULL,
      0,
      14,
      0.147490,
      NULL,
      NULL,
      NULL,
      6.962208,
      0,
      NULL,
      1.948797,
      NULL,
      NULL,
      1.305227,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.563320,
      1,
      1.163594,
      3,
      3,
      5,
      2.733191,
      3,
      5,
      2,
      4,
      0,
      2,
      1.182456,
      1,
      0.891463,
      3,
      3,
      NULL,
      0,
      0,
      NULL,
      2.165014,
      NULL,
      NULL,
      2.680091,
      0,
      17.682329,
      2,
      1,
      NULL,
      NULL,
      3.573287,
      13,
      1,
      2.110992,
      14,
      NULL,
      1,
      NULL,
      0.616233,
      3,
      3.060031,
      4.653899,
      1,
      1.887782,
      7,
      0,
      0,
      0.074043,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.138412,
      NULL,
      NULL,
      1.786474,
      NULL,
      NULL,
      2.299414,
      NULL,
      NULL,
      1.012172,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.277479,
      NULL,
      NULL,
      2.874475,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.060678,
      NULL,
      0,
      NULL,
      NULL,
      4.681811,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.054049,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.497634,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.946174,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.923991,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      4.145562,
      0,
      1,
      1,
      331.213431,
      384,
      1,
      20,
      2,
      1.727776,
      NULL,
      NULL,
      0,
      4.955666,
      NULL,
      2.112340,
      12,
      0,
      1,
      NULL,
      NULL,
      2.562831,
      NULL,
      0.424421,
      329.955542,
      56.257762,
      1.256149,
      0,
      1.092399,
      1.221009,
      0,
      1,
      0,
      0,
      0.841659,
      1.818430,
      0,
      0.026131,
      1.878142,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.541630,
      2.408527,
      5,
      3,
      1.090542,
      NULL,
      2,
      0,
      11,
      NULL,
      0,
      NULL,
      0.205382,
      1,
      NULL,
      NULL,
      3.974169,
      NULL,
      2.272634,
      2.427852,
      NULL,
      0.070542,
      1,
      NULL,
      3,
      2.637796,
      NULL,
      NULL,
      0.373822,
      NULL,
      0,
      NULL,
      NULL,
      0.453460,
      1,
      NULL,
      1.489156,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.358198,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.437325,
      NULL,
      1,
      NULL,
      5,
      NULL,
      NULL,
      1,
      1.247871,
      1,
      28.185698,
      44,
      4,
      0,
      2,
      '32204',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      5.584518,
      NULL,
      '422',
      '0020');
commit;
end;
/


