set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000185';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-9-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      2,
      '3043',
      2,
      1.324313,
      2.702721,
      12.809719,
      ' 6-28-1996',
      14.045651,
      NULL,
      2.812669,
      3.702021,
      0.154941,
      ' 7-22-1998',
      8,
      2,
      NULL,
      NULL,
      7.264899,
      NULL,
      NULL,
      ' 7-20-1980',
      NULL,
      0,
      1,
      NULL,
      0.107150,
      2,
      1.881864,
      1,
      NULL,
      146.250538,
      3.218585,
      6.883720,
      5,
      8,
      22.930782,
      4.301139,
      17.837457,
      NULL,
      2.941781,
      11.713774,
      0.783688,
      0.420778,
      1,
      1,
      1.468000,
      NULL,
      NULL,
      1.152069,
      NULL,
      0.806079,
      NULL,
      NULL,
      8,
      0,
      2,
      NULL,
      1.362101,
      2,
      2,
      NULL,
      NULL,
      2,
      3.509243,
      3.915329,
      3.469028,
      1.497074,
      2,
      4.322068,
      0,
      3,
      1.046989,
      NULL,
      NULL,
      NULL,
      NULL,
      1.954195,
      NULL,
      NULL,
      4,
      2,
      1,
      NULL,
      1.869767,
      0,
      0.092511,
      NULL,
      0,
      0.601244,
      1.375759,
      1.840607,
      1,
      1,
      1.105381,
      0,
      NULL,
      1.306039,
      0.493662,
      0,
      0.854950,
      0.906639,
      2,
      1.945373,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.533083,
      NULL,
      NULL,
      1,
      1,
      0.586601,
      0,
      2.547988,
      0,
      0.865133,
      0,
      3,
      1,
      1,
      NULL,
      0.448809,
      2.971097,
      0,
      1,
      0.968924,
      1.477320,
      1.823211,
      NULL,
      1,
      NULL,
      0.397511,
      NULL,
      2.729971,
      0,
      2,
      NULL,
      3,
      9,
      7.458782,
      1,
      7.568911,
      NULL,
      1.161441,
      NULL,
      3.437892,
      NULL,
      0,
      0,
      2.502230,
      1,
      0.219259,
      1.580172,
      0.472523,
      6,
      NULL,
      1.471590,
      '10-12-1998',
      17,
      ' 4-17-1990',
      4.591624,
      NULL,
      0.344267,
      0,
      3.550684,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.536847,
      0.122158,
      NULL,
      0.362741,
      1.284243,
      0.853821,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.660623,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.145779,
      NULL,
      6,
      2,
      3,
      NULL,
      3.456912,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.741409,
      1.869476,
      1,
      1.851806,
      0,
      1.776621,
      1,
      5547.685021,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.886813,
      2,
      1,
      0,
      1.449041,
      0.978809,
      6.592179,
      2.966112,
      NULL,
      0,
      1,
      0.326813,
      1,
      0,
      0.302882,
      NULL,
      1.221255,
      NULL,
      0.629327,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.809355,
      38.091440,
      NULL,
      NULL,
      NULL,
      NULL,
      1.503940,
      3,
      '10322',
      '',
      '',
      0.783709,
      '',
      '',
      NULL,
      3,
      '1110',
      NULL,
      '',
      2,
      27,
      NULL,
      4,
      NULL,
      10.327563,
      15.353369,
      NULL,
      5,
      NULL,
      1,
      3.008517,
      1.050360,
      NULL,
      NULL,
      1,
      1,
      6,
      1.143219,
      NULL,
      NULL,
      1,
      0,
      2.204752,
      0.505253,
      1,
      0.976183,
      2.906498,
      1,
      0,
      0.111428,
      NULL,
      NULL,
      0,
      3,
      1.599267,
      0.283487,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      9,
      0.204627,
      3,
      0.189055,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.812902,
      1.880104,
      3,
      2.361536,
      NULL,
      0.828017,
      4,
      NULL,
      NULL,
      3,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2.343828,
      NULL,
      3.271841,
      0,
      1.976225,
      0,
      1,
      1.500935,
      NULL,
      NULL,
      NULL,
      NULL,
      1.233918,
      NULL,
      NULL,
      0.785841,
      3,
      0,
      9.405346,
      0,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.003330,
      2.432556,
      1.920913,
      NULL,
      NULL,
      1,
      1.721764,
      0,
      NULL,
      NULL,
      6,
      3.919527,
      2.250139,
      NULL,
      NULL,
      1.612673,
      0.274896,
      NULL,
      NULL,
      8,
      0.327828,
      2,
      1.217529,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.794084,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.620990,
      NULL,
      NULL,
      2.079745,
      NULL,
      4,
      5,
      0.279982,
      3,
      1.134928,
      4,
      5.511914,
      7.938048,
      NULL,
      1.650936,
      2.694087,
      2,
      0.940826,
      3.826164,
      NULL,
      3.943055,
      3.498605,
      1,
      1.696510,
      5.746001,
      2.904683,
      4.077731,
      1.479873,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.834473,
      NULL,
      1,
      2.899295,
      0,
      NULL,
      NULL,
      2.017431,
      5,
      NULL,
      1,
      2,
      6.222239,
      3,
      0,
      1,
      1.397912,
      0.065919,
      1,
      3,
      NULL,
      NULL,
      3.904463,
      NULL,
      NULL,
      16,
      NULL,
      NULL,
      0.559933,
      NULL,
      NULL,
      0.124792,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.264943,
      NULL,
      NULL,
      3.267071,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      8.513653,
      NULL,
      NULL,
      1.211148,
      2.739723,
      0.233281,
      NULL,
      1.362274,
      2.730051,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.841979,
      1.088103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.964818,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.186207,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      1.050318,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3.781501,
      0,
      NULL,
      NULL,
      1.527388,
      0,
      NULL,
      NULL,
      5.811585,
      0,
      NULL,
      NULL,
      3.402702,
      NULL,
      5,
      5,
      NULL,
      NULL,
      62.422105,
      0,
      NULL,
      NULL,
      0.991535,
      NULL,
      NULL,
      NULL,
      NULL,
      0.874632,
      1.667345,
      30.064424,
      3.927264,
      1.969135,
      NULL,
      NULL,
      3.584716,
      6.545442,
      1,
      0,
      22,
      1,
      0.573443,
      1,
      1,
      1.719820,
      1.828918,
      0.899823,
      0.782020,
      0,
      NULL,
      1,
      1.027080,
      1.973917,
      1.162495,
      0,
      1,
      1.303535,
      1.815074,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      5.083244,
      0.467341,
      0.789219,
      1,
      3.631372,
      0.755489,
      4,
      0,
      0,
      3.123304,
      1.453456,
      1,
      1,
      0,
      1,
      NULL,
      0.581560,
      NULL,
      0.461384,
      0.519689,
      1,
      0,
      0.058977,
      3.122827,
      2,
      1.210244,
      1.393879,
      0,
      1.132141,
      0.060336,
      2.090187,
      NULL,
      3.913190,
      NULL,
      NULL,
      1.136817,
      0,
      NULL,
      NULL,
      3,
      1.870548,
      1.928574,
      0,
      1,
      0.955559,
      1.045878,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.947619,
      0,
      1,
      0.040133,
      1,
      7,
      NULL,
      2,
      0.582292,
      0,
      1.898517,
      14.265655,
      47.030297,
      NULL,
      NULL,
      3,
      NULL,
      '',
      '',
      0.392369,
      '',
      '',
      '',
      0,
      '1402',
      NULL,
      '');
commit;
end;
/


