set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8408911';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-5-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      '2233213',
      3,
      1,
      2,
      NULL,
      '2344',
      NULL,
      1,
      NULL,
      NULL,
      ' 8- 2-1991',
      41,
      NULL,
      5,
      NULL,
      0.542003,
      ' 5-23-1977',
      NULL,
      1.781046,
      97,
      97,
      3,
      ' 7- 9-1990',
      ' 0- 6-1987',
      ' 9- 9-1994',
      2,
      2.425774,
      0,
      0,
      0.716978,
      1.723383,
      3.107598,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.174356,
      NULL,
      183,
      1.607642,
      18,
      3.741215,
      2.175474,
      1.552321,
      1.636958,
      4,
      0.535534,
      0.868252,
      1.807051,
      0,
      NULL,
      1,
      0,
      NULL,
      0.798171,
      0.494249,
      2,
      NULL,
      2.659352,
      NULL,
      0.875903,
      1.989364,
      0.744172,
      0,
      1.964206,
      NULL,
      0.589520,
      1.480298,
      NULL,
      NULL,
      0.295003,
      NULL,
      1,
      0,
      0,
      1,
      0.989916,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.647109,
      0.804540,
      1.540365,
      2.905439,
      1,
      NULL,
      3.154279,
      0.901241,
      0,
      0,
      2.055401,
      NULL,
      1,
      3.197537,
      NULL,
      0.435165,
      3.822479,
      3,
      3.924382,
      1,
      1.512329,
      1,
      4,
      NULL,
      0.254178,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.152999,
      2,
      1.154769,
      1,
      0.448170,
      0.204872,
      0,
      1.294755,
      0,
      0,
      1,
      1.550870,
      1.554239,
      0.578950,
      1.090714,
      0.155686,
      1,
      0.647608,
      NULL,
      0,
      NULL,
      1.349736,
      1,
      1,
      0,
      0.745820,
      0,
      1,
      0.964212,
      0,
      0.026234,
      0,
      1.102590,
      0,
      0,
      0,
      NULL,
      3.313538,
      3,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.291280,
      0.539207,
      ' 9-27-2000',
      1945,
      ' 8- 9-1998',
      43,
      1,
      1,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.808193,
      0.030621,
      1.554497,
      NULL,
      1.127040,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.126090,
      NULL,
      NULL,
      NULL,
      NULL,
      1.519456,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.515221,
      1,
      0.963956,
      NULL,
      1.352264,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.893891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.035910,
      0,
      1,
      2.147027,
      1.148970,
      1.204816,
      0,
      1,
      8,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3.713482,
      NULL,
      2,
      3,
      0.634125,
      2,
      NULL,
      0.619870,
      1,
      0.117972,
      0,
      3,
      2.207185,
      NULL,
      3,
      1.612812,
      0.777003,
      1,
      0.968306,
      NULL,
      5,
      1.129540,
      1,
      0.152248,
      1.890370,
      0.898169,
      0.192075,
      0.121759,
      1.417882,
      1,
      1,
      8.830220,
      4,
      NULL,
      0.586297,
      1.230332,
      NULL,
      2.451257,
      5.966837,
      0,
      NULL,
      1.543793,
      34,
      2,
      3.407071,
      NULL,
      12.799277,
      53,
      21.152968,
      3,
      NULL,
      0.692653,
      '04030',
      '',
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.500415,
      9.773226,
      151,
      4,
      0.946270,
      42,
      NULL,
      NULL,
      3.977814,
      3,
      NULL,
      NULL,
      NULL,
      0.155257,
      1,
      1.565898,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.315427,
      0,
      3.219093,
      1,
      NULL,
      NULL,
      3.813859,
      0,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      4.897130,
      1.181834,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.853009,
      3.762760,
      NULL,
      0,
      1.000989,
      2.159800,
      0.678536,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.357034,
      1.090244,
      0,
      1.055004,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0,
      1,
      0.438145,
      0.289806,
      3,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.101462,
      0,
      3.678003,
      1.373279,
      1,
      1.853830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.500324,
      0,
      2.068962,
      0.807812,
      NULL,
      NULL,
      0.763627,
      NULL,
      NULL,
      3,
      1,
      0.015623,
      NULL,
      NULL,
      NULL,
      0.810921,
      4.923859,
      1.861278,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.959551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.345013,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.950155,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.710965,
      0,
      1,
      NULL,
      NULL,
      4,
      0.755507,
      NULL,
      0,
      3,
      0,
      0,
      NULL,
      NULL,
      3.579523,
      1,
      0,
      NULL,
      0,
      1,
      0.526533,
      3.821809,
      0.051892,
      2,
      NULL,
      5,
      3,
      1,
      0.321637,
      2,
      1.477851,
      0,
      1,
      0.916808,
      1.579386,
      2.631357,
      NULL,
      3,
      1.110162,
      0.829564,
      5.762938,
      1.318630,
      NULL,
      NULL,
      1,
      3,
      6,
      1,
      0.434015,
      NULL,
      0.550684,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.577893,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.211901,
      3,
      NULL,
      1.146438,
      NULL,
      0,
      1,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.993081,
      NULL,
      NULL,
      NULL,
      2.307693,
      1.362347,
      NULL,
      NULL,
      0.960524,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.558209,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.468797,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1.882247,
      NULL,
      NULL,
      NULL,
      1.915402,
      NULL,
      NULL,
      0.936180,
      1.786875,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1.496414,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.320976,
      NULL,
      NULL,
      1.355171,
      1.494411,
      NULL,
      NULL,
      NULL,
      0,
      290,
      86,
      3.770578,
      22.565174,
      NULL,
      0.606152,
      NULL,
      NULL,
      0.559603,
      0.325973,
      1.041358,
      0.642847,
      NULL,
      4.140196,
      1.811218,
      NULL,
      NULL,
      1,
      32.410910,
      0,
      104.107347,
      9,
      0,
      1.309718,
      0,
      NULL,
      NULL,
      1.808033,
      NULL,
      NULL,
      NULL,
      0,
      0.098330,
      0,
      0.566747,
      0.573725,
      1.515903,
      NULL,
      0.954185,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.309894,
      2,
      4.958613,
      5.100262,
      NULL,
      3,
      1.635257,
      4,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.314760,
      NULL,
      0,
      NULL,
      NULL,
      1.818662,
      1,
      NULL,
      1,
      0,
      NULL,
      0.795074,
      NULL,
      NULL,
      1.472179,
      1.723542,
      NULL,
      NULL,
      0.697381,
      NULL,
      0,
      0.597171,
      NULL,
      1,
      1,
      NULL,
      1.367932,
      NULL,
      NULL,
      0.343480,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.015753,
      8.176068,
      NULL,
      NULL,
      NULL,
      15.974679,
      6,
      2,
      NULL,
      3.896307,
      '13113',
      '',
      '',
      0.372046,
      NULL,
      '',
      '',
      0.563866,
      '',
      '',
      '');
commit;
end;
/


