set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '4310878';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-2-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.863632,
      0.256155,
      0,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      ' 5-14-1999',
      43,
      NULL,
      NULL,
      3,
      1,
      ' 7-23-1997',
      35,
      3.065908,
      NULL,
      NULL,
      3,
      ' 0- 7-1989',
      '11-15-1994',
      ' 9-19-2002',
      3.938825,
      0.223637,
      2.746275,
      0.884407,
      1,
      2,
      4.867295,
      0,
      0,
      NULL,
      4,
      7,
      5.389617,
      12,
      24.979499,
      6,
      18.211336,
      NULL,
      4,
      2.613499,
      0,
      1,
      0,
      NULL,
      0.919712,
      1,
      0,
      1,
      NULL,
      1.437078,
      28.291649,
      8.062323,
      0,
      3.403822,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      0,
      1.275654,
      1.661072,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.128556,
      0.640226,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.887405,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.008283,
      1.383886,
      0.218933,
      1.444160,
      1.475037,
      0.589739,
      0,
      0.390254,
      1,
      0.947548,
      0.536092,
      0,
      1,
      1.542647,
      0,
      1.053366,
      NULL,
      NULL,
      1,
      NULL,
      0.185145,
      3.393024,
      NULL,
      1,
      1.555790,
      1,
      4.537843,
      1.857998,
      NULL,
      3.472664,
      0,
      0,
      0,
      6.185781,
      1.022078,
      2.771180,
      3.688307,
      8,
      8,
      0.205883,
      3,
      0,
      6,
      4,
      4.865008,
      0,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.085775,
      1,
      0.746953,
      0,
      0.261583,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.783952,
      NULL,
      NULL,
      NULL,
      NULL,
      0.512557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.817613,
      NULL,
      1.982839,
      NULL,
      NULL,
      NULL,
      NULL,
      5.039478,
      1.780276,
      1,
      0.651376,
      1.163318,
      1.068215,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.821853,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      1.302913,
      1,
      0,
      NULL,
      1,
      NULL,
      0.585698,
      0.222578,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2.757776,
      0,
      1.234698,
      1.442773,
      1,
      NULL,
      1,
      1.947456,
      0.551697,
      NULL,
      3,
      3.721396,
      2.357524,
      0,
      0,
      0,
      0.705292,
      1,
      1,
      0,
      0,
      0,
      2.274849,
      NULL,
      0.686437,
      NULL,
      1,
      2,
      0,
      7.357903,
      NULL,
      7,
      NULL,
      0,
      1,
      5.274062,
      0.386911,
      5,
      3,
      1,
      NULL,
      2.680935,
      3,
      2.449672,
      NULL,
      76,
      38,
      NULL,
      5,
      3,
      0,
      '44002',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      1.877237,
      36.887237,
      NULL,
      19,
      3.008929,
      29,
      0,
      3.481341,
      10.974241,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.817836,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.477253,
      2,
      1.513983,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.500703,
      NULL,
      NULL,
      1.401097,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.058970,
      1,
      0,
      0.645449,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.926998,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.655394,
      NULL,
      NULL,
      2,
      1.690528,
      0.979189,
      0,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1.520662,
      1.341202,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.937491,
      NULL,
      NULL,
      0.015541,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.233217,
      NULL,
      NULL,
      0.422104,
      NULL,
      NULL,
      0,
      1.045722,
      0,
      1,
      NULL,
      NULL,
      7.516501,
      0,
      NULL,
      5,
      0,
      0,
      0,
      NULL,
      NULL,
      1.597818,
      NULL,
      0.704092,
      3.293032,
      3.086466,
      NULL,
      NULL,
      2,
      3.004429,
      6.251536,
      3.832936,
      2.665236,
      0,
      2,
      2,
      1,
      2.291135,
      2.377800,
      1,
      2.426115,
      1.885076,
      3.226209,
      0,
      NULL,
      NULL,
      1.699546,
      3.328452,
      8.652783,
      0,
      5.748208,
      0,
      NULL,
      6,
      1.369432,
      0.983403,
      0,
      1,
      1.470108,
      3.442823,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.019357,
      NULL,
      NULL,
      0.516900,
      NULL,
      NULL,
      1,
      1.593973,
      0,
      2.011671,
      1,
      0.729578,
      0.904206,
      5.840378,
      NULL,
      0,
      0.809189,
      119.025378,
      NULL,
      8.733638,
      154.657363,
      1.102572,
      NULL,
      1.861785,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1.772084,
      NULL,
      1,
      1.569276,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.468851,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.310440,
      NULL,
      NULL,
      NULL,
      1.919373,
      NULL,
      NULL,
      NULL,
      3.486275,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.052085,
      3,
      NULL,
      0.866608,
      2,
      3.774134,
      NULL,
      0.200950,
      NULL,
      1.379496,
      NULL,
      NULL,
      3,
      0.017333,
      NULL,
      1.170779,
      0,
      3,
      NULL,
      1.503234,
      1,
      NULL,
      NULL,
      0.353109,
      0,
      15.587172,
      NULL,
      3.646235,
      1.406158,
      NULL,
      NULL,
      0,
      1.790791,
      4,
      NULL,
      0.135977,
      22.493388,
      9,
      2,
      36,
      NULL,
      2.162828,
      117.755623,
      11,
      2.275734,
      79,
      24,
      1,
      3.048159,
      2,
      0.303766,
      NULL,
      NULL,
      0.712460,
      16,
      1,
      NULL,
      4,
      1,
      1.058466,
      NULL,
      1.749171,
      NULL,
      1.324452,
      1,
      1.089301,
      0.709599,
      1,
      1,
      1.259849,
      0,
      1.865295,
      0.878500,
      1.585273,
      0,
      1.900497,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.210846,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      0.162578,
      1.327024,
      NULL,
      NULL,
      0,
      1.561088,
      1,
      2,
      0.543387,
      0.437269,
      1.509863,
      0,
      NULL,
      0.696241,
      1.870449,
      0.846096,
      0.244188,
      1,
      0,
      0,
      1.739339,
      1.717269,
      1.129350,
      0.635058,
      NULL,
      1,
      0.973925,
      1,
      2.209179,
      1,
      1.931358,
      2.047078,
      1,
      0,
      3.997146,
      1.522368,
      0.261502,
      2.358331,
      NULL,
      0.107311,
      3,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.065664,
      1,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0.729127,
      NULL,
      0.158500,
      NULL,
      1.188502,
      NULL,
      NULL,
      NULL,
      1.435135,
      NULL,
      1.967164,
      NULL,
      2,
      NULL,
      1.873306,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.857633,
      61,
      0,
      1,
      0.695982,
      1,
      0,
      1.572160,
      3.274831,
      5,
      NULL,
      3.204152,
      1,
      3,
      71,
      93,
      5.347587,
      2.102572,
      1,
      NULL,
      '14404',
      '14304',
      NULL,
      '1412',
      '',
      NULL,
      0.422607,
      '',
      '',
      NULL);
commit;
end;
/


