set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7915686';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-3-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3.153731,
      1,
      3.581693,
      0.114673,
      2.937721,
      1.197156,
      3.184269,
      NULL,
      '032',
      NULL,
      NULL,
      48,
      '4400434',
      0.394056,
      0,
      3,
      3,
      '3440',
      NULL,
      0.922361,
      NULL,
      NULL,
      ' 8- 5-1988',
      51,
      NULL,
      NULL,
      2,
      NULL,
      ' 8-25-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      1.368816,
      NULL,
      ' 1- 8-1979',
      ' 6-23-1990',
      2.782865,
      1.727132,
      0,
      1.249561,
      1,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      7.649311,
      0,
      NULL,
      1.198431,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.691703,
      1.873198,
      1,
      3,
      11.614347,
      NULL,
      0,
      9,
      0.718119,
      0,
      8,
      NULL,
      0,
      3,
      NULL,
      2.175146,
      NULL,
      NULL,
      1,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.297327,
      1,
      1.622565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.576902,
      3,
      0,
      3.975101,
      1.662048,
      NULL,
      1.385010,
      NULL,
      1.904560,
      1.109149,
      1.888150,
      1.099204,
      1.329746,
      0.642754,
      1,
      1.145802,
      NULL,
      0,
      NULL,
      1.269096,
      0.229606,
      0.868343,
      0.092900,
      0.776149,
      NULL,
      1,
      0,
      0.377244,
      1,
      1,
      1,
      0.287675,
      0.521579,
      0.589101,
      NULL,
      0,
      0,
      11.642056,
      NULL,
      NULL,
      4,
      1,
      NULL,
      2.846951,
      0,
      5,
      3,
      ' 5- 3-1995',
      107.165493,
      '10- 6-1978',
      61,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.301264,
      1.950058,
      NULL,
      0,
      NULL,
      0.952756,
      1,
      1.571785,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      5,
      0,
      2.022830,
      7,
      0,
      0.711818,
      1.840867,
      NULL,
      NULL,
      6,
      1,
      3,
      NULL,
      1,
      NULL,
      1,
      1.029438,
      5.434642,
      4,
      0,
      NULL,
      4.359560,
      0.489458,
      1,
      4.657262,
      0.102599,
      1,
      1.386548,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.300747,
      NULL,
      1,
      1,
      1.520653,
      0,
      0.236074,
      0.855716,
      1,
      0.866955,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0.764205,
      3,
      NULL,
      0.661980,
      3,
      1.239313,
      NULL,
      1.333743,
      0.124798,
      3.811042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.561623,
      7,
      0.850363,
      1.923557,
      1.201250,
      0,
      NULL,
      0,
      1.990381,
      0.660098,
      1.582115,
      NULL,
      0,
      0,
      6,
      4.270145,
      2.119669,
      7.944845,
      8,
      6,
      NULL,
      NULL,
      NULL,
      0.647969,
      NULL,
      3,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      0,
      5.703552,
      NULL,
      '32104',
      NULL,
      NULL,
      1.851682,
      '',
      '',
      NULL,
      1,
      '4313',
      '4141',
      '',
      2.061750,
      27,
      352.162904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.071910,
      NULL,
      NULL,
      0.348687,
      NULL,
      NULL,
      2,
      3.455660,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.359542,
      NULL,
      0,
      NULL,
      NULL,
      3.163205,
      3.368329,
      1.462495,
      0,
      3.925830,
      NULL,
      1,
      3,
      NULL,
      NULL,
      2,
      1,
      1.381431,
      3.171795,
      NULL,
      5.501860,
      1.560953,
      NULL,
      NULL,
      NULL,
      NULL,
      1.522405,
      NULL,
      NULL,
      NULL,
      0.796305,
      NULL,
      NULL,
      0.989577,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.640535,
      NULL,
      NULL,
      1.237249,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.157644,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.543378,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.058846,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.233608,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.413321,
      NULL,
      NULL,
      0.938562,
      NULL,
      NULL,
      0.292827,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.341663,
      NULL,
      NULL,
      3.443909,
      NULL,
      1.839034,
      0,
      1.605249,
      0,
      3.306126,
      1,
      1.968626,
      3.445286,
      1.425329,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      0,
      0.068317,
      1.980057,
      1,
      NULL,
      NULL,
      1.152156,
      7.963579,
      1,
      1.903509,
      0.774485,
      NULL,
      NULL,
      NULL,
      3.116181,
      5,
      1,
      1,
      2,
      0,
      0,
      3,
      NULL,
      NULL,
      0.072684,
      NULL,
      NULL,
      7.915694,
      NULL,
      NULL,
      1.374571,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.571965,
      NULL,
      NULL,
      1.989909,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.835640,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.795654,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2.538702,
      NULL,
      3,
      NULL,
      NULL,
      0.967249,
      3.214860,
      NULL,
      4.401570,
      NULL,
      0.131498,
      NULL,
      NULL,
      NULL,
      402,
      NULL,
      2,
      NULL,
      2.502821,
      NULL,
      NULL,
      NULL,
      1.234215,
      NULL,
      3,
      1.956160,
      3,
      NULL,
      0.071740,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3,
      NULL,
      2.366234,
      0.882524,
      3.401696,
      NULL,
      3,
      NULL,
      0.767163,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1.687924,
      NULL,
      0.829565,
      NULL,
      1.399449,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2.785320,
      NULL,
      NULL,
      NULL,
      3,
      1.728954,
      0.556732,
      NULL,
      0,
      0.979806,
      1,
      NULL,
      1,
      0,
      1.637171,
      NULL,
      0,
      0.890130,
      1.813536,
      NULL,
      9.286950,
      1.538486,
      0.110931,
      NULL,
      1,
      0.042784,
      NULL,
      NULL,
      NULL,
      0.984942,
      1.729512,
      0,
      2.268283,
      NULL,
      1,
      1.017970,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.351681,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      200,
      7.745584,
      0,
      0,
      1.886826,
      NULL,
      1.646497,
      0.113123,
      NULL,
      0.589774,
      1.866982,
      0.147825,
      0,
      1.168926,
      1.831897,
      NULL,
      1,
      NULL,
      1.918790,
      3,
      0,
      1.451276,
      0,
      0,
      0.585514,
      NULL,
      1.622425,
      NULL,
      0.739119,
      0.103543,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.701318,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.836786,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.218054,
      0.164101,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.677612,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.848664,
      NULL,
      2.153817,
      NULL,
      1.355680,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.086006,
      NULL,
      1,
      1.090700,
      1.602823,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.802345,
      1.959852,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.722435,
      0,
      1.470583,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      1.472845,
      0.273441,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.419340,
      1,
      0,
      NULL,
      0,
      1.885493,
      1,
      1.082880,
      0,
      0,
      1,
      0,
      0,
      NULL,
      1.304756,
      1.335666,
      1.188574,
      0,
      NULL,
      0.048612,
      1.805973,
      NULL,
      0.197389,
      1,
      0,
      1,
      0.779556,
      0,
      NULL,
      NULL,
      0,
      3.398960,
      NULL,
      0,
      0,
      1,
      1,
      1.810456,
      NULL,
      1,
      0,
      NULL,
      1.357521,
      NULL,
      1.076117,
      1,
      2.295318,
      0.304481,
      0.813356,
      0.387012,
      1,
      NULL,
      3.142011,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      1.362531,
      1,
      1.163781,
      1,
      0,
      1,
      0.014647,
      0,
      1.999805,
      0.832894,
      1,
      0.567100,
      3,
      1,
      1.344436,
      1.353541,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.242698,
      1,
      1,
      1.902670,
      0,
      3,
      4,
      NULL,
      NULL,
      NULL,
      55.257433,
      NULL,
      NULL,
      1.033811,
      2.735736,
      '44411',
      '',
      '',
      NULL,
      NULL,
      NULL,
      '',
      3,
      '3440',
      NULL,
      '');
commit;
end;
/


