set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9885315';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-7-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      NULL,
      2.938756,
      2.185199,
      0.527944,
      1.816870,
      0,
      0.261141,
      '033',
      '41114231',
      9.862090,
      NULL,
      NULL,
      0.335607,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-26-2001',
      NULL,
      NULL,
      NULL,
      3.063158,
      3.676505,
      ' 2-18-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 9-2003',
      NULL,
      NULL,
      0.760045,
      1,
      3.167069,
      0.343159,
      0.991281,
      3.466495,
      3,
      1,
      1,
      18,
      4,
      14.414219,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3.074529,
      NULL,
      NULL,
      1.693277,
      0,
      1,
      NULL,
      0.003065,
      1,
      1.393787,
      NULL,
      NULL,
      1.219238,
      2,
      3,
      5,
      3.569417,
      2.819208,
      0,
      7,
      1.031347,
      1,
      5,
      NULL,
      NULL,
      3,
      0,
      0.283716,
      0.267726,
      NULL,
      0,
      NULL,
      0.088989,
      0.413054,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.647369,
      1.179866,
      1.827997,
      1,
      0,
      1,
      0,
      NULL,
      3,
      3.635136,
      0.008939,
      1,
      2,
      NULL,
      3.700062,
      1.794109,
      0,
      1,
      2,
      0,
      4,
      4,
      NULL,
      2,
      0.287890,
      0.194485,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.243611,
      NULL,
      4,
      4,
      6,
      0,
      2,
      1,
      0.741934,
      1.867639,
      1,
      3.906444,
      1,
      0,
      0.830964,
      1,
      NULL,
      0.003372,
      2,
      NULL,
      4,
      7,
      1.187717,
      1,
      0.737426,
      9,
      9,
      4,
      8.703061,
      3.480130,
      4,
      1,
      NULL,
      0,
      1,
      0.911069,
      9.842568,
      NULL,
      0,
      2.859903,
      NULL,
      0,
      6.887984,
      7.273604,
      NULL,
      NULL,
      5,
      0.515596,
      ' 8-21-1998',
      NULL,
      '10-12-1983',
      NULL,
      1.104678,
      0,
      0.502282,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.891340,
      NULL,
      0,
      0,
      0,
      7.915510,
      7.707230,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.635536,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.176663,
      0,
      2.622114,
      0,
      2,
      1.384476,
      NULL,
      0.080589,
      NULL,
      2.573391,
      1,
      0,
      3.145457,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0.019382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.098328,
      NULL,
      NULL,
      0.185479,
      1.252920,
      0,
      NULL,
      NULL,
      0.411887,
      0.512507,
      NULL,
      NULL,
      NULL,
      0.801060,
      1,
      1.852972,
      0,
      2,
      1.656398,
      NULL,
      0.041488,
      2,
      1,
      NULL,
      1,
      0,
      3.407679,
      NULL,
      1.093337,
      0,
      0,
      1,
      1,
      0.373556,
      1.238491,
      0,
      0,
      1.501502,
      1.644316,
      0,
      0,
      NULL,
      0.679042,
      NULL,
      0.005216,
      NULL,
      5,
      NULL,
      2.160590,
      0,
      3,
      5,
      3.630184,
      0.343797,
      NULL,
      1.310036,
      1,
      5.057907,
      1.971909,
      3.709227,
      3,
      NULL,
      4,
      53.054919,
      NULL,
      NULL,
      3,
      '13403',
      '',
      '',
      1.226877,
      '',
      '',
      '',
      1.472558,
      '',
      '',
      '',
      2.355158,
      23,
      NULL,
      30.526153,
      0.830816,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.459306,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.284806,
      NULL,
      NULL,
      1.930442,
      NULL,
      NULL,
      1.021441,
      NULL,
      NULL,
      0.732441,
      NULL,
      NULL,
      0.198382,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.729966,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.671425,
      NULL,
      NULL,
      0.206524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.291067,
      NULL,
      NULL,
      1.883871,
      NULL,
      NULL,
      1.298846,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.013036,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.543796,
      NULL,
      NULL,
      0.389008,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.984970,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.587040,
      0,
      NULL,
      NULL,
      0.407898,
      NULL,
      NULL,
      1.397512,
      2,
      2,
      3,
      3.256908,
      NULL,
      5,
      5.048314,
      3.401014,
      NULL,
      0,
      3.631403,
      0.031198,
      NULL,
      NULL,
      NULL,
      0.237766,
      2.390398,
      2,
      2.484228,
      0,
      3.186738,
      0,
      2.389769,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.117400,
      0,
      NULL,
      NULL,
      1.087645,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.531953,
      1,
      0.509044,
      0.482782,
      NULL,
      0.035397,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.364869,
      NULL,
      NULL,
      NULL,
      0.539217,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.618075,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.972393,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.513892,
      NULL,
      NULL,
      NULL,
      1.966549,
      NULL,
      NULL,
      NULL,
      3.388560,
      NULL,
      NULL,
      NULL,
      0.378997,
      NULL,
      NULL,
      NULL,
      0.431829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2.360357,
      3.181526,
      3,
      1.639537,
      1.956364,
      NULL,
      NULL,
      0,
      1.441956,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      255,
      NULL,
      1.390591,
      1,
      NULL,
      0,
      NULL,
      1.089099,
      1.731710,
      1,
      0.979789,
      1.750946,
      1.223559,
      NULL,
      0.854919,
      0.673475,
      0.359897,
      0.448364,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.724728,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.012610,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.551950,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.888490,
      1.690628,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.890688,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.670196,
      NULL,
      1.218907,
      NULL,
      0,
      1,
      0.226962,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.924734,
      1.341171,
      4,
      1.045847,
      1.751893,
      0,
      3,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0.170338,
      NULL,
      0.142154,
      0,
      NULL,
      1,
      0.618528,
      NULL,
      1.423881,
      1,
      NULL,
      3.518710,
      0.319322,
      NULL,
      NULL,
      0.591944,
      NULL,
      NULL,
      1.983732,
      NULL,
      NULL,
      NULL,
      NULL,
      1.544297,
      1,
      NULL,
      2.977795,
      3.784213,
      NULL,
      NULL,
      NULL,
      NULL,
      1.699105,
      0,
      0.102347,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.242046,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.497421,
      NULL,
      1.115984,
      NULL,
      NULL,
      NULL,
      1.542174,
      4,
      6,
      0.020716,
      NULL,
      NULL,
      87,
      120.328925,
      3.318873,
      1.393378,
      NULL,
      '42330',
      '',
      NULL,
      1,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '');
commit;
end;
/


