set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9311269';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-6-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      '1421343',
      1,
      0,
      2,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      12,
      NULL,
      2,
      2.032264,
      1,
      ' 0-23-1998',
      33,
      5,
      208,
      7,
      3.359340,
      ' 1-26-1981',
      ' 8-16-1977',
      NULL,
      3.013748,
      0,
      0.201720,
      1.565537,
      NULL,
      1.863340,
      0.318046,
      1.933166,
      1.067181,
      NULL,
      9,
      10.361784,
      2.401278,
      6,
      9,
      3,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.738406,
      0.380264,
      0.571340,
      1.969081,
      NULL,
      1,
      NULL,
      0.495657,
      NULL,
      NULL,
      5.733438,
      3.276461,
      1,
      7,
      NULL,
      5.274802,
      7.524744,
      2.830326,
      0.272661,
      11,
      NULL,
      NULL,
      0.024951,
      NULL,
      0,
      NULL,
      5,
      2.224366,
      NULL,
      1,
      1.313382,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7,
      1,
      6.948858,
      0,
      0.484881,
      0,
      2.734002,
      3,
      0,
      1,
      0,
      0,
      0,
      NULL,
      0.958339,
      NULL,
      0.590124,
      0,
      0.262477,
      0.818923,
      0,
      1.530696,
      9,
      0.385497,
      0,
      1.981790,
      1.759896,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.025605,
      7.086014,
      0,
      NULL,
      9,
      1,
      0.618644,
      1.952688,
      0,
      1.148951,
      1.965318,
      1.561445,
      1,
      1.547644,
      1,
      0,
      NULL,
      0,
      0.650180,
      NULL,
      1.382153,
      0,
      2,
      NULL,
      4.623828,
      2,
      NULL,
      2.138063,
      5,
      2.386315,
      3,
      0.992285,
      NULL,
      2.623422,
      1.392804,
      NULL,
      4,
      3.314179,
      6.929018,
      3,
      NULL,
      4,
      NULL,
      6,
      0,
      1,
      0.436000,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.510196,
      1,
      2.606102,
      0.300226,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.824970,
      1.622467,
      2.797192,
      5.425753,
      1,
      NULL,
      9,
      4.697994,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.922433,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.551703,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.958887,
      NULL,
      5.738890,
      2.591960,
      1,
      3.923106,
      2.613974,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0.781551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.836842,
      NULL,
      1.695289,
      1,
      NULL,
      NULL,
      32.431265,
      3.239620,
      1.785031,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.619434,
      2.984934,
      0.536306,
      2,
      NULL,
      NULL,
      5.942529,
      5.932068,
      0.911127,
      NULL,
      1.838791,
      2,
      2.238072,
      NULL,
      1.179882,
      1.255369,
      0,
      0.921228,
      NULL,
      0,
      NULL,
      0.926132,
      0,
      0.889020,
      0,
      0,
      0,
      0.112624,
      2,
      1,
      11,
      NULL,
      NULL,
      1,
      4.021100,
      3.631317,
      NULL,
      NULL,
      6.229891,
      3,
      NULL,
      0,
      49.140799,
      0.832940,
      2.215734,
      NULL,
      49,
      16.525070,
      118,
      4.118176,
      1,
      1.242394,
      '23113',
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      1,
      '',
      NULL,
      '',
      0,
      42.895464,
      2,
      13.149901,
      3.355511,
      27,
      0,
      0.233214,
      NULL,
      NULL,
      3.559092,
      NULL,
      0,
      NULL,
      NULL,
      1.153764,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      1.490884,
      0.361443,
      0,
      NULL,
      NULL,
      0.254009,
      3.944330,
      1.187577,
      0,
      NULL,
      NULL,
      1.637343,
      NULL,
      NULL,
      0.329985,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      9,
      3.641088,
      1.932331,
      2.694738,
      1.633618,
      NULL,
      NULL,
      NULL,
      0.112397,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.314395,
      1.531287,
      NULL,
      NULL,
      1.218583,
      NULL,
      NULL,
      NULL,
      NULL,
      1.663903,
      1,
      2.660031,
      2,
      1.000243,
      1,
      1.475946,
      NULL,
      0.692148,
      1.275301,
      3,
      NULL,
      3,
      2,
      0,
      NULL,
      NULL,
      1.940346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.838603,
      0,
      0.592746,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      8.706473,
      1,
      NULL,
      3,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.335349,
      NULL,
      NULL,
      1.127572,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.642116,
      NULL,
      NULL,
      4.276951,
      3,
      1.323540,
      0.294021,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      3.184695,
      1,
      0.334394,
      NULL,
      2.397934,
      1,
      3.731396,
      3,
      1,
      0.787907,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.939289,
      3,
      0,
      5.666493,
      7,
      NULL,
      4,
      6.182430,
      1.053498,
      1.159676,
      2.388484,
      2,
      0.784378,
      1,
      0,
      1,
      NULL,
      0.528730,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.006952,
      0,
      0.633652,
      1.434318,
      0.857849,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.833151,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.277955,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.953386,
      NULL,
      NULL,
      692,
      0,
      NULL,
      NULL,
      0.825337,
      0.983458,
      0,
      1,
      1,
      NULL,
      0,
      1.241564,
      1.974792,
      0,
      NULL,
      1,
      1,
      0.331228,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.933152,
      1,
      5,
      NULL,
      0.434839,
      NULL,
      NULL,
      7,
      0,
      3.700936,
      NULL,
      1.725098,
      1.721686,
      NULL,
      0,
      1.375149,
      NULL,
      0.999861,
      0.817008,
      1.808972,
      NULL,
      0,
      1.094125,
      NULL,
      1.014883,
      1,
      0.176812,
      1,
      1.493703,
      3.134852,
      3,
      0.504540,
      2,
      2.771847,
      2.241823,
      NULL,
      1.344203,
      0.621225,
      1.474642,
      1.701340,
      2.121944,
      0,
      1,
      0.107752,
      0.564489,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.943136,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3.611785,
      0,
      2,
      0.850517,
      NULL,
      NULL,
      106.112338,
      9.102582,
      1,
      0,
      3,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


