set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9410455';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-1-31 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      '3400420',
      1,
      1.911991,
      1,
      0,
      '1141',
      3,
      0.198763,
      NULL,
      NULL,
      ' 5- 9-1974',
      54.478108,
      NULL,
      NULL,
      1.540042,
      1.967150,
      ' 4-17-1974',
      NULL,
      5,
      249,
      133.339111,
      0.876344,
      NULL,
      ' 9-23-2000',
      '11-27-1982',
      0,
      1.524463,
      3.881926,
      0.550356,
      1.018559,
      1,
      NULL,
      1,
      1.319790,
      136.741851,
      5,
      8,
      1.903255,
      11.012958,
      18,
      6.037942,
      11.485518,
      4,
      0,
      4.438244,
      1.821166,
      1.380225,
      1.129265,
      1,
      1.143294,
      3,
      1,
      1,
      1,
      1.392571,
      0.888763,
      2.043996,
      NULL,
      1,
      0.168433,
      4.562454,
      1,
      1,
      0,
      1,
      1.999876,
      8.046767,
      1,
      1.469210,
      0.932716,
      6,
      1.770492,
      2,
      1.206829,
      2.419945,
      NULL,
      1.077764,
      NULL,
      NULL,
      NULL,
      1.910450,
      3,
      NULL,
      9.938628,
      7,
      0,
      3,
      1.953736,
      0,
      1.200919,
      1,
      1,
      NULL,
      3.509515,
      0,
      3,
      1,
      0,
      NULL,
      3.359591,
      2.691773,
      2,
      NULL,
      0,
      2.634006,
      1.892401,
      1.059303,
      1,
      2.127249,
      0.922493,
      NULL,
      NULL,
      2.232731,
      3.104240,
      1,
      1,
      0.850437,
      0,
      NULL,
      1,
      1.856234,
      0,
      NULL,
      NULL,
      0,
      1,
      1.614780,
      1,
      NULL,
      0.330898,
      NULL,
      1.716662,
      1,
      1,
      NULL,
      NULL,
      6.578456,
      NULL,
      1.134597,
      NULL,
      0,
      1.850181,
      0.371151,
      NULL,
      1.853641,
      2.733125,
      9.252265,
      3.722282,
      3.927000,
      0,
      1.604653,
      3.115440,
      1,
      9.909317,
      3.062381,
      NULL,
      3,
      0.862898,
      4.521082,
      2,
      3,
      6.512112,
      3,
      ' 5-21-1984',
      55,
      ' 9-27-1984',
      11,
      NULL,
      0.456118,
      0,
      5.205981,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.937518,
      1.351527,
      1.686302,
      1.226165,
      3,
      1.107037,
      3.840599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.034167,
      NULL,
      1,
      3.551159,
      3.740829,
      0.152286,
      NULL,
      0.986178,
      7,
      NULL,
      NULL,
      1,
      2.759784,
      3.962854,
      3.359266,
      NULL,
      3.984262,
      3,
      5,
      8,
      6.586084,
      2,
      NULL,
      NULL,
      NULL,
      0,
      14,
      0,
      0.612124,
      0.346634,
      NULL,
      2.681423,
      ' 9-23-1984',
      NULL,
      ' 7- 2-1985',
      3.012961,
      3.645150,
      0.574146,
      0,
      NULL,
      1.537556,
      0,
      1,
      0.100449,
      1,
      1,
      NULL,
      20,
      3.581262,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      3,
      2,
      NULL,
      2,
      2,
      1,
      1,
      NULL,
      3,
      2.979634,
      NULL,
      1,
      1.662435,
      4,
      NULL,
      0,
      1.627263,
      1,
      1.524968,
      0,
      1.009484,
      0,
      1,
      1,
      1,
      0.877227,
      1,
      NULL,
      1,
      8,
      1.990544,
      5.572001,
      7,
      8.113590,
      5.242453,
      3.440790,
      0.577753,
      NULL,
      2.286230,
      3,
      1,
      37.620753,
      2.537619,
      3,
      NULL,
      59.234782,
      NULL,
      52,
      3.151555,
      1,
      3.668543,
      '0443',
      '42204',
      NULL,
      0,
      '',
      NULL,
      '',
      0,
      '',
      '',
      '',
      1,
      12,
      42.490939,
      24.870820,
      2.728447,
      58.438004,
      2,
      11.555169,
      NULL,
      2.428095,
      NULL,
      0,
      1.904688,
      NULL,
      NULL,
      0,
      1.851132,
      3.428740,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.768657,
      NULL,
      0,
      NULL,
      0,
      2,
      1.303101,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.728661,
      NULL,
      NULL,
      3.845219,
      1.538974,
      1,
      0.814750,
      NULL,
      NULL,
      6.421549,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.085057,
      NULL,
      NULL,
      NULL,
      1.773726,
      3.255397,
      2,
      3.540650,
      NULL,
      2,
      1.352941,
      NULL,
      NULL,
      2.985629,
      0.665251,
      0,
      2.601679,
      NULL,
      NULL,
      0,
      2.228513,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3.509773,
      1.642464,
      1.337506,
      0,
      3.678793,
      1.033845,
      NULL,
      NULL,
      0,
      2,
      0,
      3.878232,
      0.754486,
      1,
      1.826021,
      1.509624,
      NULL,
      NULL,
      NULL,
      3,
      0.527895,
      0,
      0,
      1.361056,
      NULL,
      NULL,
      1.187319,
      NULL,
      NULL,
      0.956949,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.872451,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.601774,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.969836,
      NULL,
      NULL,
      0.313950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.953727,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.104061,
      NULL,
      NULL,
      1.069998,
      0.771761,
      2.525685,
      3,
      2,
      0,
      0,
      2,
      4,
      0.705878,
      NULL,
      1.983148,
      3,
      3,
      0,
      0,
      NULL,
      NULL,
      2,
      1.767730,
      1.046622,
      5.641880,
      1,
      5.157879,
      1.603860,
      0,
      1,
      NULL,
      4,
      7,
      1.475921,
      0.044999,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.578922,
      2,
      3.344849,
      0.874407,
      1,
      0.048317,
      2,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      0.173408,
      NULL,
      NULL,
      1.264164,
      0,
      NULL,
      NULL,
      3.709423,
      1.242559,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.557460,
      NULL,
      NULL,
      3,
      1.203839,
      NULL,
      NULL,
      1.189359,
      0.549197,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.426020,
      0.870262,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.596600,
      3,
      NULL,
      NULL,
      NULL,
      3.509150,
      NULL,
      NULL,
      1.641558,
      NULL,
      NULL,
      NULL,
      3.484026,
      1,
      NULL,
      NULL,
      3.120742,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      1.886789,
      NULL,
      NULL,
      NULL,
      0.263627,
      34.377928,
      448.687781,
      1.506021,
      11,
      391,
      NULL,
      6,
      265.989405,
      1.079507,
      NULL,
      484.427324,
      NULL,
      13.272698,
      281.706183,
      0,
      17.298702,
      NULL,
      2.061588,
      NULL,
      NULL,
      24,
      36,
      1,
      1.540514,
      0,
      0,
      1,
      1.158249,
      1.635377,
      1,
      0.304071,
      0.900521,
      1.877957,
      1.096064,
      NULL,
      NULL,
      0.044367,
      1.669499,
      1.732519,
      1.485379,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.194514,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.672582,
      1.633525,
      2.312328,
      6,
      2,
      1,
      3.254992,
      NULL,
      1,
      1.530704,
      1,
      0,
      1.303478,
      0.449711,
      0.558520,
      1.819566,
      1,
      3.782548,
      1.057354,
      0.000225,
      2,
      NULL,
      2.332664,
      2.987454,
      3,
      2,
      0.424884,
      1,
      1.283714,
      NULL,
      1.466475,
      NULL,
      0.287981,
      NULL,
      2.636686,
      3,
      NULL,
      NULL,
      1.264851,
      2.045751,
      3.477811,
      2.552994,
      1,
      1.831480,
      1.987541,
      3.283912,
      NULL,
      0.576733,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.763398,
      1,
      2.915445,
      1.844526,
      1.745035,
      NULL,
      NULL,
      1.361664,
      1.858437,
      1.526608,
      NULL,
      1,
      NULL,
      0,
      1.135853,
      0,
      2,
      1.708564,
      NULL,
      1,
      0.517984,
      1,
      NULL,
      0,
      3.301250,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.168590,
      1.157679,
      1.454332,
      NULL,
      0,
      1.313052,
      4,
      9.058363,
      1,
      0.201124,
      NULL,
      NULL,
      3.825771,
      33.577901,
      0.884816,
      0,
      4.317298,
      '0222',
      '40033',
      '',
      NULL,
      '',
      NULL,
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


