set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7232191';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-2-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '0',
      NULL,
      NULL,
      NULL,
      2,
      0.688576,
      2,
      1,
      '3241',
      2.210968,
      0,
      NULL,
      NULL,
      '11-16-1977',
      54.682677,
      NULL,
      0,
      0.119564,
      NULL,
      '10- 2-1981',
      41,
      3,
      NULL,
      NULL,
      1.236457,
      ' 7-29-1982',
      ' 3-25-1988',
      '11-11-1985',
      2,
      NULL,
      2.236807,
      3.258421,
      1,
      1.595878,
      2,
      NULL,
      NULL,
      7.330910,
      9.608397,
      NULL,
      NULL,
      13,
      17.506172,
      0.046643,
      7.735313,
      NULL,
      NULL,
      6,
      3.587537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.857490,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      1.453247,
      1.012629,
      0.401805,
      1.023995,
      2,
      1.506121,
      1.348538,
      NULL,
      0.103543,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      0.155682,
      NULL,
      NULL,
      2,
      3.598531,
      1,
      0,
      0,
      1.387598,
      0.285404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      1.075211,
      2,
      1.340497,
      NULL,
      1.990056,
      1.453977,
      NULL,
      NULL,
      3,
      0.983820,
      1.192534,
      1,
      0.399581,
      1,
      NULL,
      NULL,
      0.729901,
      7.869769,
      0.049398,
      1.479867,
      2,
      4.762866,
      NULL,
      0,
      5.646857,
      1,
      NULL,
      0.434037,
      NULL,
      0.870578,
      NULL,
      1.172338,
      0.767475,
      7,
      0,
      0.870624,
      5.428607,
      3,
      2.560649,
      1.234584,
      1,
      2.225773,
      NULL,
      2.777545,
      3.183462,
      0.039294,
      3.512058,
      1,
      5,
      1,
      6.485052,
      2.070927,
      8,
      2.560192,
      NULL,
      1.720619,
      0,
      0.577157,
      1,
      '11-10-1993',
      235.687533,
      ' 1-21-1987',
      49.991936,
      2.049429,
      3,
      1.238749,
      1.226415,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.071956,
      1,
      NULL,
      1.538902,
      1.150672,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.954106,
      NULL,
      352.292036,
      1.653328,
      1.708762,
      NULL,
      1,
      NULL,
      1,
      1.178344,
      NULL,
      2.997799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.012317,
      NULL,
      1,
      7.737711,
      1.662209,
      0.650206,
      0.603936,
      NULL,
      NULL,
      NULL,
      3,
      5.516978,
      NULL,
      0,
      3,
      2,
      3.393252,
      ' 7-19-1997',
      505.561427,
      ' 0-23-1990',
      68,
      2,
      3.124385,
      0.586743,
      1,
      NULL,
      1.199719,
      1.783559,
      1.382867,
      NULL,
      0.950715,
      NULL,
      50,
      1,
      0.694294,
      NULL,
      NULL,
      NULL,
      0.673857,
      NULL,
      NULL,
      1.617736,
      0.370720,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      2.395341,
      1.889796,
      3.142127,
      NULL,
      1,
      0.776964,
      1,
      NULL,
      4.474292,
      0,
      1,
      0.969633,
      0,
      1,
      0,
      NULL,
      1.206781,
      0,
      0.610905,
      2,
      1,
      NULL,
      11,
      NULL,
      NULL,
      9.804588,
      5.575297,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      4.996514,
      1.628093,
      2.122478,
      NULL,
      62.955635,
      68.007574,
      NULL,
      5.325299,
      0,
      2,
      '04440',
      '32122',
      '',
      3,
      '22311',
      '',
      '',
      1,
      '',
      '',
      '',
      2,
      50.670813,
      55,
      17.968372,
      2,
      NULL,
      2.607946,
      NULL,
      5,
      NULL,
      3.724521,
      0.372200,
      0,
      NULL,
      NULL,
      2,
      2.584010,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.535653,
      0,
      1.933505,
      3.346722,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.239373,
      NULL,
      NULL,
      0.145620,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      3.615521,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2.037175,
      NULL,
      1.773538,
      NULL,
      3.366612,
      NULL,
      0.582955,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.080438,
      0,
      0,
      3,
      3,
      NULL,
      3,
      NULL,
      1,
      1.568424,
      0,
      0.264663,
      1,
      2.586181,
      1.549931,
      2.444313,
      2,
      1,
      0,
      1.029640,
      NULL,
      NULL,
      3,
      0.623268,
      NULL,
      7.768652,
      2.274695,
      0.545033,
      1,
      0.656901,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.425358,
      0,
      0.891682,
      NULL,
      NULL,
      NULL,
      2.231278,
      1,
      0,
      2,
      NULL,
      1.925703,
      NULL,
      NULL,
      2,
      2,
      2.080231,
      1.242227,
      NULL,
      NULL,
      0.755884,
      2,
      3,
      3,
      2.589895,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.299714,
      NULL,
      NULL,
      1.632532,
      NULL,
      NULL,
      0.574299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.762224,
      1.596201,
      0.757470,
      0,
      0,
      4,
      1.529957,
      2.397217,
      1,
      NULL,
      NULL,
      1,
      0.569384,
      1,
      1,
      3,
      1,
      0,
      1,
      1,
      7,
      3.790127,
      4,
      3.705646,
      NULL,
      2.788155,
      3.281168,
      3.547027,
      2,
      NULL,
      0.270002,
      2.998315,
      NULL,
      0.908214,
      2,
      5,
      4.639389,
      6.986760,
      NULL,
      2.936003,
      NULL,
      3,
      NULL,
      5.964695,
      NULL,
      0.891997,
      NULL,
      0.100629,
      1,
      3.478816,
      NULL,
      NULL,
      2.224336,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.133578,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.503507,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.851946,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.420584,
      0.682513,
      0,
      NULL,
      NULL,
      NULL,
      0.606012,
      NULL,
      5.249837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.610127,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.648190,
      NULL,
      NULL,
      NULL,
      1.210566,
      NULL,
      NULL,
      NULL,
      0.364152,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.191484,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.742710,
      0.725655,
      1,
      4.045411,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.191999,
      NULL,
      NULL,
      3.857058,
      2.534191,
      1,
      0.390616,
      NULL,
      NULL,
      0.012637,
      NULL,
      NULL,
      NULL,
      NULL,
      0.742201,
      0.652074,
      1.590565,
      1.790762,
      0.119260,
      NULL,
      1,
      0.149652,
      NULL,
      0.575461,
      NULL,
      1.914806,
      1.597807,
      NULL,
      NULL,
      NULL,
      1.141622,
      2.978095,
      NULL,
      NULL,
      NULL,
      3.052151,
      NULL,
      1.617613,
      NULL,
      1.289598,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.857100,
      37.937623,
      58,
      1.286664,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.653139,
      NULL,
      1,
      NULL,
      1.824618,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.730077,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.231489,
      0.729861,
      1.955752,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.628829,
      0.151107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.750673,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.291051,
      1.929502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1.690522,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.526115,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.608549,
      NULL,
      NULL,
      2,
      3.227723,
      2,
      4.887570,
      NULL,
      NULL,
      3,
      0.207189,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.010860,
      NULL,
      NULL,
      NULL,
      1.306801,
      NULL,
      2,
      0.427703,
      NULL,
      2,
      1.259983,
      NULL,
      NULL,
      0.371841,
      NULL,
      0,
      0.930544,
      NULL,
      1,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.305622,
      NULL,
      1,
      0.749027,
      1.064572,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.315988,
      NULL,
      0.585543,
      NULL,
      2,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1.701238,
      NULL,
      0,
      NULL,
      0.375749,
      NULL,
      NULL,
      NULL,
      0.236508,
      NULL,
      1,
      NULL,
      3.483828,
      1,
      NULL,
      0.252431,
      NULL,
      0.215961,
      NULL,
      0.492361,
      NULL,
      2,
      NULL,
      2.231778,
      2,
      0.994306,
      0.992720,
      55.902070,
      NULL,
      1,
      NULL,
      3.399024,
      '42422',
      '43441',
      '',
      0,
      '10043',
      '',
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


