set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7232191';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-2-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '03',
      '13',
      21,
      12,
      '0102431',
      1,
      0.350426,
      NULL,
      2,
      '4242',
      4,
      NULL,
      NULL,
      NULL,
      ' 2-21-1992',
      34,
      34.632094,
      NULL,
      0,
      1.506058,
      '10-16-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '11-17-1987',
      ' 5-12-1989',
      ' 5-19-2002',
      0.916929,
      NULL,
      2,
      1.349129,
      NULL,
      1.899665,
      2,
      1.958167,
      1,
      121,
      2,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.518223,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      1,
      3,
      3,
      0.063087,
      1.473051,
      6.190307,
      0,
      1.684710,
      4,
      1,
      1.911886,
      1.502153,
      1.554645,
      1,
      NULL,
      0,
      2.388059,
      0,
      3.529577,
      0,
      NULL,
      NULL,
      0.378388,
      NULL,
      NULL,
      NULL,
      0.595843,
      1.379755,
      NULL,
      1,
      1,
      2.277462,
      NULL,
      NULL,
      1.543109,
      0.850985,
      1.861185,
      NULL,
      0.729897,
      0.456135,
      1,
      0,
      1,
      3.331027,
      1,
      0.462761,
      1.125100,
      NULL,
      1,
      4.483573,
      0.905863,
      0,
      NULL,
      NULL,
      0.370159,
      NULL,
      NULL,
      1.534846,
      6,
      1,
      1.114817,
      3.696491,
      3,
      1,
      NULL,
      NULL,
      NULL,
      4,
      0.156928,
      NULL,
      1,
      NULL,
      1,
      0.871730,
      1.656061,
      0.692371,
      NULL,
      NULL,
      1,
      1,
      1,
      1.714991,
      1.394261,
      NULL,
      1.020098,
      1.790336,
      1.120011,
      0,
      1,
      1,
      0,
      0,
      NULL,
      4.526825,
      NULL,
      6.126937,
      7,
      7,
      1.563552,
      3.416596,
      0,
      0,
      1,
      NULL,
      3.147850,
      ' 1- 2-1994',
      69.230299,
      NULL,
      987,
      0.146547,
      0.551941,
      0.396240,
      7,
      1.315084,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.769698,
      1,
      NULL,
      0.933236,
      0.905142,
      1.361784,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      728.224944,
      1,
      1.938292,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.118019,
      1.183164,
      NULL,
      2,
      2,
      2,
      NULL,
      1.954732,
      1.458938,
      NULL,
      0,
      NULL,
      1.332406,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.148817,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.761311,
      1,
      NULL,
      0,
      NULL,
      0.236726,
      0,
      NULL,
      68,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.608462,
      1.187727,
      NULL,
      1,
      3,
      3,
      3.585235,
      3,
      3.798638,
      NULL,
      1.649723,
      3,
      0,
      1,
      0.922816,
      NULL,
      1,
      0,
      0,
      4,
      NULL,
      0.509408,
      1,
      0.980634,
      NULL,
      0,
      1,
      1.577402,
      0,
      0,
      2.574302,
      1.492112,
      0,
      11,
      NULL,
      10,
      1.396023,
      2.565692,
      NULL,
      1.118554,
      2.950040,
      0.154121,
      NULL,
      3,
      1,
      NULL,
      3,
      NULL,
      NULL,
      15,
      48,
      1,
      NULL,
      3.898008,
      '42230',
      '',
      NULL,
      1,
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      0.858681,
      47,
      77,
      3,
      1,
      13,
      2.789049,
      6,
      1.277719,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      3.225875,
      1.019985,
      1.914428,
      2.613295,
      NULL,
      0.530816,
      0.005116,
      NULL,
      NULL,
      2.841847,
      0,
      NULL,
      2.717200,
      3.833562,
      2,
      1.165906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.224047,
      NULL,
      NULL,
      1.288647,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6.945354,
      1.245875,
      4,
      0,
      0.750080,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.722703,
      2.325277,
      NULL,
      1.087695,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.329098,
      1.261860,
      0,
      3,
      0,
      2,
      0.257866,
      0,
      0,
      1,
      0.127215,
      0.084705,
      1,
      0,
      2.962421,
      2.082024,
      0,
      0.150742,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0.813680,
      3,
      NULL,
      NULL,
      0,
      1.669380,
      NULL,
      NULL,
      NULL,
      0.543742,
      3.375611,
      0.452547,
      2,
      1.629054,
      NULL,
      NULL,
      2.303633,
      2.652538,
      0.353543,
      1,
      3.338638,
      0.659623,
      1.573650,
      NULL,
      NULL,
      2.930098,
      2.628512,
      0,
      NULL,
      NULL,
      NULL,
      0.724931,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.396314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.009358,
      NULL,
      NULL,
      1,
      1.237039,
      1.716991,
      2.086106,
      1.412286,
      0.967462,
      7,
      3.482911,
      1.841932,
      2,
      NULL,
      NULL,
      NULL,
      1.168124,
      1,
      3.192243,
      2.570151,
      1.493246,
      3,
      1.940088,
      0,
      4,
      1.072903,
      0,
      2.546811,
      3.778964,
      0,
      NULL,
      2,
      NULL,
      0.307263,
      3.412052,
      1.703166,
      0,
      3.125423,
      NULL,
      1.273265,
      5.036630,
      NULL,
      1.623171,
      NULL,
      3.100733,
      NULL,
      2,
      9,
      1.954322,
      1.766762,
      NULL,
      1.659962,
      0,
      0.177353,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.336996,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.816845,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.553902,
      NULL,
      NULL,
      1.631891,
      NULL,
      NULL,
      2,
      3,
      2.900152,
      1,
      1,
      2,
      1,
      NULL,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.796533,
      NULL,
      NULL,
      1.239953,
      1.078321,
      NULL,
      NULL,
      1.507396,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.116239,
      3.460011,
      NULL,
      NULL,
      0.562986,
      2.900760,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2.844090,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.046112,
      NULL,
      NULL,
      NULL,
      1.236624,
      1.884746,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1.746559,
      2,
      NULL,
      NULL,
      0,
      3.787587,
      NULL,
      NULL,
      1.335388,
      1,
      NULL,
      NULL,
      1.288214,
      1.297269,
      NULL,
      NULL,
      6.566505,
      2,
      NULL,
      NULL,
      3,
      1.570404,
      0,
      3.054689,
      1.301782,
      2.689440,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.554012,
      2.139005,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.458767,
      NULL,
      44,
      0.176600,
      2.070450,
      1.753364,
      1.575399,
      1.750316,
      0.058724,
      1.212139,
      NULL,
      0.720478,
      0,
      1.886907,
      0,
      0,
      1,
      0,
      1.457301,
      1,
      0.918953,
      NULL,
      1.565652,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.048804,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      7,
      1.711500,
      1.925767,
      NULL,
      NULL,
      1,
      NULL,
      1.166437,
      NULL,
      0.948517,
      NULL,
      1.811776,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2,
      0,
      1.361684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.510977,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.719970,
      NULL,
      0.306900,
      NULL,
      NULL,
      NULL,
      1.742854,
      NULL,
      NULL,
      NULL,
      0.603007,
      0,
      1.451093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.119641,
      0,
      0,
      0.999116,
      1,
      0.984424,
      5,
      6,
      NULL,
      3.650399,
      1.852507,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      3,
      NULL,
      1,
      0.814231,
      NULL,
      0.180177,
      NULL,
      NULL,
      0.590691,
      3.451582,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.000347,
      NULL,
      0,
      0.264955,
      NULL,
      0.915777,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.887685,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1.659212,
      NULL,
      1.077833,
      NULL,
      3.744055,
      NULL,
      0.176560,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.171534,
      3,
      NULL,
      0,
      NULL,
      2.897392,
      NULL,
      1,
      NULL,
      6,
      0.608736,
      5,
      0.446873,
      0,
      NULL,
      4,
      44.662785,
      1.840186,
      0,
      NULL,
      '21141',
      '22012',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


