set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6703486';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-8-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2.489500,
      NULL,
      NULL,
      3.780989,
      1,
      NULL,
      NULL,
      2.794364,
      '441',
      '10113034',
      52,
      60,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-13-1990',
      199,
      NULL,
      NULL,
      2.512569,
      0.027172,
      ' 8-23-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      4.938711,
      NULL,
      NULL,
      NULL,
      NULL,
      1.921734,
      0,
      0.046889,
      0.119789,
      0,
      0.681567,
      0.236210,
      0,
      44.764431,
      6.820872,
      1,
      0.500644,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0,
      0,
      0.345093,
      0.762581,
      0,
      NULL,
      NULL,
      0,
      4.279920,
      NULL,
      1.474612,
      0,
      2,
      2,
      3.084988,
      7.745571,
      NULL,
      1,
      0,
      0.054540,
      1,
      NULL,
      NULL,
      1.518947,
      1,
      0.298492,
      1.163980,
      4.430772,
      NULL,
      2.663919,
      1,
      0.176637,
      NULL,
      NULL,
      NULL,
      1.117131,
      NULL,
      NULL,
      1,
      1.737143,
      1.332063,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.881724,
      NULL,
      0.441787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.873449,
      0.780302,
      1,
      1,
      1,
      0,
      1,
      0,
      0.637603,
      2.064665,
      1.911469,
      0,
      0,
      3.600788,
      NULL,
      0.603639,
      0,
      NULL,
      0.529028,
      NULL,
      1,
      0.047183,
      1,
      0,
      1.731286,
      0,
      1,
      2,
      NULL,
      NULL,
      0,
      0,
      3,
      NULL,
      0.869897,
      NULL,
      7.727451,
      NULL,
      NULL,
      2,
      0,
      NULL,
      5.189170,
      NULL,
      1,
      NULL,
      1,
      2,
      NULL,
      358.533356,
      ' 7- 0-1991',
      1259,
      2.643768,
      1.989884,
      0,
      0.609151,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.109585,
      1.879771,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.289254,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.695117,
      0,
      6.922161,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.993962,
      0.536288,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.370255,
      1.007672,
      1.019978,
      0.639915,
      1,
      0.351630,
      0,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.802040,
      NULL,
      3,
      0,
      0,
      0.876780,
      1.971431,
      0.465741,
      0.474440,
      0.274361,
      0.527983,
      2,
      2.580553,
      NULL,
      2.622356,
      0,
      0,
      7,
      3.328526,
      NULL,
      NULL,
      1.528552,
      1,
      1.483006,
      0,
      1,
      0.825102,
      0,
      2.115196,
      1.632942,
      5,
      11,
      5,
      10,
      2,
      1,
      0,
      NULL,
      4,
      0,
      3,
      NULL,
      NULL,
      2,
      0.043574,
      38,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.274042,
      '11341',
      '',
      NULL,
      1,
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      '',
      3.567186,
      NULL,
      91.038866,
      19.323168,
      3.289846,
      9.352580,
      NULL,
      79.636559,
      3.115512,
      NULL,
      1.033316,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3,
      1.827424,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.675634,
      0.857500,
      0.346118,
      1.463841,
      1.162286,
      NULL,
      NULL,
      0.754489,
      NULL,
      NULL,
      2.951932,
      3.568728,
      0.228584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.544138,
      1.175638,
      NULL,
      NULL,
      NULL,
      0.586656,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.894217,
      1,
      1,
      3,
      0,
      0.311312,
      0.673934,
      1,
      NULL,
      0,
      1.493786,
      0.165006,
      0,
      0.301621,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.502432,
      NULL,
      NULL,
      1,
      3,
      1.838656,
      2,
      0,
      1.842511,
      0.483326,
      1.220936,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.947342,
      2,
      1,
      1,
      NULL,
      NULL,
      2.335698,
      NULL,
      1.148082,
      0.071407,
      NULL,
      NULL,
      2.761970,
      3.135980,
      NULL,
      0.799920,
      0.138565,
      0,
      3,
      0.266409,
      0.504978,
      2,
      1,
      NULL,
      1.940053,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.854930,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.692468,
      0.101545,
      NULL,
      0,
      1,
      4.686276,
      6,
      NULL,
      2.230901,
      3,
      NULL,
      NULL,
      1,
      1,
      0.724941,
      1.306931,
      1.743318,
      3.672917,
      NULL,
      3.254179,
      0,
      NULL,
      0,
      4.564740,
      3.225436,
      0.361028,
      1,
      1.241874,
      NULL,
      NULL,
      3,
      0,
      2,
      0,
      3.201360,
      3.961722,
      2,
      NULL,
      1.241380,
      NULL,
      4.737299,
      4,
      0.913200,
      NULL,
      5.684301,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.359593,
      NULL,
      NULL,
      0.780248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.588470,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.107961,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      3.372561,
      3,
      1,
      0.662200,
      2.680094,
      3.356085,
      0,
      NULL,
      4.332108,
      5.748267,
      NULL,
      NULL,
      13.558934,
      7,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3.072525,
      NULL,
      NULL,
      0.310734,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.183165,
      1.923399,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.257358,
      0.840080,
      NULL,
      NULL,
      0.083571,
      2,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      2,
      0.071482,
      NULL,
      NULL,
      2.079967,
      NULL,
      NULL,
      NULL,
      2.542915,
      0,
      NULL,
      NULL,
      3,
      0.016352,
      NULL,
      NULL,
      14,
      8.790901,
      NULL,
      NULL,
      1.363957,
      1,
      3.820897,
      9.351363,
      2,
      NULL,
      NULL,
      348,
      1.257972,
      39.680112,
      3.154649,
      0.786121,
      NULL,
      NULL,
      3.458460,
      2.837191,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.210466,
      NULL,
      NULL,
      176,
      20,
      NULL,
      0.959800,
      1.671625,
      NULL,
      0.798648,
      0.917121,
      NULL,
      1.035073,
      1,
      NULL,
      NULL,
      2,
      1,
      0.627955,
      1.804689,
      2,
      NULL,
      1.993565,
      NULL,
      NULL,
      NULL,
      0.194131,
      NULL,
      1,
      NULL,
      0.760734,
      NULL,
      0.452638,
      NULL,
      3,
      NULL,
      0.176700,
      NULL,
      3.214624,
      0.566168,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.465420,
      NULL,
      1.470097,
      NULL,
      0.925642,
      NULL,
      NULL,
      NULL,
      1.131350,
      NULL,
      0.415645,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.641734,
      0.023715,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.808355,
      3,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.751927,
      NULL,
      1.780435,
      NULL,
      0,
      NULL,
      NULL,
      1.665689,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.018200,
      NULL,
      NULL,
      0.621906,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.710194,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.250856,
      0,
      NULL,
      1,
      NULL,
      1.010311,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2.330798,
      NULL,
      0.824166,
      NULL,
      NULL,
      NULL,
      185.044206,
      NULL,
      0,
      NULL,
      2.184602,
      NULL,
      0,
      NULL,
      3.587193,
      NULL,
      0,
      1.572151,
      NULL,
      NULL,
      NULL,
      1.350409,
      4,
      NULL,
      9,
      1,
      2.211880,
      NULL,
      3.046565,
      7.758511,
      NULL,
      2,
      NULL,
      0.288718,
      1.593355,
      1,
      2.015657,
      3,
      0.485572,
      0,
      1,
      3.382162,
      NULL,
      0,
      1.772421,
      0.793253,
      0.355466,
      0.565661,
      0.114962,
      1.640546,
      NULL,
      0.343804,
      0,
      2,
      0.826764,
      NULL,
      2,
      0,
      1.885257,
      NULL,
      0.422976,
      2,
      2.716862,
      0.372371,
      0.480888,
      3.420949,
      1.681957,
      0.512470,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.711826,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.180088,
      1.171575,
      NULL,
      1.591760,
      7.065078,
      1.992988,
      NULL,
      NULL,
      60.030886,
      77,
      4.627858,
      1.202611,
      NULL,
      '42210',
      '42114',
      '04204',
      0,
      '',
      '',
      NULL,
      1.215441,
      '',
      '',
      '');
commit;
end;
/


