set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8702181';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-11-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      '3143211',
      3.247823,
      NULL,
      6,
      2,
      '1013',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      45,
      NULL,
      1.628415,
      NULL,
      0.487096,
      NULL,
      33,
      1,
      5.642255,
      NULL,
      1,
      '11-29-1993',
      ' 2- 5-2003',
      '11-26-1983',
      3.501449,
      NULL,
      3,
      1.545146,
      1,
      0.599429,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.129684,
      21.967890,
      6.675724,
      NULL,
      9.218384,
      NULL,
      1,
      6.460652,
      0,
      2.278004,
      NULL,
      NULL,
      NULL,
      1,
      0,
      5,
      0,
      1,
      NULL,
      3.169233,
      3,
      13,
      0,
      3.178120,
      0,
      0,
      3.699245,
      3,
      1,
      6,
      1,
      3,
      1,
      0,
      0,
      0.088733,
      NULL,
      2.930123,
      NULL,
      0.207732,
      1.641825,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.501330,
      0,
      1.022855,
      0.746393,
      1,
      0.637929,
      0.174959,
      3.521512,
      NULL,
      NULL,
      1.124783,
      1.151950,
      NULL,
      1,
      0.160005,
      1.732874,
      0,
      0.190314,
      NULL,
      5,
      1,
      0.592533,
      NULL,
      NULL,
      NULL,
      0.145109,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.152289,
      NULL,
      7,
      6.325532,
      1.987753,
      0,
      3.892227,
      0.048517,
      1.482676,
      1.256946,
      1.225262,
      0.599876,
      0,
      0,
      0,
      0.541771,
      0.563025,
      NULL,
      0,
      5,
      1.437044,
      2.724965,
      0.416428,
      1.606205,
      4.242532,
      0,
      0.724327,
      0.782157,
      5.934611,
      0.999166,
      NULL,
      NULL,
      8.207341,
      1.528123,
      0,
      2.790669,
      3.575432,
      NULL,
      NULL,
      6,
      3,
      2,
      3,
      5.729545,
      NULL,
      2,
      ' 0-10-1999',
      NULL,
      NULL,
      0.865424,
      1.998880,
      0,
      1.405772,
      8,
      0.725625,
      NULL,
      2.861033,
      2,
      1.333332,
      3,
      3,
      NULL,
      3,
      2.572029,
      5,
      NULL,
      1,
      0,
      0,
      8,
      1.592548,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.314769,
      NULL,
      3,
      0.990239,
      NULL,
      5.166831,
      0,
      1,
      3,
      1,
      NULL,
      6,
      0.635840,
      0,
      0,
      2,
      2.234562,
      5.465913,
      1,
      3,
      1.875477,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.353598,
      0.090411,
      0.579888,
      0.714096,
      1,
      0,
      7.321102,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.847753,
      1.464749,
      0,
      3,
      2.193849,
      3.935448,
      1.622396,
      1.976355,
      3,
      3.561625,
      1,
      0,
      2.210266,
      6.817615,
      NULL,
      180.200549,
      182,
      2.623561,
      85,
      113,
      69,
      1,
      0.046294,
      0.859023,
      0.462144,
      NULL,
      1,
      1,
      12.700969,
      10.535818,
      1,
      3.973066,
      4.170307,
      0.767440,
      0.128651,
      0,
      NULL,
      0.054365,
      NULL,
      NULL,
      1,
      1.996762,
      2.313011,
      3,
      NULL,
      2.617977,
      NULL,
      NULL,
      72.664185,
      NULL,
      3,
      NULL,
      5.553340,
      NULL,
      '04033',
      NULL,
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      32,
      27,
      4.058077,
      0.326319,
      NULL,
      7,
      2,
      NULL,
      1,
      NULL,
      0.267113,
      0,
      NULL,
      NULL,
      1,
      0,
      1.358500,
      1.549051,
      1,
      0,
      2.153765,
      1.116806,
      1.412343,
      3.510307,
      1.706303,
      1,
      0.086085,
      2,
      1,
      1,
      NULL,
      NULL,
      1.897182,
      2.208700,
      3.963660,
      1,
      NULL,
      NULL,
      2.882093,
      2,
      NULL,
      2,
      1,
      1.310655,
      8.011148,
      9.115701,
      0,
      1.768425,
      1.422024,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.501980,
      1,
      3,
      1.357043,
      1,
      1,
      NULL,
      NULL,
      0.527529,
      1,
      0.391907,
      1.689417,
      NULL,
      2.616823,
      1.235984,
      NULL,
      1.674583,
      1.554996,
      1,
      0,
      0.859224,
      NULL,
      1,
      1,
      0.010715,
      2.166721,
      1,
      0.795402,
      NULL,
      1,
      0.905854,
      0,
      1,
      2,
      7,
      3.822123,
      1,
      1.955502,
      NULL,
      NULL,
      NULL,
      1.525503,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      3,
      2,
      0,
      0,
      3,
      0.528061,
      NULL,
      NULL,
      NULL,
      0.215061,
      8,
      0,
      3.324500,
      NULL,
      0,
      1,
      NULL,
      1.526395,
      4,
      1.031338,
      0.105801,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      3.175284,
      NULL,
      0,
      NULL,
      1.559710,
      0.253771,
      5.442334,
      3.223451,
      NULL,
      4.292256,
      4.648397,
      5,
      7.338673,
      1.570239,
      1.095372,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.123183,
      3.924555,
      0,
      5,
      5.219065,
      2.205817,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      3,
      2,
      1.773728,
      NULL,
      3,
      4,
      3.162333,
      3,
      0,
      3,
      1,
      3.705533,
      2.896991,
      0,
      0,
      NULL,
      1.699829,
      1.619162,
      0.322991,
      NULL,
      NULL,
      1.593120,
      NULL,
      NULL,
      37,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.551916,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.756564,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.939736,
      2.728423,
      1.871569,
      NULL,
      NULL,
      7,
      5,
      NULL,
      NULL,
      NULL,
      2.137848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.313361,
      0.798647,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      0.554571,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.543243,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.408771,
      NULL,
      NULL,
      NULL,
      1.513985,
      NULL,
      NULL,
      NULL,
      0.119175,
      1,
      NULL,
      NULL,
      0.707567,
      1.391430,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      3,
      1.822194,
      NULL,
      NULL,
      2,
      0.213094,
      NULL,
      NULL,
      3.256619,
      0,
      NULL,
      NULL,
      1,
      0.410080,
      NULL,
      NULL,
      8,
      4,
      NULL,
      NULL,
      1.529607,
      NULL,
      NULL,
      NULL,
      NULL,
      29,
      7.572448,
      2,
      5.330039,
      1.318418,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.783984,
      NULL,
      NULL,
      483,
      5.522789,
      1,
      1,
      1.218516,
      1.707124,
      1,
      0,
      3,
      0,
      2.490975,
      1.423397,
      0.617521,
      0,
      0.523232,
      1.998011,
      1,
      0,
      2,
      NULL,
      0.064858,
      NULL,
      1,
      NULL,
      0.755072,
      NULL,
      0.438685,
      NULL,
      2.783423,
      NULL,
      3.219421,
      NULL,
      3.322321,
      NULL,
      22.033243,
      NULL,
      1.103792,
      0.748209,
      NULL,
      0.258980,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.731656,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.885321,
      NULL,
      NULL,
      0.202655,
      NULL,
      NULL,
      NULL,
      0.492658,
      NULL,
      1,
      NULL,
      0.219665,
      NULL,
      0.348821,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.719684,
      0,
      1.197730,
      NULL,
      1.393350,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      2.025547,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.193999,
      NULL,
      NULL,
      NULL,
      1.548383,
      NULL,
      NULL,
      NULL,
      0.041300,
      NULL,
      0,
      NULL,
      0.340492,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.841305,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.996499,
      NULL,
      1.966968,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.634340,
      NULL,
      1.411721,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.214849,
      1,
      1.838021,
      0.733087,
      0,
      NULL,
      1,
      2.190764,
      NULL,
      1.081494,
      1,
      0,
      0.438583,
      1,
      1.250050,
      NULL,
      1,
      0.812888,
      1,
      1,
      0.804415,
      1.713380,
      1,
      0,
      2.434741,
      1,
      1.589831,
      3.340734,
      0,
      1,
      0,
      1.709205,
      1.987542,
      2.188696,
      0,
      0.549903,
      1,
      0,
      NULL,
      3,
      1.874050,
      1,
      1.603945,
      3.180615,
      3.973368,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      3.415877,
      NULL,
      0.264183,
      NULL,
      0.759695,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.498008,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3.125752,
      NULL,
      NULL,
      NULL,
      1.843885,
      5.604204,
      1,
      3,
      1.688503,
      0.779983,
      0.066266,
      1,
      0.430678,
      1,
      5.670650,
      3.035752,
      2,
      NULL,
      NULL,
      NULL,
      32,
      32.576564,
      NULL,
      1,
      2.198036,
      '11214',
      '00402',
      '14202',
      1.895895,
      NULL,
      '',
      NULL,
      0.255260,
      '',
      '',
      '');
commit;
end;
/


