set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8706881';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-3-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      5.244917,
      3,
      0.849607,
      2.172763,
      1,
      2.648224,
      NULL,
      NULL,
      NULL,
      '34104232',
      43.865032,
      29.490567,
      NULL,
      NULL,
      0.690799,
      NULL,
      3,
      '0132',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-29-1983',
      57.854334,
      NULL,
      NULL,
      1.036820,
      3.045768,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.814961,
      ' 4-21-1986',
      ' 9-25-1992',
      ' 6- 5-1997',
      1,
      2,
      2.741970,
      1.848509,
      1.930620,
      NULL,
      2,
      3.966817,
      NULL,
      NULL,
      NULL,
      7.480500,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.809378,
      0.673428,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.942997,
      5,
      1,
      2.088229,
      3,
      2,
      1.197307,
      NULL,
      NULL,
      1,
      0,
      0.548104,
      1.206505,
      2,
      1.674302,
      0.521922,
      1,
      0,
      1,
      0.352707,
      NULL,
      1,
      NULL,
      1,
      0.287309,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.461623,
      2.576306,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.040475,
      7.587320,
      1.951308,
      5,
      NULL,
      0.136221,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0.658929,
      6,
      1.403220,
      NULL,
      6.822056,
      7.336054,
      0,
      1.157078,
      NULL,
      1,
      7.243274,
      1.785390,
      6.416326,
      1,
      1.634579,
      0.918240,
      NULL,
      0,
      NULL,
      0,
      0.586936,
      2.701122,
      4.457663,
      1,
      1,
      2.939160,
      2,
      NULL,
      2,
      1,
      3,
      1,
      9.883454,
      NULL,
      2,
      0.180580,
      0.494575,
      0.814518,
      5,
      6,
      6.386297,
      4.001286,
      NULL,
      7,
      NULL,
      6.496535,
      1,
      ' 6- 3-1992',
      129,
      ' 0- 0-1991',
      71,
      NULL,
      1.660752,
      1.538977,
      NULL,
      0.641578,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.835773,
      1,
      1,
      0,
      0,
      0,
      0.465505,
      1.822820,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      9,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.074611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.647865,
      4,
      6,
      1.286768,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.493286,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.895631,
      0,
      0.139497,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5.033154,
      0.635841,
      NULL,
      4,
      4.755176,
      2.752551,
      5.722516,
      5.136658,
      1.984782,
      2,
      NULL,
      NULL,
      0.722293,
      NULL,
      NULL,
      2,
      NULL,
      0.035073,
      0.888013,
      0.672651,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.192661,
      NULL,
      1,
      0,
      3.701733,
      1,
      5.069844,
      1.573268,
      6,
      3,
      7.141570,
      0,
      NULL,
      3,
      3,
      NULL,
      NULL,
      2,
      46,
      3.155180,
      NULL,
      38.608259,
      NULL,
      NULL,
      57.073782,
      5,
      4,
      2,
      '23424',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.237185,
      '14003',
      '',
      '',
      1,
      NULL,
      NULL,
      41,
      1.304965,
      NULL,
      NULL,
      NULL,
      NULL,
      1.474592,
      NULL,
      0.359154,
      1.433670,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3,
      2,
      NULL,
      NULL,
      NULL,
      1.468627,
      NULL,
      NULL,
      2,
      3,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.146794,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      2,
      NULL,
      1.807890,
      1.632667,
      NULL,
      NULL,
      NULL,
      0.812611,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.648300,
      NULL,
      NULL,
      0.074414,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0.879122,
      2,
      2,
      NULL,
      1,
      4.535185,
      0,
      0.997482,
      2,
      0.952586,
      NULL,
      NULL,
      NULL,
      1.626672,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3.103101,
      1.257263,
      3.652595,
      NULL,
      NULL,
      3,
      2.780496,
      0.044860,
      NULL,
      NULL,
      2,
      3.637979,
      NULL,
      0.136888,
      1.738933,
      2.576540,
      0,
      NULL,
      NULL,
      4.312417,
      5.776511,
      0.244864,
      1.080783,
      NULL,
      NULL,
      0.988971,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.036526,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.260091,
      1.968490,
      NULL,
      1.032491,
      NULL,
      NULL,
      3.970141,
      4,
      4,
      4,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.255401,
      0.018678,
      NULL,
      1.008756,
      NULL,
      2.483659,
      2,
      3.936616,
      2.131461,
      2.195651,
      0.320206,
      0,
      0.426189,
      0.710142,
      3.575201,
      NULL,
      3,
      1,
      3.260872,
      1,
      2.578083,
      0,
      8.868829,
      5.499915,
      NULL,
      NULL,
      1.570360,
      0,
      1,
      1,
      1,
      0,
      1,
      1.502819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.750097,
      NULL,
      NULL,
      0.680880,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.510723,
      NULL,
      NULL,
      1.176357,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1.574328,
      0.385720,
      1,
      0,
      NULL,
      2.618039,
      1.948740,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.101747,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.095578,
      NULL,
      NULL,
      NULL,
      3.206626,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.512029,
      NULL,
      NULL,
      NULL,
      4.852221,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.546989,
      NULL,
      NULL,
      1.823681,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      212.310231,
      0.558518,
      1,
      2,
      0.038438,
      0,
      NULL,
      1.667483,
      NULL,
      0.913062,
      NULL,
      NULL,
      0.149571,
      0,
      1,
      1,
      1,
      3,
      0.095064,
      2.125057,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3.582842,
      NULL,
      0,
      NULL,
      25,
      NULL,
      0,
      NULL,
      32.740162,
      1,
      0,
      NULL,
      NULL,
      1.743527,
      NULL,
      1.347161,
      NULL,
      0.804300,
      NULL,
      1,
      NULL,
      0.397991,
      NULL,
      1,
      NULL,
      1.384968,
      NULL,
      1.755374,
      NULL,
      1,
      NULL,
      0.411033,
      NULL,
      1.016654,
      NULL,
      0,
      NULL,
      0.174087,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.931290,
      2.596735,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.623290,
      NULL,
      1.856014,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.773036,
      NULL,
      1.325589,
      NULL,
      1,
      NULL,
      1.084718,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.198138,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      3,
      NULL,
      3,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.989907,
      1.596827,
      1.665929,
      NULL,
      2.072609,
      NULL,
      3.170166,
      NULL,
      1.748619,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.653617,
      NULL,
      NULL,
      27,
      44,
      2,
      0.463176,
      1.916736,
      NULL,
      1.316999,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.463210,
      1.762691,
      3.007250,
      2.962089,
      1.384429,
      1.962312,
      NULL,
      NULL,
      1,
      0.399773,
      NULL,
      0,
      0.762282,
      NULL,
      0,
      1.320799,
      NULL,
      1.114526,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.472346,
      0,
      NULL,
      0.164515,
      2,
      NULL,
      0.297236,
      0.415216,
      NULL,
      1,
      0.188752,
      NULL,
      NULL,
      0,
      NULL,
      1.336539,
      1.450542,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      7.132756,
      2,
      3,
      0.928829,
      NULL,
      NULL,
      67,
      16,
      3.621132,
      1,
      5.505335,
      '03220',
      '04433',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '14103',
      '',
      '');
commit;
end;
/


