set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8924746';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-2-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      NULL,
      '0301421',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.391965,
      NULL,
      NULL,
      ' 1- 1-1987',
      7,
      NULL,
      0,
      2.727918,
      0,
      ' 4-16-1982',
      73,
      0,
      110,
      35,
      2,
      '11-16-1996',
      NULL,
      NULL,
      3,
      0.126519,
      3,
      1.675568,
      0.880020,
      0.241854,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      0.725064,
      21,
      NULL,
      1.735902,
      21.330441,
      0.958052,
      3.481137,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.136625,
      NULL,
      1.029860,
      1.826796,
      1.093665,
      0.883330,
      3.662123,
      NULL,
      3,
      3,
      1,
      1.139900,
      0.763335,
      1.707361,
      1,
      1.104583,
      1.393130,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      3,
      2.847997,
      NULL,
      1.157693,
      0.397122,
      1.117578,
      1.196585,
      1.291212,
      0.212765,
      1.409674,
      2.704819,
      3.121249,
      0,
      1.334335,
      0,
      NULL,
      1,
      0.565477,
      1,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.772904,
      3,
      3.782747,
      0.396154,
      2.069071,
      1.894426,
      1.304238,
      0.615548,
      0.272480,
      0.657124,
      NULL,
      0,
      1,
      0.960951,
      1,
      1.323094,
      1,
      0,
      0.671986,
      NULL,
      1.891862,
      1.743018,
      1.487216,
      0.711843,
      0,
      0.783923,
      0.140667,
      1.540937,
      0.932458,
      1,
      0.978404,
      0.656801,
      1.967505,
      0.180898,
      NULL,
      0,
      7.478174,
      0.384525,
      5.099276,
      2.493692,
      1.251461,
      3,
      0.594517,
      0,
      2.822427,
      1.510168,
      1.109755,
      3,
      ' 1-17-1975',
      NULL,
      NULL,
      66.196176,
      0.060272,
      0,
      1.312254,
      NULL,
      1.460819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.540676,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.959371,
      0.107100,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.614913,
      NULL,
      1,
      2,
      4.523808,
      0.414620,
      1.829166,
      NULL,
      5,
      2,
      4,
      1,
      NULL,
      NULL,
      3.253968,
      7.836173,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.510067,
      0.302564,
      1,
      0.621200,
      NULL,
      1.621374,
      1.888187,
      2.226621,
      30,
      NULL,
      0.141065,
      NULL,
      NULL,
      NULL,
      1.880085,
      0.779826,
      1.048127,
      0.837888,
      0,
      2.063263,
      1.239370,
      0.169595,
      1.985147,
      2,
      0,
      0.656720,
      3,
      3,
      1,
      2,
      4,
      0.174251,
      0.176427,
      5.492852,
      3.704190,
      0,
      1.431777,
      0,
      0,
      0.370910,
      1.170861,
      1,
      3.126658,
      0.470607,
      NULL,
      0,
      4.171992,
      10,
      1.066617,
      4.062459,
      1.090507,
      5,
      5,
      0.681970,
      3,
      3.563615,
      0.506779,
      2,
      46,
      1,
      3,
      NULL,
      50,
      NULL,
      108,
      4.267931,
      0,
      NULL,
      '14412',
      '',
      '',
      3.776564,
      '44044',
      '',
      NULL,
      0.144521,
      '',
      '',
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.918136,
      1.033488,
      NULL,
      0.769852,
      0.797154,
      1.619942,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.689600,
      1,
      21.864337,
      NULL,
      1.088891,
      NULL,
      0,
      NULL,
      0,
      1.547086,
      0,
      0,
      1,
      NULL,
      0.862945,
      1.628301,
      NULL,
      0,
      NULL,
      1.294266,
      1.881651,
      NULL,
      1,
      NULL,
      3.312709,
      NULL,
      NULL,
      NULL,
      3.089194,
      NULL,
      2.150667,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.268070,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.170754,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.323891,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.968521,
      NULL,
      1,
      NULL,
      0.193158,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.228226,
      NULL,
      NULL,
      1.214938,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.163877,
      NULL,
      1.006223,
      NULL,
      1,
      0.937550,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.126727,
      0,
      NULL,
      0.949759,
      1.926636,
      0,
      NULL,
      NULL,
      0,
      NULL,
      2,
      2.953927,
      NULL,
      NULL,
      1.294233,
      1,
      0.725078,
      1.064995,
      0,
      1,
      1,
      1.716141,
      NULL,
      1.799004,
      1,
      1,
      1,
      1.460414,
      0.076895,
      1,
      1,
      1.647113,
      0.067419,
      0,
      1,
      0,
      0.734594,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1.558186,
      NULL,
      NULL,
      NULL,
      NULL,
      1.333905,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.231268,
      NULL,
      1,
      NULL,
      0.024807,
      2.224658,
      1,
      3,
      1.544812,
      2.551126,
      0,
      2.850287,
      NULL,
      NULL,
      3.567229,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2.495619,
      2.362082,
      1.713235,
      2.806378,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.119905,
      3,
      1.752362,
      1,
      1,
      3,
      1,
      0,
      NULL,
      NULL,
      3,
      118,
      3,
      0.433595,
      2.893892,
      '21123',
      '',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


