set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5905417';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-11-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      '3034343',
      1,
      NULL,
      3,
      0,
      '1200',
      NULL,
      NULL,
      0,
      10,
      ' 5-20-1976',
      8,
      NULL,
      2,
      3,
      1,
      '11-12-1993',
      NULL,
      3,
      173,
      46,
      5,
      NULL,
      NULL,
      ' 3-12-2003',
      1,
      0.061541,
      1,
      NULL,
      0.154319,
      2.883126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.035907,
      9,
      3.226913,
      15,
      0.620335,
      NULL,
      NULL,
      1.425691,
      0.579550,
      1.231073,
      1.464237,
      2,
      NULL,
      1,
      0.802863,
      NULL,
      0.928063,
      0,
      0,
      1,
      1,
      4.056868,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.176021,
      1,
      NULL,
      3,
      2,
      NULL,
      2.742534,
      5.704951,
      NULL,
      1,
      5.579662,
      1,
      1.057274,
      3.304451,
      2.593184,
      NULL,
      1,
      0.918708,
      0.591813,
      0.736548,
      1.934378,
      5.018751,
      0.688730,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      0.073040,
      0,
      4.713949,
      7,
      NULL,
      1.466659,
      NULL,
      1.446810,
      3.908948,
      1.998846,
      0.001898,
      3,
      1.195976,
      NULL,
      56,
      3.083023,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      1,
      0,
      NULL,
      12.047050,
      1.847351,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.874234,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.658110,
      NULL,
      NULL,
      0.592055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.757847,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.851990,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.582569,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.278270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.354879,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.903588,
      NULL,
      NULL,
      1.432389,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.272576,
      NULL,
      NULL,
      0.698499,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.289568,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.373681,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.009275,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.009190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.402909,
      NULL,
      NULL,
      0.791020,
      NULL,
      NULL,
      0.199325,
      NULL,
      NULL,
      0.141638,
      NULL,
      NULL,
      0.024279,
      NULL,
      NULL,
      1.163731,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.999603,
      0,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.571918,
      0.251717,
      2.786637,
      3,
      1,
      NULL,
      1,
      8.803671,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.345920,
      NULL,
      NULL,
      NULL,
      0.731082,
      NULL,
      NULL,
      NULL,
      0.129395,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      17.520314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      NULL,
      NULL,
      NULL,
      1.313449,
      NULL,
      NULL,
      NULL,
      0.304692,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.116017,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0.418619,
      NULL,
      NULL,
      NULL,
      989,
      1642.157533,
      0.841685,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.255834,
      97,
      276.956059,
      1.266827,
      NULL,
      NULL,
      0.975616,
      NULL,
      1,
      4921,
      911.311725,
      3.862286,
      0.807965,
      3,
      1,
      1,
      0,
      3.123000,
      1.855383,
      0,
      1,
      NULL,
      0,
      2,
      0.315046,
      1,
      NULL,
      1.544252,
      1.079709,
      2,
      NULL,
      3.474016,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.511218,
      NULL,
      14,
      NULL,
      2.369746,
      NULL,
      NULL,
      NULL,
      1,
      3.254105,
      0.384323,
      1.828063,
      NULL,
      NULL,
      NULL,
      1.336403,
      NULL,
      0.989517,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.211958,
      NULL,
      1,
      NULL,
      0.920450,
      NULL,
      1.746534,
      NULL,
      0.503704,
      NULL,
      NULL,
      NULL,
      2.299559,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.839046,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.993956,
      0,
      NULL,
      1.527896,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.737570,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      3.902344,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.661786,
      NULL,
      3.268511,
      NULL,
      2.059986,
      NULL,
      1.570158,
      1.099175,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.661905,
      3,
      NULL,
      2,
      NULL,
      0.494274,
      NULL,
      NULL,
      NULL,
      0.179424,
      0.979956,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.057635,
      NULL,
      1,
      NULL,
      0,
      0,
      3,
      30,
      48,
      3,
      2,
      1,
      2,
      2,
      2,
      0.387461,
      7.258132,
      1.535518,
      0,
      0,
      NULL,
      7.568979,
      1.187527,
      2,
      2,
      0.921945,
      NULL,
      0.888579,
      0,
      NULL,
      1,
      0.273460,
      1,
      0.902625,
      0,
      0,
      1.027728,
      0,
      12,
      14.119484,
      NULL,
      NULL,
      1,
      1,
      1,
      0.156819,
      0.135194,
      0,
      1,
      NULL,
      0,
      0.983136,
      0.240353,
      0.009558,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      0.255971,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.226196,
      0,
      NULL,
      1.857526,
      1.244349,
      5,
      NULL,
      0,
      NULL,
      NULL,
      6,
      95,
      0.898328,
      0,
      NULL,
      '10321',
      '02120',
      '12210',
      0,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      '');
commit;
end;
/


