set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8936802';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-12-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3343022',
      1,
      1.556065,
      NULL,
      3,
      '1133',
      3,
      1,
      NULL,
      NULL,
      NULL,
      49,
      NULL,
      1.797608,
      1,
      1,
      ' 8-27-2003',
      NULL,
      2.610910,
      252,
      113,
      NULL,
      '11- 7-1987',
      ' 1-20-1994',
      '11-16-1992',
      0,
      1.803158,
      2.254846,
      1,
      0.427710,
      0,
      NULL,
      1,
      0.438963,
      578,
      3,
      16.608314,
      7,
      NULL,
      10.344051,
      1.236625,
      12,
      3,
      0.894081,
      0.293599,
      1.074454,
      1.764338,
      0,
      0.746024,
      1,
      1,
      1,
      0,
      1.361338,
      0,
      129,
      5.747133,
      NULL,
      5,
      1,
      0,
      1,
      1,
      1.494802,
      0.498074,
      NULL,
      1.988083,
      NULL,
      1.567047,
      NULL,
      2.381067,
      NULL,
      0.664273,
      0,
      3.047072,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7,
      NULL,
      3,
      3,
      0.284702,
      1.810932,
      2,
      3.062885,
      2,
      0.666769,
      1.707041,
      NULL,
      0.770589,
      1.143152,
      NULL,
      1.208213,
      1,
      1,
      2.805613,
      0,
      0,
      4.093276,
      NULL,
      1.379363,
      NULL,
      3,
      1.238670,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.857663,
      1.090896,
      3.876850,
      1,
      2,
      1,
      7.179136,
      0.880473,
      1.016002,
      1,
      0.697654,
      0,
      1.386121,
      1.136352,
      0,
      NULL,
      0,
      1.881173,
      0.886866,
      NULL,
      1,
      6,
      5,
      NULL,
      4.164174,
      NULL,
      0,
      NULL,
      1.129217,
      5.244579,
      6.384966,
      NULL,
      NULL,
      6,
      4,
      6,
      4.212589,
      3,
      10,
      3.158199,
      NULL,
      3,
      3.147245,
      10,
      4,
      4,
      NULL,
      1.945286,
      ' 1-21-1975',
      1070,
      ' 7-28-1989',
      NULL,
      NULL,
      1,
      0,
      5,
      1.956229,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.059417,
      0.390473,
      1,
      0,
      0.317425,
      0,
      3,
      0.866373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.585373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.434022,
      0,
      0,
      1,
      0,
      3.458027,
      1.435620,
      NULL,
      NULL,
      NULL,
      0.658006,
      1,
      0.669331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.521669,
      0,
      NULL,
      NULL,
      3.546714,
      1.882529,
      0.695900,
      6636.309402,
      1,
      2.194701,
      39.785991,
      1945.517417,
      1419,
      5,
      0,
      NULL,
      0.965111,
      NULL,
      5.548344,
      1.094046,
      1,
      NULL,
      0.179519,
      5.809894,
      5.641025,
      5,
      0.602404,
      2.057696,
      0,
      3,
      0,
      NULL,
      0,
      0,
      0.461277,
      NULL,
      1,
      1.920938,
      1.500776,
      1,
      0.557737,
      1.111247,
      NULL,
      4.167169,
      1.720949,
      0,
      0,
      3,
      1.277994,
      3,
      0,
      3.746165,
      3.527799,
      NULL,
      3,
      0,
      1.894927,
      39,
      1.095180,
      0,
      NULL,
      29.002905,
      56.428677,
      55,
      0.604083,
      1.064673,
      3.809299,
      '24442',
      '12233',
      '',
      0.724027,
      '',
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      13.973830,
      122,
      1,
      3,
      NULL,
      5.112857,
      280.304791,
      NULL,
      1.049759,
      1.728796,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.376576,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.867915,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.151809,
      NULL,
      2,
      1.637227,
      1.246554,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.448915,
      0,
      NULL,
      2,
      NULL,
      NULL,
      1,
      1.321528,
      NULL,
      NULL,
      0.274780,
      1.766602,
      1.434751,
      1.205111,
      NULL,
      2,
      0.787102,
      NULL,
      NULL,
      1.324131,
      NULL,
      NULL,
      0.550349,
      1,
      2.906063,
      3.739849,
      NULL,
      8,
      5.142457,
      NULL,
      NULL,
      NULL,
      NULL,
      0.016399,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.363326,
      0.177751,
      NULL,
      2,
      3,
      2.918600,
      0,
      NULL,
      NULL,
      NULL,
      5.994477,
      3,
      0.985205,
      0.427788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.744161,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.085659,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.073036,
      NULL,
      3.031035,
      0,
      0.998887,
      1,
      NULL,
      0,
      0,
      NULL,
      4.145684,
      1,
      0.623431,
      0,
      NULL,
      2,
      3.419154,
      NULL,
      2.928563,
      1,
      0,
      6,
      0.593362,
      NULL,
      3,
      1.185021,
      0,
      NULL,
      0.455738,
      2.796951,
      1,
      0,
      1.596773,
      0,
      1.697812,
      3.937612,
      NULL,
      3,
      NULL,
      7,
      3.972084,
      6.546010,
      2.494078,
      1.784529,
      1.132372,
      0,
      1,
      1,
      NULL,
      0.411535,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.859527,
      NULL,
      NULL,
      0.822487,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      0.222094,
      1,
      0,
      NULL,
      3,
      0.320684,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.616549,
      NULL,
      NULL,
      NULL,
      1.873888,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.850993,
      NULL,
      NULL,
      NULL,
      3.701986,
      200,
      9,
      1.393235,
      NULL,
      NULL,
      0.314731,
      NULL,
      NULL,
      3.876240,
      274.308479,
      71,
      1,
      47,
      10,
      3.472079,
      133.486815,
      25,
      2,
      NULL,
      1,
      126.567183,
      2.425016,
      0.719710,
      1.000448,
      1,
      1.657408,
      NULL,
      0,
      0.508658,
      0,
      0.348167,
      1,
      0,
      1,
      NULL,
      1.738222,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.370456,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.453625,
      0.241356,
      3,
      7.169955,
      0,
      1.386832,
      0,
      4.041418,
      16.543019,
      3.403268,
      0,
      NULL,
      0.849943,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.548464,
      NULL,
      1.686866,
      0,
      NULL,
      0,
      0.698759,
      NULL,
      1,
      1,
      NULL,
      0.304402,
      2.040261,
      NULL,
      NULL,
      2.028985,
      NULL,
      1.851203,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.260020,
      0.358087,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.726141,
      NULL,
      4,
      NULL,
      10.984236,
      1,
      0.340059,
      0.189292,
      35,
      NULL,
      2,
      NULL,
      4,
      '10222',
      '21230',
      '',
      0,
      '',
      '',
      '',
      2.936929,
      NULL,
      '',
      '');
commit;
end;
/


