set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9736648';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-3-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      7,
      0,
      3.156139,
      2.718201,
      0.887944,
      1.895728,
      1.277501,
      3,
      '11',
      '11',
      NULL,
      32.036464,
      NULL,
      3.421143,
      1.975456,
      NULL,
      1,
      NULL,
      0.751700,
      1,
      NULL,
      NULL,
      ' 3-17-2001',
      NULL,
      17,
      NULL,
      NULL,
      1,
      ' 4-10-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 1-19-1978',
      ' 6-28-1995',
      ' 9- 7-1981',
      1.964192,
      NULL,
      NULL,
      0,
      1,
      1.866281,
      1.660486,
      0.611769,
      0,
      5,
      11.356357,
      14,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.289327,
      2.374110,
      NULL,
      0,
      0.830296,
      0,
      0,
      1,
      0.620058,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2.060734,
      5.201538,
      5,
      NULL,
      6,
      0,
      NULL,
      0,
      1.101074,
      0.754081,
      NULL,
      0,
      0.672735,
      1,
      0,
      0.597572,
      8.398102,
      1.895571,
      0.673952,
      NULL,
      NULL,
      0.234266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.454841,
      3.581493,
      5.749244,
      NULL,
      1.060661,
      1,
      NULL,
      NULL,
      3.993877,
      NULL,
      1.611327,
      0,
      1.706586,
      2.292279,
      0.530073,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.897054,
      NULL,
      1,
      3.944390,
      1,
      NULL,
      NULL,
      0.428621,
      NULL,
      NULL,
      NULL,
      3,
      5.689860,
      4,
      NULL,
      8,
      NULL,
      9.619513,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.751342,
      0.771019,
      1,
      1.594850,
      0,
      0.587120,
      NULL,
      0.964035,
      3.135851,
      0,
      5,
      NULL,
      0.168055,
      0,
      9.705188,
      6,
      2,
      NULL,
      5.656697,
      2,
      4.838688,
      1.434903,
      3.585654,
      3.599955,
      5.543875,
      11,
      10,
      NULL,
      NULL,
      10.989755,
      1,
      NULL,
      7,
      5,
      NULL,
      ' 2-23-1975',
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.528798,
      2,
      NULL,
      3.766350,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.410030,
      0.813130,
      3,
      0.988246,
      1.619010,
      2,
      0.428110,
      5,
      7,
      1.232971,
      1,
      3,
      1,
      2.357820,
      1,
      4.197847,
      6.792740,
      NULL,
      0.208451,
      2.390698,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      6.932974,
      0.302141,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.594718,
      1,
      0.462403,
      NULL,
      0.723125,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1.367333,
      NULL,
      NULL,
      NULL,
      0.034358,
      1,
      2.297693,
      1.739782,
      3,
      0,
      NULL,
      3.476634,
      NULL,
      0.558928,
      2.603162,
      NULL,
      3,
      2.932860,
      1.182079,
      3,
      1.657346,
      0.740251,
      0.536974,
      0,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      1.881816,
      0,
      1.170882,
      1,
      NULL,
      1.767583,
      NULL,
      4,
      7,
      5,
      6.098609,
      1,
      1.119468,
      3.240355,
      1.346084,
      2.895307,
      2.232880,
      1,
      51,
      0,
      1.022100,
      38.749135,
      NULL,
      NULL,
      NULL,
      1.115242,
      4,
      1.519503,
      '10222',
      NULL,
      NULL,
      1.609811,
      '',
      NULL,
      '',
      1.649244,
      '',
      '',
      '',
      0,
      11,
      13.517080,
      NULL,
      0.532638,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.998092,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.262856,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.984834,
      NULL,
      1.695596,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.769069,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.625577,
      2,
      3.066923,
      2.036487,
      1.731009,
      3.441610,
      0,
      0.836085,
      2.056303,
      NULL,
      NULL,
      3,
      3,
      3,
      2.237298,
      1.558587,
      0,
      1.754941,
      3.533537,
      0,
      0.272517,
      3.306774,
      0,
      NULL,
      1.882045,
      NULL,
      NULL,
      0.686651,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.238721,
      4,
      1.793356,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.394390,
      NULL,
      NULL,
      0.362520,
      0,
      0.744147,
      1,
      NULL,
      0.029035,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      0.557506,
      0.549455,
      NULL,
      NULL,
      5.094357,
      NULL,
      NULL,
      1.335281,
      NULL,
      NULL,
      0.036316,
      NULL,
      NULL,
      1.636327,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.900860,
      1.100106,
      0.907519,
      0,
      NULL,
      NULL,
      0.579111,
      NULL,
      1.926248,
      5.325539,
      1,
      2.480590,
      NULL,
      NULL,
      NULL,
      2.713228,
      1,
      3.690062,
      1,
      3,
      3,
      1.935019,
      NULL,
      3.900481,
      5,
      6.212622,
      6,
      2,
      0,
      3.368754,
      1.826352,
      NULL,
      3.482205,
      2.602805,
      3,
      3.058334,
      3.414614,
      0.832375,
      2.863090,
      1,
      NULL,
      1.421241,
      1,
      5,
      1.997896,
      1,
      2,
      3,
      1,
      0,
      1.708638,
      0,
      0.051527,
      NULL,
      NULL,
      NULL,
      0.394373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.137045,
      NULL,
      NULL,
      0.498178,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.483951,
      NULL,
      NULL,
      0.390964,
      NULL,
      NULL,
      NULL,
      0.889329,
      1.592859,
      0,
      NULL,
      2.537981,
      1.681729,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.050395,
      NULL,
      NULL,
      NULL,
      0.954117,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.192866,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.931490,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.877021,
      NULL,
      NULL,
      NULL,
      1.359253,
      NULL,
      NULL,
      NULL,
      1.257525,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.784072,
      NULL,
      NULL,
      1.421067,
      NULL,
      NULL,
      0,
      NULL,
      1.210510,
      131.161213,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.418256,
      0,
      1.715848,
      NULL,
      NULL,
      0.086911,
      NULL,
      0.528382,
      1,
      1.028834,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.373041,
      1.412132,
      1,
      1,
      6,
      1.355592,
      3,
      6.915701,
      NULL,
      NULL,
      1.399226,
      NULL,
      1,
      NULL,
      1,
      0.695401,
      NULL,
      2.692272,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.214753,
      1,
      NULL,
      2.419178,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.384136,
      NULL,
      1.806762,
      0.072490,
      NULL,
      NULL,
      0,
      1.861472,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.765065,
      NULL,
      0.880286,
      NULL,
      5.988662,
      6.876628,
      1.759518,
      0,
      0,
      3.234518,
      NULL,
      83.681838,
      5.457937,
      4,
      1.169305,
      '24314',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


