set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8200571';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-7-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1,
      1,
      3.004637,
      1.959712,
      1.321779,
      3.318968,
      2,
      NULL,
      '023',
      '30411444',
      84,
      37,
      NULL,
      NULL,
      0.032721,
      2,
      2,
      '3141',
      NULL,
      0.837617,
      NULL,
      NULL,
      ' 3- 6-1995',
      106.980389,
      182,
      NULL,
      0.899086,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.228326,
      NULL,
      ' 2-12-1993',
      NULL,
      2,
      1.914061,
      1,
      NULL,
      0.784669,
      1.339985,
      NULL,
      1,
      1,
      51.220521,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3.448185,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      9,
      0.092765,
      0.883620,
      1,
      1.556966,
      1,
      2.189824,
      NULL,
      0.755692,
      0,
      0.396534,
      1,
      NULL,
      0,
      5,
      3,
      1.645273,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.957707,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      0.290523,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      NULL,
      6,
      1.068390,
      NULL,
      8.745360,
      NULL,
      0.283450,
      NULL,
      NULL,
      2.067842,
      5.061926,
      1.202365,
      9,
      1.913224,
      1.598541,
      0,
      0,
      0,
      NULL,
      0.011073,
      NULL,
      3,
      2.168785,
      3.414065,
      5,
      0.343281,
      1.978934,
      1.141911,
      1,
      3.306400,
      3,
      0,
      1.823654,
      1.871407,
      4,
      6.132922,
      1,
      1,
      2,
      7,
      9,
      4.369898,
      0,
      NULL,
      0.236697,
      4,
      1,
      ' 3-23-1992',
      NULL,
      '10- 3-1978',
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.498429,
      5,
      1,
      4,
      1.060699,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.429916,
      NULL,
      0.119680,
      3.067764,
      0.882279,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.810191,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.315679,
      NULL,
      1,
      0,
      0.038484,
      1,
      15.267301,
      3.043835,
      1.241219,
      NULL,
      NULL,
      NULL,
      3.872738,
      1,
      NULL,
      NULL,
      3.107753,
      0.370057,
      NULL,
      3,
      NULL,
      3.678861,
      1,
      3.344126,
      0,
      2.787371,
      3,
      3,
      6,
      NULL,
      NULL,
      1.896924,
      0,
      1,
      1.336655,
      0.222331,
      NULL,
      1,
      NULL,
      1.846356,
      1.113681,
      0.020025,
      3,
      1.999049,
      4.624534,
      8,
      0,
      NULL,
      1.252452,
      6,
      4,
      1.687235,
      4.971774,
      3.171718,
      1.712420,
      3.916541,
      14,
      2.925991,
      1.295859,
      NULL,
      NULL,
      35,
      29.366222,
      2.405391,
      0.493054,
      0.826577,
      '01342',
      '',
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      2,
      NULL,
      147.245211,
      22.284650,
      3.244015,
      8.404059,
      6.144397,
      0.818969,
      5,
      NULL,
      3.149244,
      1.392104,
      0.679958,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.527639,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.337794,
      NULL,
      NULL,
      2.998053,
      1.479832,
      NULL,
      1.120258,
      NULL,
      NULL,
      2.706767,
      1.096959,
      1.275368,
      1,
      NULL,
      NULL,
      0.130592,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.977522,
      4.344013,
      5,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.827441,
      NULL,
      NULL,
      NULL,
      NULL,
      0.867508,
      0,
      2,
      1,
      2,
      3.029230,
      3.786012,
      1,
      2,
      NULL,
      0.857924,
      1,
      NULL,
      3.008089,
      2,
      3.811448,
      1,
      NULL,
      3,
      1.983577,
      3,
      0.051842,
      0.241464,
      NULL,
      1.707991,
      NULL,
      NULL,
      1.603946,
      NULL,
      NULL,
      0,
      1.078086,
      1,
      2.202031,
      0.729443,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      1.060087,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      2.321014,
      NULL,
      1.897552,
      2.026944,
      NULL,
      NULL,
      5,
      1,
      1,
      0.233754,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.223332,
      NULL,
      NULL,
      1.583339,
      NULL,
      NULL,
      0.728235,
      0,
      1.642712,
      6,
      1.067513,
      0.637848,
      7.858046,
      1.086390,
      1.016442,
      NULL,
      0.833714,
      1.458993,
      1.204528,
      0,
      0,
      2,
      1.655515,
      0,
      0,
      1.516740,
      NULL,
      8.791542,
      1,
      NULL,
      1,
      0.225312,
      0.652895,
      0,
      1.790375,
      NULL,
      0,
      1,
      3.428123,
      1,
      1,
      1.879246,
      7,
      1,
      3,
      3.895773,
      NULL,
      0,
      1.426764,
      3,
      0,
      1,
      1.660936,
      NULL,
      1,
      NULL,
      1.940718,
      NULL,
      NULL,
      2.142031,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.828371,
      NULL,
      NULL,
      1.856594,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.834542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.411792,
      NULL,
      NULL,
      NULL,
      0.376467,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.470543,
      NULL,
      NULL,
      NULL,
      0.633545,
      NULL,
      NULL,
      NULL,
      0.672187,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.050755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.368371,
      NULL,
      NULL,
      NULL,
      0.706090,
      NULL,
      NULL,
      NULL,
      11.810838,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3,
      NULL,
      3.217739,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1.268408,
      NULL,
      0.730584,
      461,
      14.809440,
      1,
      0,
      1,
      0.940122,
      NULL,
      0,
      0.632894,
      1.092390,
      0.915348,
      0.212073,
      1.076625,
      NULL,
      1,
      0.760157,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.246774,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.470196,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.303427,
      0.867864,
      1.748966,
      0.619820,
      0,
      0.174631,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.339219,
      3.526086,
      3.208075,
      8,
      1,
      1,
      1.199859,
      2,
      4.389698,
      3.539971,
      NULL,
      NULL,
      0.040909,
      0,
      NULL,
      0,
      1.735028,
      NULL,
      1,
      NULL,
      NULL,
      3.857091,
      2,
      NULL,
      NULL,
      0.433551,
      NULL,
      0.958366,
      0,
      NULL,
      2.501222,
      3.350659,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.034191,
      NULL,
      1,
      0,
      NULL,
      2.075835,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.643826,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.125464,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      32.650755,
      60.031854,
      NULL,
      0,
      1.895982,
      '02042',
      '',
      NULL,
      0,
      '',
      '',
      NULL,
      0,
      '',
      '',
      NULL);
commit;
end;
/


