set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9608507';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-9-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      1.525304,
      3,
      1.320754,
      2.066419,
      2,
      0.720020,
      2,
      '243',
      '21211300',
      NULL,
      6,
      '3033403',
      5,
      1,
      NULL,
      NULL,
      '3043',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-29-1992',
      NULL,
      120,
      NULL,
      2.927480,
      3,
      ' 7- 6-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-29-2001',
      ' 7- 9-2000',
      ' 2-19-1984',
      3,
      2,
      3.823568,
      3.931230,
      0,
      1,
      NULL,
      0.423039,
      1.744972,
      4,
      NULL,
      12,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      5.281748,
      0.191071,
      NULL,
      3.307546,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.268928,
      NULL,
      5.285498,
      NULL,
      1.956539,
      5.388035,
      3.586061,
      1,
      1,
      2,
      0.424551,
      NULL,
      1,
      0,
      3,
      1,
      0.053861,
      3,
      0.369914,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.841530,
      1.461726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1.980441,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.426190,
      0.231908,
      1.552011,
      1,
      7,
      1.290832,
      1.826405,
      2.287272,
      0.838835,
      1,
      2,
      1,
      1.049803,
      1.166616,
      0,
      0.368289,
      0.250630,
      1.808813,
      NULL,
      1.646107,
      1,
      NULL,
      1,
      0.544951,
      NULL,
      2.759761,
      7.716007,
      0,
      2,
      0.085600,
      4,
      3.600062,
      7.315871,
      6,
      6.905669,
      7.371298,
      5.811612,
      0.636848,
      6,
      5,
      4.218327,
      7.063317,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      539,
      NULL,
      NULL,
      NULL,
      0,
      0.606834,
      1.812540,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.223986,
      0,
      0.085085,
      0.264748,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      5.251195,
      1,
      NULL,
      1.168521,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.524939,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.396635,
      NULL,
      1,
      1,
      1.888574,
      1.269967,
      0,
      0.085419,
      10.913507,
      0.621453,
      0,
      NULL,
      NULL,
      NULL,
      1.259698,
      0,
      2.254025,
      0.222736,
      3,
      NULL,
      NULL,
      2,
      0,
      3,
      3.290236,
      NULL,
      1,
      0.420366,
      4.646259,
      0,
      0,
      0,
      0.570057,
      2.692391,
      NULL,
      NULL,
      1,
      1.355510,
      NULL,
      1,
      0.430309,
      NULL,
      NULL,
      0.802869,
      5,
      0,
      NULL,
      2.222636,
      6.121047,
      3,
      0,
      3.184449,
      4,
      2,
      2,
      3,
      2,
      0.948588,
      32,
      0.503327,
      NULL,
      5,
      NULL,
      35,
      52.807564,
      4,
      4.390386,
      NULL,
      '22033',
      '',
      '',
      0.279097,
      NULL,
      NULL,
      '',
      0.215827,
      NULL,
      NULL,
      NULL,
      1.940428,
      40.151803,
      33,
      45.953547,
      NULL,
      30,
      NULL,
      NULL,
      5,
      3,
      NULL,
      2,
      0.163935,
      NULL,
      NULL,
      0.984408,
      NULL,
      NULL,
      NULL,
      3,
      0.409654,
      1,
      0.957292,
      2,
      0,
      NULL,
      NULL,
      3.072078,
      3,
      0.598598,
      1.291188,
      0,
      NULL,
      3.295054,
      0,
      NULL,
      1.571459,
      0.982125,
      0.621384,
      1,
      0,
      1.844229,
      0,
      NULL,
      NULL,
      6.428131,
      8.967631,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.565729,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      3.228520,
      0,
      0.164945,
      NULL,
      2.526053,
      0,
      NULL,
      NULL,
      0.350616,
      2.089456,
      NULL,
      3.832091,
      1,
      3.316071,
      2,
      2.480658,
      1,
      0.516139,
      0,
      1.179426,
      0.626832,
      2,
      1.620517,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.898155,
      1,
      8,
      2.226552,
      6.147019,
      3,
      1.609971,
      NULL,
      NULL,
      NULL,
      1.039583,
      NULL,
      NULL,
      NULL,
      0.933621,
      NULL,
      NULL,
      0.690955,
      NULL,
      NULL,
      NULL,
      0.780464,
      1,
      1.811178,
      NULL,
      NULL,
      6.290421,
      9,
      NULL,
      0,
      3,
      NULL,
      0,
      3.660537,
      0,
      0,
      5,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.584794,
      NULL,
      NULL,
      0.412982,
      NULL,
      NULL,
      4,
      3.656578,
      1,
      1,
      NULL,
      NULL,
      1,
      3,
      1.650595,
      1,
      1,
      NULL,
      3.846889,
      2,
      2.120489,
      NULL,
      2,
      4,
      0,
      3.966448,
      3,
      NULL,
      3,
      NULL,
      1.726557,
      1,
      2.064862,
      0,
      0,
      0,
      6.817927,
      1.816301,
      4,
      0,
      NULL,
      NULL,
      0.261705,
      NULL,
      4,
      1,
      1.414968,
      0,
      0,
      0.630730,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.012763,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.367587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.770768,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      1.510602,
      0,
      0.558344,
      1,
      3.501012,
      0.993696,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      5.285552,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.191591,
      NULL,
      NULL,
      NULL,
      1.836563,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.065065,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.365123,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.318240,
      NULL,
      NULL,
      NULL,
      1.341233,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      7.828231,
      NULL,
      NULL,
      NULL,
      0.775754,
      NULL,
      NULL,
      NULL,
      0.677885,
      90.578411,
      24.927687,
      NULL,
      2.672426,
      NULL,
      1.792108,
      NULL,
      NULL,
      0.231745,
      NULL,
      NULL,
      0.199231,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.682005,
      NULL,
      0.244265,
      1.638894,
      4.267758,
      0,
      3,
      0,
      NULL,
      0.793498,
      3,
      1.446906,
      2.645923,
      1,
      3,
      NULL,
      0,
      NULL,
      3.557049,
      1.820911,
      1,
      1.282378,
      0.348436,
      NULL,
      NULL,
      NULL,
      2.736645,
      NULL,
      3.660233,
      NULL,
      3.076577,
      NULL,
      3.541251,
      NULL,
      65,
      NULL,
      2,
      4,
      5.950494,
      2.055614,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.533429,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.489012,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.007814,
      NULL,
      1.603814,
      NULL,
      1.147631,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.011474,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.409146,
      1.304502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.338315,
      1.286949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.589778,
      NULL,
      2.500992,
      NULL,
      2.787632,
      NULL,
      33,
      NULL,
      2,
      0,
      1,
      NULL,
      3,
      NULL,
      1,
      NULL,
      170,
      NULL,
      1.393052,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      36,
      NULL,
      3.328114,
      2.265434,
      1,
      NULL,
      1.588449,
      1.223949,
      0,
      1.880656,
      1,
      0,
      1.202825,
      NULL,
      NULL,
      NULL,
      2.771791,
      0,
      1.036025,
      3.194343,
      NULL,
      1,
      1,
      NULL,
      1.842265,
      1.315028,
      NULL,
      0,
      0,
      NULL,
      0,
      0.179633,
      NULL,
      1.633842,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.101194,
      NULL,
      1,
      1,
      NULL,
      0.663062,
      NULL,
      NULL,
      0.752808,
      1,
      NULL,
      2,
      1.392310,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.043679,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.921868,
      NULL,
      1,
      NULL,
      0.724065,
      NULL,
      0,
      5,
      NULL,
      1.291337,
      NULL,
      NULL,
      8,
      32.757765,
      2,
      1.032836,
      2.930298,
      '21400',
      '00001',
      '21442',
      1.474380,
      '',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


