set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9308280';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-4-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      '1243213',
      0.709986,
      1,
      1,
      1,
      '1100',
      2,
      1.157450,
      NULL,
      NULL,
      ' 9-14-1983',
      6.641264,
      NULL,
      5.389841,
      NULL,
      NULL,
      ' 5- 6-1993',
      65,
      2,
      232.732640,
      9,
      0.847597,
      ' 2-20-1988',
      ' 5-17-1980',
      NULL,
      NULL,
      3,
      0,
      NULL,
      0.274558,
      1,
      3,
      1.121878,
      NULL,
      NULL,
      NULL,
      8.292567,
      5.921076,
      12,
      12.519127,
      1,
      26.869826,
      7.325806,
      NULL,
      6.403590,
      0,
      NULL,
      0.900145,
      1,
      3.901174,
      0.708267,
      0,
      1,
      NULL,
      0.724793,
      NULL,
      1.387310,
      1.290753,
      0,
      1.288237,
      1,
      0.269773,
      NULL,
      0,
      9.505311,
      1,
      11,
      4.998592,
      NULL,
      1.072269,
      7.978332,
      1,
      10,
      0,
      NULL,
      3.569409,
      0.773448,
      0,
      NULL,
      NULL,
      1.623283,
      NULL,
      NULL,
      3.104393,
      2.686782,
      3,
      1.678989,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.783897,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.538109,
      9,
      10,
      2,
      7.906685,
      NULL,
      NULL,
      1.088861,
      0.247948,
      1.834248,
      1,
      3,
      0.530182,
      NULL,
      0.276804,
      NULL,
      NULL,
      0,
      0.253699,
      NULL,
      NULL,
      0,
      0.258381,
      1,
      3.271768,
      0,
      NULL,
      8,
      3,
      3,
      2,
      0.642646,
      3.555894,
      9,
      2,
      NULL,
      4.264764,
      5,
      5.139418,
      NULL,
      2,
      0.143702,
      6.273742,
      8.569378,
      1,
      2.378380,
      7.203166,
      3.828626,
      ' 4-28-1976',
      345,
      ' 2-22-1999',
      264.114336,
      3,
      0,
      0.531251,
      4.878376,
      0.927674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.373525,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      6,
      0.633203,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.970205,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.517590,
      2.692883,
      0.147195,
      2,
      1,
      0,
      3,
      1.377785,
      2.615549,
      0,
      0,
      13.843357,
      6,
      1.422867,
      3.920928,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3.786311,
      4.199502,
      1.160954,
      7.964611,
      1,
      NULL,
      0,
      NULL,
      2,
      0,
      NULL,
      35,
      1,
      2,
      NULL,
      15,
      NULL,
      70.888368,
      3.367253,
      NULL,
      0,
      '14141',
      '',
      '',
      0,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      NULL,
      0,
      NULL,
      70.753379,
      31.556852,
      3,
      24,
      0.765922,
      1.117583,
      2,
      2,
      0,
      3,
      1.059669,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0.619468,
      NULL,
      NULL,
      0,
      1,
      1.924420,
      3,
      1.973171,
      0,
      1.677510,
      0,
      NULL,
      1,
      NULL,
      NULL,
      3.428795,
      2.730380,
      2.209170,
      1.584502,
      3.416032,
      3.897337,
      3.636913,
      0.002867,
      7,
      0.467777,
      1.379004,
      NULL,
      NULL,
      NULL,
      0.550699,
      NULL,
      NULL,
      NULL,
      1.119825,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.936731,
      NULL,
      NULL,
      0.156693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.671575,
      6.326068,
      1,
      3.798895,
      1.572318,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.140017,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.473839,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.123670,
      0.151866,
      0.518337,
      NULL,
      NULL,
      4,
      1.592994,
      0.807592,
      8,
      2,
      0,
      NULL,
      1,
      1.612475,
      1,
      0,
      3,
      2.872616,
      2.108124,
      NULL,
      0,
      1.209736,
      1,
      6,
      4,
      3,
      1.506386,
      0,
      NULL,
      2.802762,
      1,
      1.604074,
      0.873543,
      1.411543,
      1,
      0.078495,
      0,
      0,
      1,
      5,
      NULL,
      NULL,
      NULL,
      7,
      0,
      2.532025,
      7.150001,
      1.553819,
      1.144778,
      1.823525,
      1,
      NULL,
      2,
      NULL,
      NULL,
      1.489201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.433848,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.848574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.638629,
      NULL,
      1.044647,
      0.930064,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.102637,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.027642,
      NULL,
      NULL,
      NULL,
      0.546495,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.395869,
      NULL,
      NULL,
      NULL,
      2.957306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      6,
      2.978981,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.417091,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.621423,
      NULL,
      0.552929,
      0.490009,
      NULL,
      0,
      1,
      0.930010,
      0.336808,
      0.657592,
      1,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.864155,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1.825488,
      3.049838,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      2.890480,
      0.947856,
      1.644162,
      1.520112,
      NULL,
      1.735406,
      0.475782,
      NULL,
      1,
      0.973547,
      NULL,
      0.969211,
      1.941623,
      NULL,
      1.489199,
      0.423315,
      NULL,
      1.171986,
      2.301502,
      NULL,
      0.990936,
      1,
      NULL,
      1.145890,
      NULL,
      NULL,
      0.939724,
      1.639975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.436823,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.066816,
      NULL,
      1.855313,
      NULL,
      7.450560,
      3.441327,
      7,
      0.041363,
      NULL,
      NULL,
      74.721725,
      94,
      5.337803,
      0,
      3.266487,
      '02010',
      '',
      NULL,
      0,
      '',
      '',
      '',
      0.539075,
      '',
      '',
      NULL);
commit;
end;
/


