set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8405797';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-6-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      3,
      0.645899,
      NULL,
      0,
      '2324',
      0.679215,
      NULL,
      NULL,
      NULL,
      ' 4-11-1989',
      62,
      NULL,
      5.272299,
      3,
      3,
      NULL,
      1.473074,
      1,
      NULL,
      112,
      1,
      ' 0-11-1982',
      ' 6- 2-1992',
      ' 8- 0-1979',
      3.748702,
      NULL,
      3.054445,
      NULL,
      1,
      NULL,
      3.625267,
      1,
      NULL,
      NULL,
      NULL,
      4.599629,
      9.343433,
      2,
      3,
      5,
      20.477338,
      1,
      NULL,
      7,
      0.207829,
      1,
      2.440286,
      NULL,
      0,
      1.438640,
      1.957389,
      NULL,
      0.395866,
      0.276811,
      1,
      3.736690,
      7,
      0.452610,
      NULL,
      7,
      NULL,
      1,
      0.788861,
      5.494041,
      NULL,
      8.089730,
      NULL,
      NULL,
      7,
      0,
      7.276965,
      9,
      0.850981,
      5,
      1,
      1,
      1.252571,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6.770234,
      2.576895,
      4,
      0,
      1,
      2.722818,
      1.137270,
      NULL,
      1,
      1,
      2,
      0,
      1,
      NULL,
      0.832549,
      0,
      3.137260,
      0,
      3.940737,
      2,
      NULL,
      6.115495,
      NULL,
      0,
      1.021608,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      6,
      3.370626,
      1,
      NULL,
      2,
      0.698568,
      1,
      2.268735,
      2,
      5,
      2.892641,
      1.898353,
      0,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      0.285293,
      0,
      5.735851,
      1,
      NULL,
      7,
      4,
      6,
      0,
      NULL,
      2,
      1,
      NULL,
      2.122698,
      6.745005,
      7.336863,
      0,
      0,
      NULL,
      NULL,
      6.786622,
      3.547973,
      1,
      3,
      4,
      NULL,
      2.932901,
      1.031045,
      ' 7-15-1983',
      189,
      ' 6-17-1991',
      NULL,
      1.166089,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.269257,
      1,
      0,
      0.344631,
      0,
      0,
      1.497402,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.540483,
      NULL,
      8.189780,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.120556,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.816148,
      1,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.669259,
      NULL,
      0.691272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.933826,
      0,
      NULL,
      1.348316,
      0,
      NULL,
      1.706518,
      0,
      30,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.328717,
      2,
      1,
      NULL,
      1,
      1,
      3,
      NULL,
      3.892341,
      NULL,
      0.408566,
      0.151980,
      3.248781,
      1,
      3,
      0.701284,
      1,
      1.638670,
      0,
      0,
      1,
      3.129272,
      0,
      0,
      1,
      0.351181,
      1,
      0,
      1,
      NULL,
      0.882109,
      NULL,
      11.607569,
      3,
      10.437930,
      9,
      4,
      NULL,
      3.151409,
      3.322968,
      2,
      3.528583,
      NULL,
      46.693142,
      3.817379,
      3.347609,
      NULL,
      27,
      38,
      NULL,
      3,
      0,
      3.707480,
      '33014',
      NULL,
      '',
      1.378865,
      '',
      '',
      '',
      0.839731,
      '',
      '',
      '',
      NULL,
      NULL,
      37.903695,
      0.300287,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0.652953,
      NULL,
      NULL,
      NULL,
      0.277227,
      0.745440,
      2,
      0.333803,
      NULL,
      NULL,
      3,
      0.349748,
      3,
      NULL,
      NULL,
      NULL,
      0.209678,
      NULL,
      0,
      1.302394,
      NULL,
      NULL,
      0.201725,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.099397,
      0.816697,
      NULL,
      NULL,
      3,
      NULL,
      5,
      1,
      1.066814,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.662342,
      0.635095,
      NULL,
      0.065494,
      3.241327,
      0,
      NULL,
      3.266017,
      0.840513,
      NULL,
      0,
      0,
      NULL,
      0.766557,
      1.690959,
      3.659919,
      0.133649,
      1.781948,
      NULL,
      0.783104,
      2.327636,
      NULL,
      2,
      1.403509,
      NULL,
      0.521797,
      NULL,
      2,
      1.588602,
      1,
      0,
      1.425587,
      3,
      1,
      8,
      NULL,
      1,
      1.364082,
      1.764172,
      NULL,
      NULL,
      NULL,
      1.807334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0,
      0.986378,
      NULL,
      1.630501,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.873979,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.439005,
      NULL,
      NULL,
      1.190052,
      NULL,
      NULL,
      0.493946,
      NULL,
      NULL,
      0.294454,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.783675,
      NULL,
      NULL,
      0.310314,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.798353,
      NULL,
      NULL,
      3,
      NULL,
      0.152120,
      1,
      0.596684,
      1,
      5.072591,
      3,
      3,
      NULL,
      0,
      NULL,
      3,
      2.662963,
      NULL,
      2,
      3.613935,
      2,
      3,
      2,
      NULL,
      6,
      7.533065,
      0,
      0.462274,
      1.652005,
      3.038820,
      3,
      NULL,
      1,
      0.507622,
      1,
      NULL,
      NULL,
      3.654748,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.036037,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.632230,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.380072,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.177679,
      1.985893,
      1,
      NULL,
      0.409900,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.750345,
      NULL,
      NULL,
      NULL,
      1.482748,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.862347,
      NULL,
      NULL,
      NULL,
      1.682452,
      NULL,
      NULL,
      NULL,
      0.535485,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.088251,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.166162,
      NULL,
      NULL,
      NULL,
      NULL,
      2.039266,
      6,
      1.443216,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.772548,
      NULL,
      0.623019,
      0,
      2.662405,
      1,
      1.176903,
      0.129936,
      1.097017,
      0,
      0.950583,
      1.162481,
      0,
      1.354057,
      1.958327,
      1,
      NULL,
      0.860172,
      1.455091,
      1,
      1,
      0.748144,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.235229,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.481317,
      3,
      NULL,
      0.452244,
      NULL,
      0.109526,
      NULL,
      NULL,
      NULL,
      0.097130,
      NULL,
      1.632244,
      NULL,
      1,
      NULL,
      0.563680,
      1.612958,
      1.365958,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.749590,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0.761592,
      0,
      0.130053,
      0.449096,
      0,
      2,
      0.606446,
      2.914821,
      0.236262,
      1.758742,
      1.386295,
      NULL,
      0.079532,
      1.205724,
      NULL,
      0.811625,
      1.759101,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.602403,
      NULL,
      1.261699,
      1,
      NULL,
      1.462267,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.287258,
      0,
      NULL,
      3,
      1.329813,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.038187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.497685,
      NULL,
      5.766091,
      0.429207,
      NULL,
      1.862059,
      NULL,
      NULL,
      43.914506,
      44.683336,
      1,
      1.682878,
      2,
      '12334',
      '',
      '',
      1.523940,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


