set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9834038';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-5-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      1.197125,
      1,
      1,
      3.603836,
      3,
      3.746362,
      0.983722,
      '341',
      '41121201',
      45,
      15.877408,
      NULL,
      NULL,
      1,
      4,
      2,
      '2144',
      3.717606,
      NULL,
      NULL,
      NULL,
      '10-26-1988',
      23,
      7.312669,
      NULL,
      0,
      1.774613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 6-27-1988',
      ' 6-16-1994',
      '11-10-1992',
      0,
      1.335124,
      3.430944,
      0.776729,
      0.892165,
      1.277471,
      3,
      1,
      1,
      NULL,
      8,
      5.017581,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.171624,
      NULL,
      0,
      3.696975,
      0,
      4,
      NULL,
      7,
      0,
      NULL,
      3,
      0,
      1,
      3.731748,
      NULL,
      5,
      0.583358,
      3.263337,
      2.476288,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      1.928672,
      3.826443,
      0,
      0.587899,
      0.460459,
      2.457347,
      3,
      3,
      2.302173,
      NULL,
      0.040293,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      1.144579,
      0,
      0.957013,
      5,
      0.771416,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1.029360,
      NULL,
      NULL,
      5.336105,
      1.801084,
      NULL,
      1,
      5,
      0.727730,
      NULL,
      1,
      1,
      0,
      1.237902,
      0,
      1,
      5.510664,
      NULL,
      1,
      1,
      1.009131,
      0,
      NULL,
      NULL,
      0.057162,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.082973,
      2.109921,
      0.078321,
      NULL,
      NULL,
      5,
      NULL,
      0,
      2,
      2,
      NULL,
      7,
      2,
      1,
      NULL,
      0.415922,
      0,
      3,
      5.347582,
      2,
      ' 1-16-1996',
      44.231803,
      ' 8-21-1976',
      NULL,
      1.981693,
      0.984792,
      0,
      3.759627,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.658026,
      0.155280,
      1.261668,
      3.984999,
      NULL,
      3,
      0,
      0.036065,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.390773,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.528647,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      2,
      1.571915,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.187542,
      0,
      0.717537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.515744,
      0,
      NULL,
      1.598371,
      NULL,
      0,
      1,
      1,
      16.709739,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2.949036,
      1.885785,
      NULL,
      3,
      NULL,
      NULL,
      2,
      0,
      0.294838,
      2,
      2.207757,
      0,
      1,
      NULL,
      0.090401,
      3.855129,
      1.773512,
      0,
      1,
      3.630026,
      1,
      NULL,
      NULL,
      NULL,
      0.832635,
      1.065741,
      1.204870,
      1.091491,
      NULL,
      1.419150,
      2.326376,
      NULL,
      4,
      NULL,
      6.555016,
      4,
      6.611966,
      3,
      5,
      0.623306,
      5.747587,
      3,
      3.144922,
      NULL,
      20,
      NULL,
      1,
      61,
      NULL,
      5.286165,
      16,
      4.805107,
      4.831351,
      3.435635,
      '11100',
      NULL,
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      2.068126,
      9.161319,
      40,
      3.525983,
      2.824040,
      36,
      2,
      2.538936,
      4.514108,
      0.053214,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.303205,
      0.696500,
      2.561702,
      1.638525,
      3,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3,
      2,
      1.140134,
      NULL,
      NULL,
      NULL,
      NULL,
      3.358604,
      1.419622,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      9.896754,
      8.002168,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0.413112,
      NULL,
      NULL,
      NULL,
      3,
      3.068059,
      NULL,
      0.550562,
      NULL,
      NULL,
      0.168931,
      0.710243,
      1.133590,
      2.476109,
      0,
      1,
      1.072649,
      0.495128,
      NULL,
      3,
      NULL,
      0,
      1.642670,
      1,
      1.982000,
      3,
      1,
      1.959978,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      10.843044,
      6.926206,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.485299,
      NULL,
      1,
      0,
      NULL,
      NULL,
      2.076616,
      1,
      3.074829,
      1,
      NULL,
      NULL,
      4,
      4.891828,
      1,
      0.627996,
      1,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3,
      0.064752,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.514097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.108688,
      NULL,
      NULL,
      6.929707,
      4,
      1.996706,
      1,
      NULL,
      NULL,
      3.080629,
      2.921065,
      0.725194,
      3,
      NULL,
      2.040464,
      NULL,
      1.449536,
      1,
      1.244609,
      3.656281,
      0.164757,
      0,
      0.278004,
      0.662402,
      3,
      3,
      3,
      NULL,
      1.320767,
      1,
      3.610061,
      NULL,
      1.351288,
      1,
      1,
      3,
      8,
      NULL,
      5.703017,
      2,
      1,
      3.659816,
      NULL,
      1.205630,
      1.427375,
      0,
      1.650328,
      0,
      NULL,
      NULL,
      1.860039,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.033676,
      NULL,
      NULL,
      1.537744,
      NULL,
      NULL,
      0.868942,
      NULL,
      NULL,
      0.446943,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.859091,
      0,
      1.886062,
      0,
      0,
      0.308232,
      0.874386,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.216901,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.998563,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.290756,
      NULL,
      NULL,
      NULL,
      1.411906,
      NULL,
      NULL,
      NULL,
      2.252887,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.343484,
      43,
      NULL,
      0,
      6,
      6.524964,
      1.434271,
      NULL,
      NULL,
      1.802238,
      NULL,
      NULL,
      3,
      3,
      7,
      0.180724,
      NULL,
      NULL,
      0.720954,
      NULL,
      NULL,
      NULL,
      4.285169,
      0.559823,
      1,
      0.166904,
      NULL,
      1.428843,
      1,
      1,
      1,
      0.336664,
      0,
      0,
      0.553186,
      0,
      1,
      1.339458,
      0,
      0.496587,
      1.259380,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.787042,
      0.546887,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.218044,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.148876,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.988694,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.634174,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.504203,
      1.297651,
      1,
      0.723645,
      1.662749,
      0.175740,
      NULL,
      NULL,
      0.055048,
      0.847143,
      NULL,
      NULL,
      1.373291,
      0.699351,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.124713,
      1.395049,
      NULL,
      3,
      3.696433,
      2,
      13,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1.660498,
      NULL,
      0,
      1.720886,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.812926,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.055644,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.492870,
      NULL,
      NULL,
      0,
      0.996458,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.944455,
      NULL,
      1,
      NULL,
      1.182543,
      NULL,
      NULL,
      13.205971,
      4,
      NULL,
      1,
      2,
      NULL,
      19,
      2,
      4,
      2,
      '23414',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '');
commit;
end;
/


