set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'bestcash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9204382';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-4-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_bestcash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      2.508483,
      3.082062,
      2,
      NULL,
      NULL,
      3.191528,
      NULL,
      '04',
      '40',
      13,
      1.069206,
      '2013332',
      5.737120,
      0.395238,
      4,
      NULL,
      NULL,
      5.348264,
      1.819660,
      NULL,
      NULL,
      NULL,
      109.611356,
      29,
      NULL,
      NULL,
      NULL,
      ' 7-22-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1.559227,
      0,
      0.035453,
      NULL,
      NULL,
      NULL,
      10.652619,
      1.870464,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1,
      3.043012,
      NULL,
      1,
      1,
      1,
      1.244438,
      2.433378,
      0,
      1.490976,
      1,
      1.467030,
      2,
      3,
      0.515791,
      4.371999,
      NULL,
      1.657766,
      0.049689,
      1,
      0,
      NULL,
      0,
      0.165678,
      1,
      1,
      1.534451,
      5,
      0,
      0.445752,
      NULL,
      NULL,
      0.239044,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.259880,
      1.364919,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.526122,
      NULL,
      1.000146,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.698064,
      3,
      0,
      3.305254,
      6.489873,
      3,
      1.741518,
      0,
      7.055938,
      0.640966,
      7.322967,
      1.777911,
      4,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.640807,
      3.295570,
      0.870611,
      0.340659,
      0.717518,
      NULL,
      3,
      NULL,
      1,
      0.083928,
      0.357865,
      1.583397,
      1,
      NULL,
      NULL,
      3.500833,
      9,
      2,
      6,
      4,
      NULL,
      4,
      7,
      9,
      0.437660,
      0,
      0,
      1.988671,
      NULL,
      65,
      ' 9-12-1987',
      138.851718,
      NULL,
      1.398703,
      NULL,
      9,
      1.029636,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.462136,
      0,
      0,
      0.389281,
      3.300687,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      1,
      0.954294,
      2.381022,
      3,
      1,
      1,
      7.082729,
      0,
      3.787836,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.551321,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.623360,
      1.036300,
      NULL,
      1.891916,
      1.960624,
      1,
      5,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.184540,
      1.552275,
      2.612638,
      0,
      2.497048,
      1.843672,
      3.643941,
      NULL,
      3.751395,
      NULL,
      3,
      2,
      3.807765,
      1.030958,
      2.357393,
      1,
      NULL,
      0,
      2,
      1,
      1.637014,
      0.779983,
      NULL,
      1.590334,
      1.739685,
      0,
      NULL,
      1,
      0.698258,
      3.342926,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      6,
      '22104',
      '01211',
      '11033',
      0.849793,
      '',
      NULL,
      '',
      NULL,
      '14033',
      '1234',
      '',
      1.841414,
      NULL,
      42.226936,
      8,
      NULL,
      NULL,
      2.369536,
      1.943064,
      3,
      NULL,
      1.185499,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.626895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.355247,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6,
      6,
      6,
      NULL,
      1.678941,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.581739,
      NULL,
      NULL,
      1.961473,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.666314,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.422534,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3.277455,
      1.839294,
      1,
      NULL,
      NULL,
      3,
      5.117677,
      NULL,
      1.467116,
      1.443062,
      NULL,
      0.477486,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.850304,
      NULL,
      NULL,
      0,
      0,
      2.935821,
      1,
      NULL,
      NULL,
      6.101442,
      5,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2,
      1,
      2.704725,
      3,
      2.358845,
      1,
      2.695210,
      0.022131,
      1.576153,
      NULL,
      2,
      1.210876,
      NULL,
      1,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1.631567,
      0,
      1,
      NULL,
      2,
      NULL,
      2,
      0.544824,
      NULL,
      0,
      NULL,
      1.294130,
      0.259261,
      0.418506,
      4.257786,
      0,
      0,
      1.415267,
      1.914333,
      0,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.733359,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.479972,
      3,
      0.822694,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      31.913186,
      NULL,
      NULL,
      NULL,
      3.375620,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.679359,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.684435,
      NULL,
      NULL,
      NULL,
      0.675607,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.516927,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.755123,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.794388,
      NULL,
      3.759369,
      34.275507,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3.949687,
      NULL,
      0.740751,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.616649,
      0.742887,
      0.958538,
      0,
      1.725623,
      NULL,
      0.690858,
      0,
      1,
      0,
      0.891549,
      0.571630,
      1.940327,
      NULL,
      1.202154,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3,
      NULL,
      4.294328,
      5.185722,
      2,
      2.423067,
      2,
      0.835118,
      1.005517,
      1.183553,
      NULL,
      1,
      0.713608,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.769774,
      0.895503,
      NULL,
      3,
      0.349139,
      NULL,
      3,
      2,
      NULL,
      2,
      3,
      NULL,
      NULL,
      2,
      NULL,
      2.963951,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.732400,
      0,
      1.616448,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.221650,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      4.826204,
      7.292259,
      2.023306,
      1.111231,
      NULL,
      NULL,
      90.939759,
      92,
      1.432325,
      NULL,
      NULL,
      NULL,
      '03114',
      NULL,
      NULL,
      '',
      '',
      '',
      2,
      '21204',
      '4310',
      '');
commit;
end;
/


